/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.parser.helper;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.camel.parser.helper.XmlLineNumberParser;
import org.apache.camel.tooling.util.Strings;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class CamelXmlHelper {
    private static final String CAMEL_NS_SPRING = "http://camel.apache.org/schema/spring";

    private CamelXmlHelper() {
    }

    public static String getSafeAttribute(Node node, String key) {
        Node attr;
        if (node != null && (attr = node.getAttributes().getNamedItem(key)) != null) {
            return attr.getNodeValue();
        }
        return null;
    }

    public static List<Node> findAllEndpoints(Document dom) {
        Node child;
        int i;
        ArrayList<Node> nodes = new ArrayList<Node>();
        NodeList list = CamelXmlHelper.getElementsByTagName(dom, "endpoint");
        for (i = 0; i < list.getLength(); ++i) {
            Node node;
            NamedNodeMap attrs;
            child = list.item(i);
            if (!CamelXmlHelper.isNodeName("endpoint", child)) continue;
            String ns = child.getNamespaceURI();
            if (ns == null && (attrs = child.getAttributes()) != null && (node = attrs.getNamedItem("xmlns")) != null) {
                ns = node.getNodeValue();
            }
            if (ns != null && !ns.contains("camel")) continue;
            nodes.add(child);
        }
        list = CamelXmlHelper.getElementsByTagName(dom, "onException");
        for (i = 0; i < list.getLength(); ++i) {
            child = list.item(i);
            CamelXmlHelper.findAllUrisRecursive(child, nodes);
        }
        list = CamelXmlHelper.getElementsByTagName(dom, "onCompletion");
        for (i = 0; i < list.getLength(); ++i) {
            child = list.item(i);
            CamelXmlHelper.findAllUrisRecursive(child, nodes);
        }
        list = CamelXmlHelper.getElementsByTagName(dom, "intercept");
        for (i = 0; i < list.getLength(); ++i) {
            child = list.item(i);
            CamelXmlHelper.findAllUrisRecursive(child, nodes);
        }
        list = CamelXmlHelper.getElementsByTagName(dom, "interceptFrom");
        for (i = 0; i < list.getLength(); ++i) {
            child = list.item(i);
            CamelXmlHelper.findAllUrisRecursive(child, nodes);
        }
        list = CamelXmlHelper.getElementsByTagName(dom, "interceptSendToEndpoint");
        for (i = 0; i < list.getLength(); ++i) {
            child = list.item(i);
            CamelXmlHelper.findAllUrisRecursive(child, nodes);
        }
        list = CamelXmlHelper.getElementsByTagName(dom, "rest");
        for (i = 0; i < list.getLength(); ++i) {
            child = list.item(i);
            if (!CamelXmlHelper.isNodeName("route", child) && !CamelXmlHelper.isNodeName("to", child)) continue;
            CamelXmlHelper.findAllUrisRecursive(child, nodes);
        }
        list = CamelXmlHelper.getElementsByTagName(dom, "route");
        for (i = 0; i < list.getLength(); ++i) {
            child = list.item(i);
            if (!CamelXmlHelper.isNodeName("route", child)) continue;
            CamelXmlHelper.findAllUrisRecursive(child, nodes);
        }
        return nodes;
    }

    private static void findAllUrisRecursive(Node node, List<Node> nodes) {
        NodeList children;
        String url = CamelXmlHelper.getSafeAttribute(node, "uri");
        if (url != null) {
            nodes.add(node);
        }
        if ((children = node.getChildNodes()) != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (child.getNodeType() != 1) continue;
                CamelXmlHelper.findAllUrisRecursive(child, nodes);
            }
        }
    }

    public static List<Node> findAllRoutes(Document dom) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        NodeList list = CamelXmlHelper.getElementsByTagName(dom, "route");
        for (int i = 0; i < list.getLength(); ++i) {
            Node child = list.item(i);
            if (!CamelXmlHelper.isNodeName("route", child)) continue;
            nodes.add(child);
        }
        return nodes;
    }

    public static List<Node> findAllLanguageExpressions(Document dom, String language) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        NodeList list = CamelXmlHelper.getElementsByTagName(dom, "route");
        for (int i = 0; i < list.getLength(); ++i) {
            Node child = list.item(i);
            if (!CamelXmlHelper.isNodeName("route", child)) continue;
            CamelXmlHelper.findAllLanguageExpressionsRecursive(child, nodes, language);
        }
        return nodes;
    }

    private static void findAllLanguageExpressionsRecursive(Node node, List<Node> nodes, String language) {
        NodeList children;
        if (CamelXmlHelper.isNodeName(language, node)) {
            nodes.add(node);
        }
        if ((children = node.getChildNodes()) != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (child.getNodeType() != 1) continue;
                CamelXmlHelper.findAllLanguageExpressionsRecursive(child, nodes, language);
            }
        }
    }

    public static Element getSelectedCamelElementNode(String key, InputStream resourceInputStream) throws Exception {
        Node selectedNode;
        Document root = CamelXmlHelper.loadCamelXmlFileAsDom(resourceInputStream);
        Element selectedElement = null;
        if (root != null && (selectedNode = CamelXmlHelper.findCamelNodeInDocument(root, key)) instanceof Element) {
            selectedElement = (Element)selectedNode;
        }
        return selectedElement;
    }

    private static Document loadCamelXmlFileAsDom(InputStream resourceInputStream) {
        return XmlLineNumberParser.parseXml(resourceInputStream, "camelContext,routes,rests", CAMEL_NS_SPRING);
    }

    private static Node findCamelNodeInDocument(Document root, String key) {
        Node selectedNode = null;
        if (root != null && !Strings.isNullOrEmpty((String)key)) {
            String[] paths = key.split("/");
            NodeList camels = CamelXmlHelper.getCamelContextElements(root);
            if (camels != null) {
                HashMap<String, Integer> rootNodeCounts = new HashMap<String, Integer>();
                int size = camels.getLength();
                for (int i = 0; i < size; ++i) {
                    Node node = camels.item(i);
                    boolean first = true;
                    for (String path : paths) {
                        if (first) {
                            first = false;
                            String actual = CamelXmlHelper.getIdOrIndex(node, rootNodeCounts);
                            if (!Objects.equals(actual, path)) {
                                node = null;
                            }
                        } else {
                            node = CamelXmlHelper.findCamelNodeForPath(node, path);
                        }
                        if (node == null) break;
                    }
                    if (node == null) continue;
                    return node;
                }
            }
        }
        return selectedNode;
    }

    private static Node findCamelNodeForPath(Node node, String path) {
        NodeList childNodes = node.getChildNodes();
        if (childNodes != null) {
            HashMap<String, Integer> nodeCounts = new HashMap<String, Integer>();
            int size = childNodes.getLength();
            for (int i = 0; i < size; ++i) {
                String actual;
                Node child = childNodes.item(i);
                if (!(child instanceof Element) || !Objects.equals(actual = CamelXmlHelper.getIdOrIndex(child, nodeCounts), path)) continue;
                return child;
            }
        }
        return null;
    }

    private static String getIdOrIndex(Node node, Map<String, Integer> nodeCounts) {
        Object answer = null;
        if (node instanceof Element) {
            Integer countObject;
            Element element = (Element)node;
            String elementName = element.getTagName();
            if ("routes".equals(elementName)) {
                elementName = "camelContext";
            }
            int count = (countObject = nodeCounts.get(elementName)) != null ? countObject : 0;
            nodeCounts.put(elementName, ++count);
            answer = element.getAttribute("id");
            if (Strings.isNullOrEmpty((String)answer)) {
                answer = "_" + elementName + count;
            }
        }
        return answer;
    }

    private static NodeList getCamelContextElements(Document dom) {
        NodeList camels = dom.getElementsByTagName("camelContext");
        if (camels == null || camels.getLength() == 0) {
            camels = dom.getElementsByTagName("routes");
        }
        return camels;
    }

    private static NodeList getElementsByTagName(Document dom, String tagName) {
        NodeList list = dom.getElementsByTagName(tagName);
        if (list.getLength() == 0) {
            list = dom.getElementsByTagNameNS(CAMEL_NS_SPRING, tagName);
        }
        return list;
    }

    private static boolean isNodeName(String name, Node node) {
        return name.equals(node.getLocalName()) || name.equals(node.getNodeName());
    }
}

