/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.parser.helper;

import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.helpers.DefaultHandler;

public final class XmlLineNumberParser {
    public static final String LINE_NUMBER = "lineNumber";
    public static final String COLUMN_NUMBER = "colNumber";
    public static final String LINE_NUMBER_END = "lineNumberEnd";
    public static final String COLUMN_NUMBER_END = "colNumberEnd";

    private XmlLineNumberParser() {
    }

    public static Document parseXml(InputStream is) throws Exception {
        return XmlLineNumberParser.parseXml(is, null, null);
    }

    public static Document parseXml(InputStream is, final String rootNames, final String forceNamespace) throws Exception {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        SAXParser parser = factory.newSAXParser();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        dbf.setNamespaceAware(true);
        dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        dbf.setFeature("http://xml.org/sax/features/namespaces", false);
        dbf.setFeature("http://xml.org/sax/features/validation", false);
        dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
        dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
        dbf.setXIncludeAware(false);
        dbf.setExpandEntityReferences(false);
        DocumentBuilder docBuilder = dbf.newDocumentBuilder();
        final Document doc = docBuilder.newDocument();
        final Stack elementStack = new Stack();
        final StringBuilder textBuffer = new StringBuilder();
        DefaultHandler handler = new DefaultHandler(){
            private Locator locator;
            private boolean found;
            private final Map<String, String> localNs = new HashMap<String, String>();
            private final Map<String, String> anonymousNs = new LinkedHashMap<String, String>();

            @Override
            public void setDocumentLocator(Locator locator) {
                this.locator = locator;
                this.found = rootNames == null;
            }

            private boolean isRootName(String qName) {
                for (String root : rootNames.split(",")) {
                    if (!qName.equals(root)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) {
                this.addTextIfNeeded();
                if (rootNames != null && !this.found && this.isRootName(qName)) {
                    this.found = true;
                }
                if (this.found) {
                    Element el;
                    if (forceNamespace != null) {
                        el = doc.createElementNS(forceNamespace, qName);
                    } else {
                        String ns = null;
                        int pos = qName.indexOf(58);
                        if (pos > 0) {
                            if (attributes != null) {
                                String prefix = qName.substring(0, pos);
                                ns = attributes.getValue("xmlns:" + prefix);
                                if (ns != null) {
                                    this.localNs.put(prefix, ns);
                                } else {
                                    ns = this.localNs.get(prefix);
                                }
                            }
                        } else if (attributes != null) {
                            ns = attributes.getValue("xmlns");
                            if (ns != null) {
                                this.anonymousNs.put(qName, ns);
                            } else if (!this.anonymousNs.isEmpty()) {
                                ArrayList<String> values = new ArrayList<String>(this.anonymousNs.values());
                                ns = (String)values.get(values.size() - 1);
                            }
                        }
                        el = ns != null ? doc.createElementNS(ns, qName) : doc.createElement(qName);
                    }
                    if (attributes != null) {
                        for (int i = 0; i < attributes.getLength(); ++i) {
                            el.setAttribute(attributes.getQName(i), attributes.getValue(i));
                        }
                    }
                    String ln = String.valueOf(this.locator.getLineNumber());
                    String cn = String.valueOf(this.locator.getColumnNumber());
                    el.setUserData(XmlLineNumberParser.LINE_NUMBER, ln, null);
                    el.setUserData(XmlLineNumberParser.COLUMN_NUMBER, cn, null);
                    elementStack.push(el);
                }
            }

            @Override
            public void endElement(String uri, String localName, String qName) {
                Element closedEl;
                if (!this.found) {
                    return;
                }
                this.addTextIfNeeded();
                Element element = closedEl = elementStack.isEmpty() ? null : (Element)elementStack.pop();
                if (closedEl != null) {
                    if (elementStack.isEmpty()) {
                        doc.appendChild(closedEl);
                    } else {
                        Element parentEl = (Element)elementStack.peek();
                        parentEl.appendChild(closedEl);
                    }
                    String ln = String.valueOf(this.locator.getLineNumber());
                    String cn = String.valueOf(this.locator.getColumnNumber());
                    closedEl.setUserData(XmlLineNumberParser.LINE_NUMBER_END, ln, null);
                    closedEl.setUserData(XmlLineNumberParser.COLUMN_NUMBER_END, cn, null);
                }
                this.anonymousNs.remove(qName);
            }

            @Override
            public void characters(char[] ch, int start, int length) {
                textBuffer.append(ch, start, length);
            }

            @Override
            public InputSource resolveEntity(String publicId, String systemId) {
                return new InputSource(new StringReader(""));
            }

            private void addTextIfNeeded() {
                if (textBuffer.length() > 0) {
                    Element el;
                    Element element = el = elementStack.isEmpty() ? null : (Element)elementStack.peek();
                    if (el != null) {
                        Text textNode = doc.createTextNode(textBuffer.toString());
                        el.appendChild(textNode);
                        textBuffer.delete(0, textBuffer.length());
                    }
                }
            }
        };
        parser.parse(is, handler);
        return doc;
    }
}

