/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest.openapi;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.camel.AfterPropertiesConfigured;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.RouteAware;
import org.apache.camel.Service;
import org.apache.camel.component.platform.http.spi.PlatformHttpConsumerAware;
import org.apache.camel.component.rest.openapi.OpenApiUtils;
import org.apache.camel.component.rest.openapi.RestOpenApiConsumerPath;
import org.apache.camel.component.rest.openapi.RestOpenApiEndpoint;
import org.apache.camel.component.rest.openapi.RestOpenapiProcessorStrategy;
import org.apache.camel.http.base.HttpHelper;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.support.RestConsumerContextPathMatcher;
import org.apache.camel.support.processor.RestBindingAdvice;
import org.apache.camel.support.processor.RestBindingAdviceFactory;
import org.apache.camel.support.processor.RestBindingConfiguration;
import org.apache.camel.support.service.ServiceHelper;

public class RestOpenApiProcessor
extends AsyncProcessorSupport
implements CamelContextAware,
AfterPropertiesConfigured {
    private static final List<String> METHODS = Arrays.asList("GET", "HEAD", "POST", "PUT", "DELETE", "PATCH");
    private CamelContext camelContext;
    private final RestOpenApiEndpoint endpoint;
    private final OpenAPI openAPI;
    private final String basePath;
    private final String apiContextPath;
    private final List<RestConsumerContextPathMatcher.ConsumerPath<Operation>> paths = new ArrayList<RestConsumerContextPathMatcher.ConsumerPath<Operation>>();
    private final RestOpenapiProcessorStrategy restOpenapiProcessorStrategy;
    private PlatformHttpConsumerAware platformHttpConsumer;
    private Consumer consumer;
    private OpenApiUtils openApiUtils;

    public RestOpenApiProcessor(RestOpenApiEndpoint endpoint, OpenAPI openAPI, String basePath, String apiContextPath, RestOpenapiProcessorStrategy restOpenapiProcessorStrategy) {
        this.endpoint = endpoint;
        this.basePath = basePath;
        this.apiContextPath = apiContextPath != null && !apiContextPath.startsWith("/") ? "/" + apiContextPath : apiContextPath;
        this.openAPI = openAPI;
        this.restOpenapiProcessorStrategy = restOpenapiProcessorStrategy;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public PlatformHttpConsumerAware getPlatformHttpConsumer() {
        return this.platformHttpConsumer;
    }

    public void setPlatformHttpConsumer(PlatformHttpConsumerAware platformHttpConsumer) {
        this.platformHttpConsumer = platformHttpConsumer;
    }

    public Consumer getConsumer() {
        return this.consumer;
    }

    public void setConsumer(Consumer consumer) {
        this.consumer = consumer;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        String verb;
        RestConsumerContextPathMatcher.ConsumerPath m;
        String path = (String)exchange.getMessage().getHeader("CamelHttpPath", String.class);
        if (path != null && path.startsWith(this.basePath)) {
            path = path.substring(this.basePath.length());
        }
        if ((m = RestConsumerContextPathMatcher.matchBestPath((String)(verb = (String)exchange.getMessage().getHeader("CamelHttpMethod", String.class)), (String)path, this.paths)) instanceof RestOpenApiConsumerPath) {
            RestOpenApiConsumerPath rcp = (RestOpenApiConsumerPath)m;
            Operation o = rcp.getConsumer();
            String consumerPath = rcp.getConsumerPath();
            if (consumerPath.startsWith("/") && path != null && !path.startsWith("/")) {
                consumerPath = consumerPath.substring(1);
            }
            HttpHelper.evalPlaceholders((Map)exchange.getMessage().getHeaders(), (String)path, (String)consumerPath);
            return this.restOpenapiProcessorStrategy.process(this.openAPI, o, verb, path, rcp.getBinding(), exchange, callback);
        }
        if (path != null && path.equals(this.apiContextPath)) {
            return this.restOpenapiProcessorStrategy.processApiSpecification(this.endpoint.getSpecificationUri(), exchange, callback);
        }
        String contextPath = path;
        List<String> allow = METHODS.stream().filter(v -> RestConsumerContextPathMatcher.matchBestPath((String)v, (String)contextPath, this.paths) != null).toList();
        if (allow.isEmpty()) {
            exchange.getMessage().setHeader("CamelHttpResponseCode", (Object)404);
        } else {
            exchange.getMessage().setHeader("CamelHttpResponseCode", (Object)405);
            exchange.getMessage().setHeader("Allow", (Object)String.join((CharSequence)", ", allow));
        }
        exchange.setRouteStop(true);
        callback.done(true);
        return true;
    }

    protected void doInit() throws Exception {
        super.doInit();
        CamelContextAware.trySetCamelContext((Object)this.restOpenapiProcessorStrategy, (CamelContext)this.getCamelContext());
    }

    public void afterPropertiesConfigured(CamelContext camelContext) {
        this.openApiUtils = new OpenApiUtils(camelContext, this.endpoint.getBindingPackageScan(), this.openAPI.getComponents());
        for (Map.Entry entry : this.openAPI.getPaths().entrySet()) {
            String path = (String)entry.getKey();
            for (Map.Entry o : ((PathItem)entry.getValue()).readOperationsMap().entrySet()) {
                String desc;
                String v = ((PathItem.HttpMethod)o.getKey()).name();
                RestBindingConfiguration bc = this.createRestBindingConfiguration((Operation)o.getValue());
                String url = this.basePath + path;
                if (this.platformHttpConsumer != null) {
                    url = this.platformHttpConsumer.getPlatformHttpConsumer().getEndpoint().getServiceUrl() + url;
                }
                if ((desc = ((Operation)o.getValue()).getSummary()) != null && desc.isBlank()) {
                    desc = null;
                }
                String routeId = null;
                Consumer consumer = this.consumer;
                if (consumer instanceof RouteAware) {
                    RouteAware ra = (RouteAware)consumer;
                    routeId = ra.getRoute().getRouteId();
                }
                camelContext.getRestRegistry().addRestService(this.consumer, true, url, path, this.basePath, null, v, bc.getConsumes(), bc.getProduces(), bc.getType(), bc.getOutType(), routeId, desc);
                try {
                    RestBindingAdvice binding = RestBindingAdviceFactory.build((CamelContext)camelContext, (RestBindingConfiguration)bc);
                    ServiceHelper.buildService((Object)binding);
                    this.paths.add(new RestOpenApiConsumerPath(v, path, (Operation)o.getValue(), binding));
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        this.openApiUtils.clear();
        for (RestConsumerContextPathMatcher.ConsumerPath consumerPath : this.paths) {
            if (!(consumerPath instanceof RestOpenApiConsumerPath)) continue;
            RestOpenApiConsumerPath rcp = (RestOpenApiConsumerPath)consumerPath;
            ServiceHelper.startService((Service)rcp.getBinding());
        }
        this.restOpenapiProcessorStrategy.setMissingOperation(this.endpoint.getMissingOperation());
        this.restOpenapiProcessorStrategy.setMockIncludePattern(this.endpoint.getMockIncludePattern());
        ServiceHelper.initService((Object)this.restOpenapiProcessorStrategy);
        try {
            this.restOpenapiProcessorStrategy.validateOpenApi(this.openAPI, this.basePath, this.platformHttpConsumer);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        ServiceHelper.startService((Object)this.restOpenapiProcessorStrategy);
    }

    private RestBindingConfiguration createRestBindingConfiguration(Operation o) {
        RestConfiguration config = this.camelContext.getRestConfiguration();
        RestConfiguration.RestBindingMode mode = config.getBindingMode();
        RestBindingConfiguration bc = new RestBindingConfiguration();
        bc.setBindingMode(mode.name());
        bc.setEnableCORS(config.isEnableCORS());
        bc.setCorsHeaders(config.getCorsHeaders());
        bc.setClientRequestValidation(config.isClientRequestValidation() || this.endpoint.isClientRequestValidation());
        bc.setClientResponseValidation(config.isClientResponseValidation() || this.endpoint.isClientResponseValidation());
        bc.setEnableNoContentResponse(config.isEnableNoContentResponse());
        bc.setSkipBindingOnErrorCode(config.isSkipBindingOnErrorCode());
        String consumes = Optional.ofNullable(this.openApiUtils.getConsumes(o)).orElse(this.endpoint.getConsumes());
        String produces = Optional.ofNullable(this.openApiUtils.getProduces(o)).orElse(this.endpoint.getProduces());
        bc.setConsumes(consumes);
        bc.setProduces(produces);
        bc.setRequiredBody(this.openApiUtils.isRequiredBody(o));
        bc.setRequiredQueryParameters(this.openApiUtils.getRequiredQueryParameters(o));
        bc.setRequiredHeaders(this.openApiUtils.getRequiredHeaders(o));
        bc.setQueryDefaultValues(this.openApiUtils.getQueryParametersDefaultValue(o));
        bc.setType(this.openApiUtils.manageRequestBody(o));
        bc.setOutType(this.openApiUtils.manageResponseBody(o));
        return bc;
    }

    protected void doStop() throws Exception {
        super.doStop();
        ServiceHelper.stopService((Object)this.restOpenapiProcessorStrategy);
        for (RestConsumerContextPathMatcher.ConsumerPath<Operation> p : this.paths) {
            if (!(p instanceof RestOpenApiConsumerPath)) continue;
            RestOpenApiConsumerPath rcp = (RestOpenApiConsumerPath)p;
            ServiceHelper.stopService((Service)rcp.getBinding());
        }
        this.paths.clear();
    }
}

