/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ref;

import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.DelegateEndpoint;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="1.2.0", scheme="ref", title="Ref", syntax="ref:name", label="core,endpoint")
public class RefEndpoint
extends DefaultEndpoint
implements DelegateEndpoint {
    private volatile Endpoint endpoint;
    @UriPath
    @Metadata(required=true)
    private String name;

    public RefEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Producer createProducer() throws Exception {
        return this.endpoint.createProducer();
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return this.endpoint.createConsumer(processor);
    }

    public Endpoint getEndpoint() {
        if (this.endpoint == null) {
            this.endpoint = (Endpoint)CamelContextHelper.mandatoryLookup((CamelContext)this.getCamelContext(), (String)this.name, Endpoint.class);
        }
        return this.endpoint;
    }

    protected void doStart() throws Exception {
        this.getCamelContext().addEndpoint(this.getEndpoint().getEndpointUri(), this.getEndpoint());
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
    }
}

