/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.platform.http;

import org.apache.camel.AfterPropertiesConfigured;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Service;
import org.apache.camel.Suspendable;
import org.apache.camel.SuspendableService;
import org.apache.camel.component.platform.http.PlatformHttpComponent;
import org.apache.camel.component.platform.http.PlatformHttpEndpoint;
import org.apache.camel.component.platform.http.spi.PlatformHttpConsumer;
import org.apache.camel.component.platform.http.spi.PlatformHttpConsumerAware;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.support.service.ServiceHelper;

public class DefaultPlatformHttpConsumer
extends DefaultConsumer
implements PlatformHttpConsumer,
PlatformHttpConsumerAware,
Suspendable,
SuspendableService {
    private PlatformHttpConsumer platformHttpConsumer;
    private boolean register = true;
    private AfterPropertiesConfigured afterConfiguredListener;

    public DefaultPlatformHttpConsumer(Endpoint endpoint, Processor processor) {
        super(endpoint, processor);
    }

    public boolean isHostedService() {
        return true;
    }

    @Override
    public PlatformHttpEndpoint getEndpoint() {
        return (PlatformHttpEndpoint)super.getEndpoint();
    }

    public PlatformHttpComponent getComponent() {
        return this.getEndpoint().getComponent();
    }

    public boolean isRegister() {
        return this.register;
    }

    public void setRegister(boolean register) {
        this.register = register;
    }

    @Override
    public PlatformHttpConsumer getPlatformHttpConsumer() {
        return this.platformHttpConsumer;
    }

    @Override
    public void registerAfterConfigured(AfterPropertiesConfigured listener) {
        this.afterConfiguredListener = listener;
    }

    protected void doInit() throws Exception {
        this.platformHttpConsumer = this.getEndpoint().createPlatformHttpConsumer(this.getProcessor());
        this.configurePlatformHttpConsumer(this.platformHttpConsumer);
        super.doInit();
        ServiceHelper.initService((Object)this.platformHttpConsumer);
        if (this.afterConfiguredListener != null) {
            this.afterConfiguredListener.afterPropertiesConfigured(this.getEndpoint().getCamelContext());
        }
    }

    protected void configurePlatformHttpConsumer(PlatformHttpConsumer platformHttpConsumer) {
    }

    protected void doStart() throws Exception {
        super.doStart();
        ServiceHelper.startService((Service)this.platformHttpConsumer);
        if (this.register) {
            this.getComponent().addHttpEndpoint(this.getEndpoint().getPath(), this.getEndpoint().getHttpMethodRestrict(), this.getEndpoint().getConsumes(), this.getEndpoint().getProduces(), this.platformHttpConsumer);
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.register) {
            this.getComponent().removeHttpEndpoint(this.getEndpoint().getPath());
        }
        ServiceHelper.stopAndShutdownServices((Object[])new Object[]{this.platformHttpConsumer});
    }

    protected void doResume() throws Exception {
        ServiceHelper.resumeService((Object)this.platformHttpConsumer);
        super.doResume();
    }

    protected void doSuspend() throws Exception {
        ServiceHelper.suspendService((Object)this.platformHttpConsumer);
        super.doSuspend();
    }
}

