/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.ClassNames;
import com.squareup.kotlinpoet.CodeBlock;
import com.squareup.kotlinpoet.FileSpec;
import com.squareup.kotlinpoet.FunSpec;
import com.squareup.kotlinpoet.KModifier;
import com.squareup.kotlinpoet.LambdaTypeName;
import com.squareup.kotlinpoet.ParameterSpec;
import com.squareup.kotlinpoet.ParameterizedTypeName;
import com.squareup.kotlinpoet.PropertySpec;
import com.squareup.kotlinpoet.TypeName;
import com.squareup.kotlinpoet.TypeNames;
import com.squareup.kotlinpoet.TypeSpec;
import com.squareup.kotlinpoet.WildcardTypeName;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.camel.maven.packaging.AbstractGeneratorMojo;
import org.apache.camel.tooling.model.BaseModel;
import org.apache.camel.tooling.model.ComponentModel;
import org.apache.camel.tooling.model.DataFormatModel;
import org.apache.camel.tooling.model.JsonMapper;
import org.apache.camel.tooling.model.LanguageModel;
import org.apache.camel.tooling.util.PackageHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.text.CaseUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.build.BuildContext;

@Mojo(name="generate-all-dsl-kotlin", threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.PROCESS_CLASSES)
public class AllDslKotlinMojo
extends AbstractGeneratorMojo {
    @Parameter(defaultValue="${project.build.directory}")
    protected File buildDir;
    @Parameter(defaultValue="${project.basedir}")
    protected File baseDir;
    @Parameter(defaultValue="org.apache.camel.kotlin.components")
    protected String componentsPackageName;
    @Parameter(defaultValue="org.apache.camel.kotlin.dataformats")
    protected String dataFormatsPackageName;
    @Parameter(defaultValue="org.apache.camel.kotlin.languages")
    protected String languagesPackageName;
    @Parameter
    protected File sourcesOutputDir;
    @Parameter
    protected File outputResourcesDir;
    @Parameter(defaultValue="${project.basedir}/../../catalog/camel-catalog/src/generated/resources/org/apache/camel/catalog/components")
    protected File componentsJsonDir;
    @Parameter(defaultValue="${project.basedir}/../../catalog/camel-catalog/src/generated/resources/org/apache/camel/catalog/dataformats")
    protected File dataFormatsJsonDir;
    @Parameter(defaultValue="${project.basedir}/../../catalog/camel-catalog/src/generated/resources/org/apache/camel/catalog/languages")
    protected File languagesJsonDir;
    private transient String licenseHeader;
    private static final Predicate<String> identifierPattern = Pattern.compile("\\w+").asMatchPredicate();
    private static final Pattern genericPattern = Pattern.compile("<([\\w.?\\s]+)>");

    @Override
    public void execute(MavenProject project, MavenProjectHelper projectHelper, BuildContext buildContext) throws MojoFailureException, MojoExecutionException {
        this.buildDir = new File(project.getBuild().getDirectory());
        this.baseDir = project.getBasedir();
        this.componentsPackageName = "org.apache.camel.kotlin.components";
        super.execute(project, projectHelper, buildContext);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        File camelDir = PackageHelper.findCamelDirectory((File)this.baseDir, (String)"dsl/camel-kotlin-api");
        if (camelDir == null) {
            this.getLog().debug((CharSequence)"No dsl/camel-kotlin-api folder found, skipping execution");
            return;
        }
        Path root = camelDir.toPath();
        if (this.sourcesOutputDir == null) {
            this.sourcesOutputDir = root.resolve("src/generated/kotlin").toFile();
        }
        if (this.outputResourcesDir == null) {
            this.outputResourcesDir = root.resolve("src/generated/resources").toFile();
        }
        try (InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("license-header-java.txt");){
            this.licenseHeader = PackageHelper.loadText((InputStream)is);
        }
        catch (Exception e) {
            throw new MojoFailureException("Error loading license-header-java.txt file", (Throwable)e);
        }
        ClassLoader classLoader = this.constructClassLoaderForCamelProjects("core/camel-core-model", "core/camel-api", "core/camel-core-processor");
        this.executeLanguages(classLoader);
        this.executeDataFormats(classLoader);
        this.executeComponents();
    }

    private void executeLanguages(ClassLoader classLoader) throws MojoFailureException {
        ArrayList<LanguageModel> models = new ArrayList<LanguageModel>();
        for (File file : this.languagesJsonDir.listFiles()) {
            try {
                LanguageModel result = JsonMapper.generateLanguageModel((String)Files.readString(file.toPath()));
                models.add(result);
            }
            catch (IOException e) {
                throw new MojoFailureException("Error while reading language from catalog", (Throwable)e);
            }
        }
        for (LanguageModel model : models) {
            this.createLanguageDsl(model, classLoader);
        }
    }

    private void createLanguageDsl(LanguageModel model, ClassLoader classLoader) throws MojoFailureException {
        Class<?> clazz;
        String name = model.getName();
        this.getLog().debug((CharSequence)("Generating Language DSL for " + name));
        String pascalCaseName = StringUtils.capitalize((String)name);
        String dslClassName = pascalCaseName + "LanguageDsl";
        try {
            clazz = classLoader.loadClass(model.getModelJavaType());
        }
        catch (ClassNotFoundException e) {
            throw new MojoFailureException("Error while discovering class", (Throwable)e);
        }
        Object funName = name;
        if (name.contains("-") || name.contains("+")) {
            funName = "`" + name + "`";
        }
        ClassName language = ClassName.bestGuess((String)model.getModelJavaType());
        FunSpec.Builder funBuilder = FunSpec.builder((String)funName);
        funBuilder.addParameter((String)funName, (TypeName)TypeNames.STRING, new KModifier[0]);
        funBuilder.addParameter(ParameterSpec.builder((String)"i", (TypeName)LambdaTypeName.get((TypeName)new ClassName(this.languagesPackageName, new String[]{dslClassName}), new ArrayList(), (TypeName)TypeNames.UNIT), (KModifier[])new KModifier[0]).defaultValue("{}", new Object[0]).build());
        funBuilder.addCode("val def = %s(%s)\n%s(def).apply(i)\nreturn def\n".formatted(language.getSimpleName(), funName, dslClassName), new Object[0]);
        funBuilder.returns((TypeName)language);
        funBuilder.addKdoc(this.sanitizeKDoc(model.getDescription()), new Object[0]);
        TypeSpec.Builder typeBuilder = TypeSpec.classBuilder((String)dslClassName);
        typeBuilder.addAnnotation(new ClassName("org.apache.camel.kotlin", new String[]{"CamelDslMarker"}));
        typeBuilder.primaryConstructor(FunSpec.constructorBuilder().addParameter("def", (TypeName)language, new KModifier[0]).build());
        typeBuilder.addProperty("def", (TypeName)language, new KModifier[0]);
        typeBuilder.addInitializerBlock(CodeBlock.of((String)"this.def = def\n", (Object[])new Object[0]));
        for (LanguageModel.LanguageOptionModel property : model.getOptions()) {
            String propertyName = property.getName();
            if (propertyName.equals("expression")) continue;
            this.createProperty(propertyName, clazz, property.getJavaType(), classLoader, typeBuilder, model.getName(), property.getDescription());
        }
        this.writeSource(FileSpec.builder((String)this.languagesPackageName, (String)model.getName()).addFunction(funBuilder.build()).addType(typeBuilder.build()), dslClassName, this.languagesPackageName, "Language DSL for " + name);
    }

    private void executeDataFormats(ClassLoader classLoader) throws MojoFailureException {
        ArrayList<DataFormatModel> models = new ArrayList<DataFormatModel>();
        for (File file : this.dataFormatsJsonDir.listFiles()) {
            try {
                DataFormatModel result = JsonMapper.generateDataFormatModel((String)Files.readString(file.toPath()));
                models.add(result);
            }
            catch (IOException e) {
                throw new MojoFailureException("Error while reading dataformat from catalog", (Throwable)e);
            }
        }
        for (DataFormatModel model : models) {
            this.createDataFormatDsl(model, classLoader);
        }
    }

    private void createDataFormatDsl(DataFormatModel model, ClassLoader classLoader) throws MojoFailureException {
        Class<?> clazz;
        String name = model.getName();
        this.getLog().debug((CharSequence)("Generating DataFormat DSL for " + name));
        String pascalCaseName = StringUtils.capitalize((String)name);
        String dslClassName = pascalCaseName + "DataFormatDsl";
        try {
            clazz = classLoader.loadClass(model.getModelJavaType());
        }
        catch (ClassNotFoundException e) {
            throw new MojoFailureException("Error while discovering class", (Throwable)e);
        }
        Object funName = name;
        if (name.contains("-") || name.contains("+")) {
            funName = "`" + name + "`";
        }
        ClassName dataFormatDsl = new ClassName("org.apache.camel.kotlin", new String[]{"DataFormatDsl"});
        ClassName dataFormat = ClassName.bestGuess((String)model.getModelJavaType());
        FunSpec.Builder funBuilder = FunSpec.builder((String)funName);
        funBuilder.receiver((TypeName)dataFormatDsl);
        funBuilder.addParameter("i", (TypeName)LambdaTypeName.get((TypeName)new ClassName(this.dataFormatsPackageName, new String[]{dslClassName}), new ArrayList(), (TypeName)TypeNames.UNIT), new KModifier[0]);
        funBuilder.addCode("def = %s().apply(i).def".formatted(dslClassName), new Object[0]);
        funBuilder.addKdoc(this.sanitizeKDoc(model.getDescription()), new Object[0]);
        TypeSpec.Builder typeBuilder = TypeSpec.classBuilder((String)dslClassName);
        typeBuilder.addAnnotation(new ClassName("org.apache.camel.kotlin", new String[]{"CamelDslMarker"}));
        typeBuilder.addProperty("def", (TypeName)dataFormat, new KModifier[0]);
        typeBuilder.addInitializerBlock(CodeBlock.of((String)"def = %s()".formatted(dataFormat.getSimpleName()), (Object[])new Object[0]));
        for (DataFormatModel.DataFormatOptionModel property : model.getOptions()) {
            String propertyName = this.extractPropertyName(model, property);
            this.createProperty(propertyName, clazz, property.getJavaType(), classLoader, typeBuilder, model.getName(), property.getDescription());
        }
        this.writeSource(FileSpec.builder((String)this.dataFormatsPackageName, (String)model.getName()).addFunction(funBuilder.build()).addType(typeBuilder.build()), dslClassName, this.dataFormatsPackageName, "DataFormat DSL for " + name);
    }

    private String extractPropertyName(DataFormatModel model, DataFormatModel.DataFormatOptionModel property) {
        if (model.getModelName().equals("yaml") && property.getName().equals("typeFilter")) {
            return "typeFilters";
        }
        return property.getName();
    }

    private void executeComponents() throws MojoFailureException {
        ArrayList<ComponentModel> models = new ArrayList<ComponentModel>();
        for (File file : this.componentsJsonDir.listFiles()) {
            BaseModel model = JsonMapper.generateModel((Path)file.toPath());
            models.add((ComponentModel)model);
        }
        this.executeComponent(models);
    }

    private void executeComponent(List<ComponentModel> allModels) throws MojoFailureException {
        if (allModels.isEmpty()) {
            return;
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Found " + allModels.size() + " components"));
        }
        Map<String, List<ComponentModel>> grModels = allModels.stream().collect(Collectors.groupingBy(BaseModel::getJavaType));
        for (List<ComponentModel> compModels : grModels.values()) {
            if (compModels.size() > 1) {
                compModels.sort((o1, o2) -> {
                    String s1 = o1.getScheme();
                    String s2 = o2.getScheme();
                    String as = o1.getAlternativeSchemes();
                    int i1 = as.indexOf(s1);
                    int i2 = as.indexOf(s2);
                    return Integer.compare(i1, i2);
                });
            }
            ComponentModel model = compModels.get(0);
            this.createEndpointDsl(model, compModels);
        }
    }

    private void createEndpointDsl(ComponentModel model, List<ComponentModel> aliases) throws MojoFailureException {
        String name = model.getName();
        this.getLog().debug((CharSequence)("Generating Endpoint DSL for " + name));
        String pascalCaseName = this.toPascalCase(name);
        String dslClassName = pascalCaseName + "UriDsl";
        Object funName = name;
        if (name.contains("-") || name.contains("+")) {
            funName = "`" + name + "`";
        }
        ClassName uriDsl = new ClassName("org.apache.camel.kotlin", new String[]{"UriDsl"});
        FunSpec.Builder funBuilder = FunSpec.builder((String)funName);
        funBuilder.receiver((TypeName)uriDsl);
        funBuilder.addParameter("i", (TypeName)LambdaTypeName.get((TypeName)new ClassName(this.componentsPackageName, new String[]{dslClassName}), new ArrayList(), (TypeName)TypeNames.UNIT), new KModifier[0]);
        funBuilder.addCode("%s(this).apply(i)".formatted(dslClassName), new Object[0]);
        funBuilder.addKdoc(this.sanitizeKDoc(model.getDescription()), new Object[0]);
        TypeSpec.Builder typeBuilder = TypeSpec.classBuilder((String)dslClassName);
        typeBuilder.addAnnotation(new ClassName("org.apache.camel.kotlin", new String[]{"CamelDslMarker"}));
        typeBuilder.primaryConstructor(FunSpec.constructorBuilder().addParameter(ParameterSpec.builder((String)"it", (TypeName)uriDsl, (KModifier[])new KModifier[0]).build()).build());
        typeBuilder.addProperty("it", (TypeName)uriDsl, new KModifier[]{KModifier.PRIVATE});
        typeBuilder.addInitializerBlock(CodeBlock.of((String)"this.it = it\nthis.it.component(\"%s\")\n".formatted(name), (Object[])new Object[0]));
        this.processPathOptions(model, typeBuilder);
        this.processParameterOptions(model, typeBuilder);
        this.writeSource(FileSpec.builder((String)this.componentsPackageName, (String)model.getName()).addFunction(funBuilder.build()).addType(typeBuilder.build()), dslClassName, this.componentsPackageName, "Endpoint DSL for " + name);
    }

    private void processPathOptions(ComponentModel model, TypeSpec.Builder typeBuilder) throws MojoFailureException {
        String urlExpression = model.getSyntax();
        urlExpression = urlExpression.replaceFirst(model.getScheme() + ":", "");
        StringBuilder sb = new StringBuilder();
        char[] urlExpressionArray = urlExpression.toCharArray();
        boolean wasIdentifier = false;
        for (int i = 0; i < urlExpressionArray.length; ++i) {
            boolean isIdentifier = identifierPattern.test(String.valueOf(urlExpressionArray[i]));
            if (!wasIdentifier && isIdentifier) {
                boolean parameterExists = false;
                String subUrlExpression = urlExpression.substring(i);
                for (ComponentModel.EndpointOptionModel property : model.getEndpointPathOptions()) {
                    if (!subUrlExpression.startsWith(property.getName())) continue;
                    parameterExists = true;
                    break;
                }
                if (parameterExists) {
                    sb.append('$');
                }
            }
            sb.append(urlExpressionArray[i]);
            wasIdentifier = isIdentifier;
        }
        urlExpression = sb.toString();
        for (ComponentModel.EndpointOptionModel property : model.getEndpointPathOptions()) {
            PropertySpec.Builder pathPropertyBuilder = PropertySpec.builder((String)property.getName(), (TypeName)TypeNames.STRING, (KModifier[])new KModifier[0]);
            pathPropertyBuilder.mutable(true);
            pathPropertyBuilder.initializer("\"\"", new Object[0]);
            pathPropertyBuilder.addModifiers(new KModifier[]{KModifier.PRIVATE});
            typeBuilder.addProperty(pathPropertyBuilder.build());
            FunSpec.Builder propertyBuilder = FunSpec.builder((String)property.getName());
            propertyBuilder.addParameter(property.getName(), (TypeName)TypeNames.STRING, new KModifier[0]);
            propertyBuilder.addCode(CodeBlock.of((String)"this.%s = %s\nit.url(\"%s\")\n".formatted(property.getName(), property.getName(), urlExpression), (Object[])new Object[0]));
            propertyBuilder.addKdoc(this.sanitizeKDoc(property.getDescription()), new Object[0]);
            typeBuilder.addFunction(propertyBuilder.build());
            ClassName className = this.parsePropertyType(property.getType());
            if (className.equals((Object)TypeNames.STRING)) continue;
            FunSpec.Builder stringPropertyBuilder = FunSpec.builder((String)property.getName());
            stringPropertyBuilder.addParameter(property.getName(), (TypeName)className, new KModifier[0]);
            stringPropertyBuilder.addCode(CodeBlock.of((String)"this.%s = %s.toString()\nit.url(\"%s\")\n".formatted(property.getName(), property.getName(), urlExpression), (Object[])new Object[0]));
            stringPropertyBuilder.addKdoc(this.sanitizeKDoc(property.getDescription()), new Object[0]);
            typeBuilder.addFunction(stringPropertyBuilder.build());
        }
    }

    private void processParameterOptions(ComponentModel model, TypeSpec.Builder typeBuilder) throws MojoFailureException {
        for (ComponentModel.EndpointOptionModel property : model.getEndpointParameterOptions()) {
            FunSpec.Builder propertyBuilder = FunSpec.builder((String)property.getName());
            propertyBuilder.addParameter(property.getName(), (TypeName)TypeNames.STRING, new KModifier[0]);
            propertyBuilder.addCode(CodeBlock.of((String)"it.property(\"%s\", %s)\n".formatted(property.getName(), property.getName()), (Object[])new Object[0]));
            propertyBuilder.addKdoc(this.sanitizeKDoc(property.getDescription()), new Object[0]);
            typeBuilder.addFunction(propertyBuilder.build());
            ClassName className = this.parsePropertyType(property.getType());
            if (className.equals((Object)TypeNames.STRING)) continue;
            FunSpec.Builder stringPropertyBuilder = FunSpec.builder((String)property.getName());
            stringPropertyBuilder.addParameter(property.getName(), (TypeName)className, new KModifier[0]);
            stringPropertyBuilder.addCode(CodeBlock.of((String)"it.property(\"%s\", %s.toString())\n".formatted(property.getName(), property.getName()), (Object[])new Object[0]));
            stringPropertyBuilder.addKdoc(this.sanitizeKDoc(property.getDescription()), new Object[0]);
            typeBuilder.addFunction(stringPropertyBuilder.build());
        }
    }

    private ClassName parsePropertyType(String type) throws MojoFailureException {
        return switch (type) {
            case "string", "object", "duration", "array" -> TypeNames.STRING;
            case "integer" -> TypeNames.INT;
            case "number" -> TypeNames.DOUBLE;
            case "boolean" -> TypeNames.BOOLEAN;
            default -> throw new MojoFailureException("Unexpected type of parameter: " + type);
        };
    }

    private void writeSource(FileSpec.Builder fileBuilder, String fileName, String packageName, String what) throws MojoFailureException {
        this.writeSource(fileBuilder, fileName, packageName, what, x -> x);
    }

    private void writeSource(FileSpec.Builder fileBuilder, String fileName, String packageName, String what, Function<String, String> postProcessing) throws MojoFailureException {
        StringBuilder codeBuilder = new StringBuilder();
        codeBuilder.append(this.licenseHeader);
        codeBuilder.append("\n");
        try {
            fileBuilder.build().writeTo((Appendable)codeBuilder);
        }
        catch (IOException e) {
            throw new MojoFailureException("Error while appending kotlin code", (Throwable)e);
        }
        String code = codeBuilder.toString();
        String filePath = packageName.replace('.', '/') + "/" + fileName + ".kt";
        if (this.updateResource(this.sourcesOutputDir.toPath(), filePath, postProcessing.apply(code))) {
            this.getLog().info((CharSequence)("Updated " + what));
        }
    }

    private String toPascalCase(String name) {
        return CaseUtils.toCamelCase((String)name, (boolean)true, (char[])new char[]{'-', '+'});
    }

    private void appendPropertyBuilder(TypeSpec.Builder typeBuilder, String propertyName, TypeName javaType, Boolean toString, String kdoc) {
        FunSpec.Builder propertyBuilder = FunSpec.builder((String)propertyName);
        propertyBuilder.addParameter(propertyName, javaType, new KModifier[0]);
        Object code = "def.%s = %s".formatted(propertyName, propertyName);
        if (toString.booleanValue()) {
            code = (String)code + ".toString()";
        }
        propertyBuilder.addCode(CodeBlock.of((String)code, (Object[])new Object[0]));
        propertyBuilder.addKdoc(this.sanitizeKDoc(kdoc), new Object[0]);
        typeBuilder.addFunction(propertyBuilder.build());
    }

    private TypeName parseJavaType(String javaType) throws MojoFailureException {
        if (javaType.equals("?")) {
            return TypeNames.STAR;
        }
        if (javaType.startsWith("? extends ")) {
            return WildcardTypeName.producerOf((TypeName)this.parseJavaType(javaType.substring("? extends ".length())));
        }
        if (javaType.equals(Object.class.getCanonicalName())) {
            return TypeNames.ANY;
        }
        if (javaType.equals(String.class.getCanonicalName())) {
            return TypeNames.STRING;
        }
        if (javaType.equals(Integer.class.getCanonicalName()) || javaType.equals(Integer.TYPE.getCanonicalName())) {
            return TypeNames.INT;
        }
        if (javaType.equals(Double.class.getCanonicalName()) || javaType.equals(Double.TYPE.getCanonicalName())) {
            return TypeNames.DOUBLE;
        }
        if (javaType.equals(Boolean.class.getCanonicalName()) || javaType.equals(Boolean.TYPE.getCanonicalName())) {
            return TypeNames.BOOLEAN;
        }
        if (javaType.equals(Long.class.getCanonicalName()) || javaType.equals(Long.TYPE.getCanonicalName())) {
            return TypeNames.LONG;
        }
        if (javaType.equals(Character.class.getCanonicalName()) || javaType.equals(Character.TYPE.getCanonicalName())) {
            return TypeNames.CHAR;
        }
        if (javaType.equals("byte[]")) {
            return TypeNames.BYTE_ARRAY;
        }
        if (javaType.equals(Throwable.class.getCanonicalName())) {
            return TypeNames.THROWABLE;
        }
        if (javaType.startsWith(List.class.getCanonicalName())) {
            Matcher matcher = genericPattern.matcher(javaType);
            if (!matcher.find()) {
                try {
                    return ClassName.bestGuess((String)javaType);
                }
                catch (Exception e) {
                    MojoFailureException ex = new MojoFailureException("Unable to resolve java type: " + javaType, (Throwable)e);
                    this.getLog().error((Throwable)ex);
                    throw ex;
                }
            }
            String typeArgument = matcher.group(1);
            return ParameterizedTypeName.get((ClassName)TypeNames.MUTABLE_LIST, (TypeName)this.parseJavaType(typeArgument));
        }
        if (javaType.startsWith(Class.class.getCanonicalName())) {
            Matcher matcher = genericPattern.matcher(javaType);
            if (!matcher.find()) {
                try {
                    return ClassName.bestGuess((String)javaType);
                }
                catch (Exception e) {
                    MojoFailureException ex = new MojoFailureException("Unable to resolve java type: " + javaType, (Throwable)e);
                    this.getLog().error((Throwable)ex);
                    throw ex;
                }
            }
            String typeArgument = matcher.group(1);
            return ParameterizedTypeName.get((ClassName)ClassNames.get(Class.class), (TypeName)this.parseJavaType(typeArgument));
        }
        try {
            return ClassName.bestGuess((String)javaType);
        }
        catch (Exception e) {
            MojoFailureException ex = new MojoFailureException("Unable to resolve java type: " + javaType, (Throwable)e);
            this.getLog().error((Throwable)ex);
            throw ex;
        }
    }

    private ClassLoader constructClassLoaderForCamelProjects(String ... projectPaths) throws MojoFailureException {
        URL[] urls = new URL[projectPaths.length];
        for (int i = 0; i < urls.length; ++i) {
            String projectPath = projectPaths[i];
            File buildDirectory = Path.of(this.baseDir.toPath().toString(), "../../", projectPath, "target/classes").toFile();
            try {
                urls[i] = buildDirectory.toURI().toURL();
                continue;
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Error while resolving build directory of project " + projectPath, e);
            }
        }
        return new URLClassLoader(urls);
    }

    private boolean isPrimitiveTypeName(TypeName type) {
        return type.equals((Object)TypeNames.BOOLEAN) || type.equals((Object)TypeNames.INT) || type.equals((Object)TypeNames.LONG) || type.equals((Object)TypeNames.DOUBLE);
    }

    private void createProperty(String propertyName, Class<?> clazz, String propertyJavaType, ClassLoader classLoader, TypeSpec.Builder typeBuilder, String modelName, String description) throws MojoFailureException {
        Field field = FieldUtils.getField(clazz, (String)propertyName, (boolean)true);
        if (field == null) {
            MojoFailureException ex = new MojoFailureException("Not found field %s for class %s".formatted(propertyName, clazz.getCanonicalName()));
            this.getLog().error((Throwable)ex);
            throw ex;
        }
        TypeName javaType = this.parseJavaType(propertyJavaType);
        if (field.getType().equals(String.class) && !javaType.equals((Object)TypeNames.STRING)) {
            if (this.isPrimitiveTypeName(javaType)) {
                this.appendPropertyBuilder(typeBuilder, propertyName, javaType, true, description);
            } else {
                try {
                    Class<?> propertyClass = classLoader.loadClass(propertyJavaType);
                    if (!propertyClass.isEnum()) {
                        throw new MojoFailureException("Error while generating DataFormat DSL '%s': java type '%s' for field '%s'".formatted(modelName, javaType.toString(), propertyName));
                    }
                    this.appendPropertyBuilder(typeBuilder, propertyName, javaType, true, description);
                }
                catch (ClassNotFoundException propertyClass) {
                    // empty catch block
                }
            }
            this.appendPropertyBuilder(typeBuilder, propertyName, (TypeName)TypeNames.STRING, false, description);
        } else if (field.getType().equals(Class.class)) {
            ParameterizedTypeName clazzTypeName = ParameterizedTypeName.get((ClassName)new ClassName("java.lang", new String[]{"Class"}), (TypeName)TypeNames.STAR);
            this.appendPropertyBuilder(typeBuilder, propertyName, (TypeName)clazzTypeName, false, description);
        } else {
            this.appendPropertyBuilder(typeBuilder, propertyName, javaType, false, description);
        }
    }

    private String sanitizeKDoc(String kdoc) {
        return kdoc.replace("%", "%%");
    }
}

