/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.StringJoiner;
import org.apache.camel.maven.packaging.AbstractGeneratorMojo;
import org.apache.camel.maven.packaging.MojoHelper;
import org.apache.camel.maven.packaging.generics.PackagePluginUtils;
import org.apache.camel.tooling.util.Strings;
import org.apache.camel.util.json.JsonObject;
import org.apache.camel.util.json.Jsoner;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;

@Mojo(name="generate-dev-console", threadSafe=true, defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyCollection=ResolutionScope.COMPILE, requiresDependencyResolution=ResolutionScope.COMPILE)
public class GenerateDevConsoleMojo
extends AbstractGeneratorMojo {
    public static final DotName DEV_CONSOLE_ANNOTATION = DotName.createSimple((String)"org.apache.camel.spi.annotations.DevConsole");
    @Parameter(defaultValue="${project.build.directory}")
    protected File buildDir;
    @Parameter(defaultValue="${project.basedir}/src/generated/resources")
    protected File resourcesOutputDir;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Index index;
        if ("pom".equals(this.project.getPackaging())) {
            return;
        }
        this.buildDir = new File(this.project.getBuild().getDirectory());
        if (this.resourcesOutputDir == null) {
            this.resourcesOutputDir = new File(this.project.getBasedir(), "src/generated/resources");
        }
        if ((index = PackagePluginUtils.readJandexIndexIgnoreMissing(this.project, this.getLog())) == null) {
            return;
        }
        ArrayList<DevConsoleModel> models = new ArrayList<DevConsoleModel>();
        List annotations = index.getAnnotations(DEV_CONSOLE_ANNOTATION);
        annotations.forEach(a -> {
            DevConsoleModel model = new DevConsoleModel();
            String currentClass = a.target().asClass().name().toString();
            boolean deprecated = a.target().asClass().hasAnnotation(Deprecated.class) || this.project.getName().contains("(deprecated)");
            model.setClassName(currentClass);
            model.setDeprecated(deprecated);
            model.setGroup(MojoHelper.annotationValue(a, "group"));
            model.setName(MojoHelper.annotationValue(a, "name"));
            model.setDisplayName(MojoHelper.annotationValue(a, "displayName"));
            model.setDescription(MojoHelper.annotationValue(a, "description"));
            boolean skip = "default-registry".equals(model.getName());
            if (!skip) {
                models.add(model);
            }
        });
        models.sort(Comparator.comparing(DevConsoleModel::getName));
        if (!models.isEmpty()) {
            try {
                StringJoiner ids = new StringJoiner(" ");
                for (DevConsoleModel model : models) {
                    ids.add(model.getName());
                    JsonObject jo = this.asJsonObject(model);
                    String json = jo.toJson();
                    json = Jsoner.prettyPrint((String)json, (int)2);
                    String fn = this.sanitizeFileName(model.getName()) + ".json";
                    boolean updated = this.updateResource(this.resourcesOutputDir.toPath(), "META-INF/org/apache/camel/dev-console/" + fn, json + "\n");
                    if (!updated) continue;
                    this.getLog().info((CharSequence)("Updated dev-console json: " + model.getName()));
                }
                File camelMetaDir = new File(this.resourcesOutputDir, "META-INF/services/org/apache/camel/");
                int count = models.size();
                String properties = GenerateDevConsoleMojo.createProperties(this.project, "dev-consoles", ids.toString());
                this.updateResource(camelMetaDir.toPath(), "dev-consoles.properties", properties);
                this.getLog().info((CharSequence)("Generated dev-consoles.properties containing " + count + " Camel " + (count > 1 ? "consoles: " : "console: ") + String.valueOf(ids)));
            }
            catch (Exception e) {
                throw new MojoExecutionException((Throwable)e);
            }
        }
    }

    private JsonObject asJsonObject(DevConsoleModel model) {
        JsonObject jo = new JsonObject();
        jo.put((Object)"kind", (Object)"console");
        if (model.group != null) {
            jo.put((Object)"group", (Object)model.getGroup());
        } else {
            jo.put((Object)"group", (Object)"camel");
        }
        jo.put((Object)"name", (Object)model.getName());
        if (model.getDisplayName() != null) {
            jo.put((Object)"title", (Object)this.asTitle(model.getDisplayName()));
        } else {
            jo.put((Object)"title", (Object)this.asTitle(model.getName()));
        }
        jo.put((Object)"description", (Object)model.getDescription());
        jo.put((Object)"deprecated", (Object)model.isDeprecated());
        jo.put((Object)"javaType", (Object)model.getClassName());
        jo.put((Object)"groupId", (Object)this.project.getGroupId());
        jo.put((Object)"artifactId", (Object)this.project.getArtifactId());
        jo.put((Object)"version", (Object)this.project.getVersion());
        JsonObject root = new JsonObject();
        root.put((Object)"console", (Object)jo);
        return root;
    }

    private String sanitizeFileName(String fileName) {
        return fileName.replaceAll("[^A-Za-z0-9+-/]", "-");
    }

    private String asTitle(String name) {
        String part = Strings.after((String)(name = Strings.camelDashToTitle((String)name)), (String)":");
        if (part != null) {
            part = Strings.capitalize((String)part);
            name = Strings.before((String)name, (String)":") + " (" + part + ")";
        }
        return name;
    }

    private static class DevConsoleModel {
        private String className;
        private String group;
        private String name;
        private String displayName;
        private String description;
        private boolean deprecated;

        private DevConsoleModel() {
        }

        public String getClassName() {
            return this.className;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public String getGroup() {
            return this.group;
        }

        public void setGroup(String group) {
            this.group = group;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public boolean isDeprecated() {
            return this.deprecated;
        }

        public void setDeprecated(boolean deprecated) {
            this.deprecated = deprecated;
        }
    }
}

