/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging.generics;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexReader;

public final class JandexStore {
    public static final String DEFAULT_NAME = "META-INF/jandex.idx";
    private static final Map<Path, Jandex> JANDEX_CACHE = new ConcurrentHashMap<Path, Jandex>();

    private JandexStore() {
    }

    public static Jandex nonCachedRead(Path path) {
        Jandex jandex;
        block8: {
            InputStream is = Files.newInputStream(path, new OpenOption[0]);
            try {
                IndexReader reader = new IndexReader(is);
                Index index = reader.read();
                jandex = new Jandex(index);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return new Jandex(e);
                }
            }
            is.close();
        }
        return jandex;
    }

    public static Jandex read(Path outputDir, String filename) {
        Path path = outputDir.resolve(filename);
        return JANDEX_CACHE.computeIfAbsent(path, k -> JandexStore.nonCachedRead(path));
    }

    public static Jandex read(Path outputDir) {
        Path path = outputDir.resolve(DEFAULT_NAME);
        return JANDEX_CACHE.computeIfAbsent(path, k -> JandexStore.nonCachedRead(path));
    }

    public static class Jandex {
        private final Index index;
        private final Exception exception;

        public Jandex(Index index) {
            this(index, null);
        }

        public Jandex(Exception exception) {
            this(null, exception);
        }

        private Jandex(Index index, Exception exception) {
            this.index = index;
            this.exception = exception;
        }

        public Index getIndex() {
            return this.index;
        }

        public Exception getException() {
            return this.exception;
        }

        public boolean doesNotExist() {
            return this.exception instanceof NoSuchFileException;
        }
    }
}

