/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.util.Collections;
import java.util.TreeSet;
import javax.inject.Inject;
import org.apache.camel.maven.packaging.AbstractGeneratorMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.build.BuildContext;

@Mojo(name="generate-components-list", threadSafe=true)
public class PackageComponentMojo
extends AbstractGeneratorMojo {
    @Parameter(defaultValue="${project.basedir}/src/generated/resources")
    protected File componentOutDir;
    @Parameter(defaultValue="${project.build.directory}")
    protected File buildDir;

    @Inject
    public PackageComponentMojo(MavenProjectHelper projectHelper, BuildContext buildContext) {
        super(projectHelper, buildContext);
    }

    PackageComponentMojo(Log log, MavenProject project, MavenProjectHelper projectHelper, File buildDir, File componentOutDir, BuildContext buildContext) {
        this(projectHelper, buildContext);
        this.setLog(log);
        this.project = project;
        this.buildDir = buildDir;
        this.componentOutDir = componentOutDir;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.prepareComponent();
    }

    public int prepareComponent() {
        File[] files;
        Log log = this.getLog();
        File camelMetaDir = new File(this.componentOutDir, "META-INF/services/org/apache/camel/");
        if (this.projectHelper != null) {
            this.projectHelper.addResource(this.project, this.componentOutDir.getPath(), Collections.singletonList("**/component.properties"), Collections.emptyList());
        }
        if (!PackageComponentMojo.haveResourcesChanged(log, this.project, this.buildContext, "META-INF/services/org/apache/camel/component")) {
            return 0;
        }
        TreeSet<String> fileNames = new TreeSet<String>();
        int count = 0;
        File f = this.componentOutDir;
        if ((f = new File(f, "META-INF/services/org/apache/camel/component")).exists() && f.isDirectory() && (files = f.listFiles(file -> !file.isDirectory() && !file.isHidden())) != null) {
            for (File file2 : files) {
                ++count;
                fileNames.add(file2.getName());
            }
        }
        if (count > 0) {
            String names = String.join((CharSequence)" ", fileNames);
            String properties = PackageComponentMojo.createProperties(this.project, "components", names);
            this.updateResource(camelMetaDir.toPath(), "component.properties", properties);
            log.info((CharSequence)("Generated components containing " + count + " Camel " + (count > 1 ? "components: " : "component: ") + names));
        } else {
            log.debug((CharSequence)"No META-INF/services/org/apache/camel/component directory found. Are you sure you have created a Camel component?");
        }
        return count;
    }
}

