/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.nio.file.Path;
import javax.inject.Inject;
import org.apache.camel.maven.packaging.ModelWriterGeneratorMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.build.BuildContext;

@Mojo(name="generate-xml-writer", threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.PROCESS_CLASSES)
public class XmlModelWriterGeneratorMojo
extends ModelWriterGeneratorMojo {
    public static final String WRITER_PACKAGE = "org.apache.camel.xml.out";
    @Parameter(defaultValue="${camel-generate-xml-writer}")
    protected boolean generateXmlWriter;

    @Inject
    public XmlModelWriterGeneratorMojo(MavenProjectHelper projectHelper, BuildContext buildContext) {
        super(projectHelper, buildContext);
    }

    @Override
    public void execute(MavenProject project) throws MojoFailureException, MojoExecutionException {
        this.sourcesOutputDir = new File(project.getBasedir(), "src/generated/java");
        this.generateXmlWriter = Boolean.parseBoolean(project.getProperties().getProperty("camel-generate-xml-writer", "false"));
        super.execute(project);
    }

    public void execute() throws MojoExecutionException {
        if (!this.generateXmlWriter) {
            return;
        }
        Path javaDir = this.sourcesOutputDir.toPath();
        String parser = this.generateWriter();
        this.updateResource(javaDir, (this.getWriterPackage() + ".ModelWriter").replace('.', '/') + ".java", parser);
    }

    @Override
    String getWriterPackage() {
        return WRITER_PACKAGE;
    }
}

