/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging.generics;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.camel.maven.packaging.generics.JandexStore;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.jboss.jandex.Index;

public final class PackagePluginUtils {
    private PackagePluginUtils() {
    }

    public static Index readJandexIndex(MavenProject project) throws MojoExecutionException {
        Path output = Paths.get(project.getBuild().getOutputDirectory(), new String[0]);
        JandexStore.Jandex jandex = JandexStore.read(output);
        if (jandex.getException() != null) {
            throw new MojoExecutionException("IOException: " + String.valueOf(jandex.getException()), jandex.getException());
        }
        return jandex.getIndex();
    }

    public static Index readJandexIndexQuietly(MavenProject project) {
        Path output = Paths.get(project.getBuild().getOutputDirectory(), new String[0]);
        JandexStore.Jandex jandex = JandexStore.read(output);
        if (jandex.getException() != null) {
            throw new RuntimeException("IOException: " + String.valueOf(jandex.getException()), jandex.getException());
        }
        return jandex.getIndex();
    }

    public static Index readJandexIndexIgnoreMissing(MavenProject project, Log log) throws MojoExecutionException {
        Path output = Paths.get(project.getBuild().getOutputDirectory(), new String[0]);
        JandexStore.Jandex jandex = JandexStore.read(output);
        if (jandex.getException() != null) {
            if (!jandex.doesNotExist()) {
                throw new MojoExecutionException("IOException: " + jandex.getException().getMessage(), jandex.getException());
            }
            log.warn((CharSequence)("Jandex reading failed: " + jandex.getException().getMessage()));
        }
        return jandex.getIndex();
    }

    public static String joinHeaderAndSource(String licenseHeader, String source) {
        StringBuilder sb = new StringBuilder(licenseHeader.length() + source.length() + 8);
        sb.append(licenseHeader);
        sb.append("\n");
        sb.append(source);
        return sb.toString();
    }
}

