/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.camel.maven.packaging.ErrorDetail;
import org.apache.camel.tooling.util.PackageHelper;
import org.apache.camel.util.json.DeserializationException;
import org.apache.camel.util.json.JsonObject;
import org.apache.camel.util.json.Jsoner;

public final class ValidateHelper {
    private ValidateHelper() {
    }

    public static void validate(File file, ErrorDetail errorDetail) {
        try {
            boolean isLanguage;
            String json = PackageHelper.loadText((File)file);
            JsonObject obj = (JsonObject)Jsoner.deserialize((String)json);
            Map model = obj.getMap("component");
            boolean isComponent = model != null;
            boolean isDataFormat = !isComponent && (model = obj.getMap("dataformat")) != null;
            boolean bl = isLanguage = !isComponent && !isDataFormat && (model = obj.getMap("language")) != null;
            if (!(isComponent || isDataFormat || isLanguage)) {
                return;
            }
            errorDetail.setKind((String)model.get("kind"));
            errorDetail.setMissingDescription(ValidateHelper.isNullOrEmpty(model.get("description")));
            errorDetail.setMissingLabel(ValidateHelper.isNullOrEmpty(model.get("label")));
            if (isComponent) {
                errorDetail.setMissingSyntax(ValidateHelper.isNullOrEmpty(model.get("syntax")));
                Map componentProps = obj.getMap("componentProperties");
                for (Map.Entry entry : componentProps.entrySet()) {
                    if (!ValidateHelper.isNullOrEmpty(((JsonObject)entry.getValue()).get((Object)"description"))) continue;
                    errorDetail.addMissingComponentDoc((String)entry.getKey());
                }
            }
            Map props = obj.getMap("properties");
            boolean path = false;
            for (Map.Entry entry : props.entrySet()) {
                JsonObject value = (JsonObject)entry.getValue();
                if (ValidateHelper.isNullOrEmpty(value.get((Object)"description"))) {
                    errorDetail.addMissingEndpointDoc((String)entry.getKey());
                }
                path |= "path".equals(value.get((Object)"kind"));
            }
            errorDetail.setMissingUriPath(isComponent && !path);
        }
        catch (DeserializationException e) {
            throw new RuntimeException("Cannot parse json", e);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static boolean isNullOrEmpty(Object obj) {
        return obj == null || "".equals(obj);
    }
}

