/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import org.apache.camel.maven.packaging.MvelHelper;
import org.apache.camel.maven.packaging.UpdateReadmeMojo;
import org.apache.camel.tooling.model.ExampleModel;
import org.apache.camel.tooling.util.PackageHelper;
import org.apache.camel.tooling.util.Strings;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.mvel2.templates.TemplateRuntime;

@Mojo(name="prepare-example", threadSafe=true)
public class PrepareExampleMojo
extends AbstractMojo {
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(property="startingFolder", required=true, readonly=true, defaultValue="examples")
    protected String startingFolder = "examples";
    @Parameter(property="filter", required=true, readonly=true, defaultValue="camel-example")
    protected String filter = "camel-example";
    @Parameter(property="filterMiddleFolder", required=false, readonly=true)
    protected String filterMiddleFolder = "aws,azure,google,resume-api,vault";

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.executeExamplesReadme();
    }

    protected void executeExamplesReadme() throws MojoExecutionException, MojoFailureException {
        TreeSet<File> examples = new TreeSet<File>();
        List<String> middleFolders = Arrays.asList(this.filterMiddleFolder.split(","));
        String currentDir = Paths.get(".", new String[0]).normalize().toAbsolutePath().toString();
        if (this.startingFolder != null && !this.startingFolder.isEmpty() && !currentDir.endsWith("examples")) {
            return;
        }
        File dir = new File(".");
        File[] files = dir.listFiles();
        if (files != null) {
            examples.addAll(Arrays.asList(files));
        }
        try {
            ArrayList<ExampleModel> models = new ArrayList<ExampleModel>();
            for (File file : examples) {
                if (!file.isDirectory()) continue;
                if (!middleFolders.contains(file.getName())) {
                    File pom = new File(file, "pom.xml");
                    if (!pom.exists()) continue;
                    this.processExamples(models, file, pom, null);
                    continue;
                }
                File[] subFiles = file.listFiles();
                String middleFolder = file.getName();
                for (File innerFile : subFiles) {
                    File pom;
                    if (!innerFile.isDirectory() || !(pom = new File(innerFile, "pom.xml")).exists()) continue;
                    this.processExamples(models, innerFile, pom, middleFolder);
                }
            }
            models.sort(new ExampleComparator());
            long deprecated = models.stream().filter(m -> "true".equals(m.getDeprecated())).count();
            File file = new File(".", "README.adoc");
            boolean exists = file.exists();
            String changed = this.templateExamples(models, deprecated);
            boolean updated = this.updateExamples(file, changed);
            if (updated) {
                this.getLog().info((CharSequence)("Updated readme.adoc file: " + String.valueOf(file)));
            } else if (exists) {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("No changes to readme.adoc file: " + String.valueOf(file)));
                }
            } else {
                this.getLog().warn((CharSequence)("No readme.adoc file: " + String.valueOf(file)));
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Error due " + e.getMessage(), (Throwable)e);
        }
    }

    private void processExamples(List<ExampleModel> models, File file, File pom, String middleFolder) throws IOException {
        String[] readmes;
        String existing = FileUtils.readFileToString((File)pom, (Charset)Charset.defaultCharset());
        ExampleModel model = new ExampleModel();
        model.setFileName(file.getName());
        String name = Strings.between((String)existing, (String)"<name>", (String)"</name>");
        String title = Strings.between((String)existing, (String)"<title>", (String)"</title>");
        String description = Strings.between((String)existing, (String)"<description>", (String)"</description>");
        String category = Strings.between((String)existing, (String)"<category>", (String)"</category>");
        if (title != null) {
            model.setTitle(title);
        } else {
            model.setTitle(PrepareExampleMojo.asTitle(file.getName()));
        }
        if (description != null) {
            model.setDescription(description);
        }
        if (category != null) {
            model.setCategory(category);
        }
        if (name != null && name.contains("(deprecated)")) {
            model.setDeprecated("true");
        } else {
            model.setDeprecated("false");
        }
        if (middleFolder != null) {
            model.setMiddleFolder(middleFolder);
        }
        if ((readmes = new File(file, ".").list((folder, fileName) -> fileName.regionMatches(true, 0, "readme", 0, "readme".length()))) != null && readmes.length == 1) {
            model.setReadmeFileName(readmes[0]);
            models.add(model);
        }
    }

    private String templateExamples(List<ExampleModel> models, long deprecated) throws MojoExecutionException {
        String string;
        block8: {
            InputStream templateStream = UpdateReadmeMojo.class.getClassLoader().getResourceAsStream("readme-examples.mvel");
            try {
                String template = PackageHelper.loadText((InputStream)templateStream);
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("examples", models);
                map.put("numberOfDeprecated", deprecated);
                string = (String)TemplateRuntime.eval((String)template, map, Collections.singletonMap("util", MvelHelper.INSTANCE));
                if (templateStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (templateStream != null) {
                        try {
                            templateStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new MojoExecutionException("Error processing mvel template. Reason: " + String.valueOf(e), e);
                }
            }
            templateStream.close();
        }
        return string;
    }

    private boolean updateExamples(File file, String changed) throws MojoExecutionException {
        if (!file.exists()) {
            return false;
        }
        try {
            Object text = PackageHelper.loadText((File)file);
            String existing = Strings.between((String)text, (String)"// examples: START", (String)"// examples: END");
            if (existing != null) {
                if ((existing = existing.trim()).equals(changed = changed.trim())) {
                    return false;
                }
                String before = Strings.before((String)text, (String)"// examples: START");
                String after = Strings.after((String)text, (String)"// examples: END");
                text = before + "// examples: START\n" + changed + "\n// examples: END" + after;
                PackageHelper.writeText((File)file, (String)text);
                return true;
            }
            this.getLog().warn((CharSequence)("Cannot find markers in file " + String.valueOf(file)));
            this.getLog().warn((CharSequence)"Add the following markers");
            this.getLog().warn((CharSequence)"\t// examples: START");
            this.getLog().warn((CharSequence)"\t// examples: END");
            return false;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error reading file " + String.valueOf(file) + " Reason: " + String.valueOf(e), e);
        }
    }

    private static String asTitle(String fileName) {
        String answer = fileName.toLowerCase();
        if (answer.startsWith("camel-example-")) {
            answer = answer.substring(14);
        }
        answer = Strings.camelDashToTitle((String)answer);
        return answer;
    }

    private static class ExampleComparator
    implements Comparator<ExampleModel> {
        private ExampleComparator() {
        }

        @Override
        public int compare(ExampleModel o1, ExampleModel o2) {
            int num = o1.getCategory().compareToIgnoreCase(o2.getCategory());
            if (num == 0) {
                return o1.getFileName().compareToIgnoreCase(o2.getFileName());
            }
            return num;
        }
    }
}

