/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.inject.Inject;
import org.apache.camel.maven.packaging.AbstractGeneratorMojo;
import org.apache.camel.maven.packaging.generics.PackagePluginUtils;
import org.apache.camel.spi.annotations.InfraService;
import org.apache.camel.tooling.util.FileUtil;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.build.BuildContext;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;

@Mojo(name="test-infra-generate-metadata", threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE, defaultPhase=LifecyclePhase.PROCESS_CLASSES)
public class CamelTestInfraGenerateMetadataMojo
extends AbstractGeneratorMojo {
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${project.basedir}/src/generated/resources")
    protected File generatedResourcesOutputDir;
    public static final DotName INFRA_SERVICE = DotName.createSimple((String)InfraService.class.getName());

    @Inject
    protected CamelTestInfraGenerateMetadataMojo(MavenProjectHelper projectHelper, BuildContext buildContext) {
        super(projectHelper, buildContext);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        LinkedHashSet<InfrastructureServiceModel> models = new LinkedHashSet<InfrastructureServiceModel>();
        for (AnnotationInstance ai : PackagePluginUtils.readJandexIndexQuietly(this.project).getAnnotations(INFRA_SERVICE)) {
            InfrastructureServiceModel infrastructureServiceModel = new InfrastructureServiceModel();
            String targetClass = ai.target().toString();
            infrastructureServiceModel.setImplementation(targetClass);
            try {
                for (Artifact artifact : this.project.getArtifacts()) {
                    if (!this.classExistsInJarFile(targetClass.substring(targetClass.lastIndexOf(".") + 1), artifact.getFile())) continue;
                    infrastructureServiceModel.setVersion(artifact.getVersion());
                    infrastructureServiceModel.setGroupId(artifact.getGroupId());
                    infrastructureServiceModel.setArtifactId(artifact.getArtifactId());
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Error reading jar file", e);
            }
            for (AnnotationValue av : ai.values()) {
                if (av.name().equals("service")) {
                    infrastructureServiceModel.setService(av.asString());
                    continue;
                }
                if (av.name().equals("serviceAlias")) {
                    infrastructureServiceModel.setAlias(Arrays.asList(av.asStringArray()));
                    continue;
                }
                if (av.name().equals("serviceImplementationAlias")) {
                    infrastructureServiceModel.getAliasImplementation().addAll(Arrays.asList(av.asStringArray()));
                    continue;
                }
                if (!av.name().equals("description")) continue;
                infrastructureServiceModel.setDescription(av.asString());
            }
            models.add(infrastructureServiceModel);
        }
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.enable(SerializationFeature.INDENT_OUTPUT);
            String modelsAsJson = mapper.writeValueAsString(models);
            if (this.generatedResourcesOutputDir == null) {
                this.generatedResourcesOutputDir = new File(this.project.getBasedir(), "src/generated/java");
            }
            FileUtil.updateFile((Path)this.generatedResourcesOutputDir.toPath().resolve("META-INF").resolve("metadata.json"), (String)modelsAsJson);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean classExistsInJarFile(String className, File dependency) throws IOException {
        try (JarFile jarFile = new JarFile(dependency);){
            Enumeration<JarEntry> e = jarFile.entries();
            while (e.hasMoreElements()) {
                JarEntry jarEntry = e.nextElement();
                if (!jarEntry.getName().contains(className)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    private class InfrastructureServiceModel {
        private String service;
        private String description;
        private String implementation;
        private List<String> alias = new ArrayList<String>();
        private List<String> aliasImplementation = new ArrayList<String>();
        private String groupId;
        private String artifactId;
        private String version;

        private InfrastructureServiceModel() {
        }

        public String getService() {
            return this.service;
        }

        public void setService(String service) {
            this.service = service;
        }

        public String getImplementation() {
            return this.implementation;
        }

        public void setImplementation(String implementation) {
            this.implementation = implementation;
        }

        public List<String> getAlias() {
            return this.alias;
        }

        public void setAlias(List<String> alias) {
            this.alias = alias;
        }

        public List<String> getAliasImplementation() {
            return this.aliasImplementation;
        }

        public void setAliasImplementation(List<String> aliasImplementation) {
            this.aliasImplementation = aliasImplementation;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public void setArtifactId(String artifactId) {
            this.artifactId = artifactId;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }
    }
}

