/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeSet;
import org.apache.camel.tooling.model.BaseModel;
import org.apache.camel.tooling.model.ComponentModel;
import org.apache.camel.tooling.model.DataFormatModel;
import org.apache.camel.tooling.model.JsonMapper;
import org.apache.camel.tooling.model.LanguageModel;
import org.apache.camel.tooling.model.OtherModel;
import org.apache.camel.tooling.util.PackageHelper;
import org.apache.camel.tooling.util.Strings;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;

@Mojo(name="prepare-user-guide", threadSafe=true)
public class PrepareUserGuideMojo
extends AbstractMojo {
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${project.build.directory}/classes/org/apache/camel/catalog/components")
    protected File componentsDir;
    @Parameter(defaultValue="${project.build.directory}/classes/org/apache/camel/catalog/dataformats")
    protected File dataFormatsDir;
    @Parameter(defaultValue="${project.build.directory}/classes/org/apache/camel/catalog/languages")
    protected File languagesDir;
    @Parameter(defaultValue="${project.build.directory}/classes/org/apache/camel/catalog/others")
    protected File othersDir;
    @Parameter(defaultValue="${project.directory}/../../../docs/user-manual/en")
    protected File userGuideDir;
    @Component
    private MavenProjectHelper projectHelper;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.executeComponents();
        this.executeOthers();
        this.executeDataFormats();
        this.executeLanguages();
    }

    protected void executeComponents() throws MojoExecutionException, MojoFailureException {
        File[] files;
        TreeSet<File> componentFiles = new TreeSet<File>();
        if (this.componentsDir != null && this.componentsDir.isDirectory() && (files = this.componentsDir.listFiles()) != null) {
            componentFiles.addAll(Arrays.asList(files));
        }
        try {
            ArrayList<ComponentModel> models = new ArrayList<ComponentModel>();
            for (File file : componentFiles) {
                String json = PackageHelper.loadText((File)file);
                ComponentModel model = JsonMapper.generateComponentModel((String)json);
                boolean add = true;
                if (!Strings.isNullOrEmpty((String)model.getAlternativeSchemes())) {
                    String first = model.getAlternativeSchemes().split(",")[0];
                    if (!model.getScheme().equals(first)) {
                        add = false;
                    }
                }
                if (!add) continue;
                models.add(model);
            }
            models.sort(ComponentModel.compareTitle());
            File file = new File(this.userGuideDir, "SUMMARY.md");
            StringBuilder core = new StringBuilder();
            core.append("* Core Components\n");
            for (ComponentModel model : models) {
                if (!model.getLabel().contains("core")) continue;
                String line = "\t* " + PrepareUserGuideMojo.link(model) + "\n";
                core.append(line);
            }
            boolean updated = this.updateCoreComponents(file, core.toString());
            StringBuilder regular = new StringBuilder();
            regular.append("* Components\n");
            for (ComponentModel model : models) {
                if (model.getLabel().contains("core")) continue;
                String line = "\t* " + PrepareUserGuideMojo.link(model) + "\n";
                regular.append(line);
            }
            if (updated |= this.updateComponents(file, regular.toString())) {
                this.getLog().info((CharSequence)("Updated user guide file: " + file));
            } else {
                this.getLog().debug((CharSequence)("No changes to user guide file: " + file));
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Error due " + e.getMessage(), (Throwable)e);
        }
    }

    protected void executeOthers() throws MojoExecutionException, MojoFailureException {
        File[] files;
        TreeSet<File> otherFiles = new TreeSet<File>();
        if (this.othersDir != null && this.othersDir.isDirectory() && (files = this.othersDir.listFiles()) != null) {
            otherFiles.addAll(Arrays.asList(files));
        }
        ArrayList<OtherModel> models = new ArrayList<OtherModel>();
        for (File file : otherFiles) {
            try {
                String json = PackageHelper.loadText((File)file);
                OtherModel model = JsonMapper.generateOtherModel((String)json);
                models.add(model);
            }
            catch (Exception e) {
                throw new MojoFailureException("Error reading file: " + file, (Throwable)e);
            }
        }
        models.sort(BaseModel.compareTitle());
        File file = new File(this.userGuideDir, "SUMMARY.md");
        StringBuilder other = new StringBuilder();
        other.append("* Miscellaneous Components\n");
        for (OtherModel model : models) {
            String line = "\t* " + PrepareUserGuideMojo.link(model) + "\n";
            other.append(line);
        }
        boolean updated = this.updateOthers(file, other.toString());
        if (updated) {
            this.getLog().info((CharSequence)("Updated user guide file: " + file));
        } else {
            this.getLog().debug((CharSequence)("No changes to user guide file: " + file));
        }
    }

    protected void executeDataFormats() throws MojoExecutionException, MojoFailureException {
        File[] files;
        TreeSet<File> dataFormatFiles = new TreeSet<File>();
        if (this.dataFormatsDir != null && this.dataFormatsDir.isDirectory() && (files = this.dataFormatsDir.listFiles()) != null) {
            dataFormatFiles.addAll(Arrays.asList(files));
        }
        try {
            ArrayList<DataFormatModel> models = new ArrayList<DataFormatModel>();
            for (File file : dataFormatFiles) {
                String json = PackageHelper.loadText((File)file);
                DataFormatModel model = JsonMapper.generateDataFormatModel((String)json);
                models.add(model);
            }
            models.sort(BaseModel.compareTitle());
            File file = new File(this.userGuideDir, "SUMMARY.md");
            StringBuilder dataFormats = new StringBuilder();
            dataFormats.append("* Data Formats\n");
            for (DataFormatModel model : models) {
                String line = "\t* " + PrepareUserGuideMojo.link(model) + "\n";
                dataFormats.append(line);
            }
            boolean updated = this.updateDataFormats(file, dataFormats.toString());
            if (updated) {
                this.getLog().info((CharSequence)("Updated user guide file: " + file));
            } else {
                this.getLog().debug((CharSequence)("No changes to user guide file: " + file));
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Error due " + e.getMessage(), (Throwable)e);
        }
    }

    protected void executeLanguages() throws MojoExecutionException, MojoFailureException {
        File[] files;
        TreeSet<File> languageFiles = new TreeSet<File>();
        if (this.languagesDir != null && this.languagesDir.isDirectory() && (files = this.languagesDir.listFiles()) != null) {
            languageFiles.addAll(Arrays.asList(files));
        }
        try {
            ArrayList<LanguageModel> models = new ArrayList<LanguageModel>();
            for (File file : languageFiles) {
                String json = PackageHelper.loadText((File)file);
                LanguageModel model = JsonMapper.generateLanguageModel((String)json);
                models.add(model);
            }
            models.sort(BaseModel.compareTitle());
            File file = new File(this.userGuideDir, "SUMMARY.md");
            StringBuilder languages = new StringBuilder();
            languages.append("* Expression Languages\n");
            for (LanguageModel model : models) {
                String line = "\t* " + PrepareUserGuideMojo.link(model) + "\n";
                languages.append(line);
            }
            boolean updated = this.updateLanguages(file, languages.toString());
            if (updated) {
                this.getLog().info((CharSequence)("Updated user guide file: " + file));
            } else {
                this.getLog().debug((CharSequence)("No changes to user guide file: " + file));
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Error due " + e.getMessage(), (Throwable)e);
        }
    }

    private boolean updateCoreComponents(File file, String changed) throws MojoExecutionException {
        if (!file.exists()) {
            return false;
        }
        try {
            String text = PackageHelper.loadText((File)file);
            String existing = Strings.between((String)text, (String)"<!-- core components: START -->", (String)"<!-- core components: END -->");
            if (existing != null) {
                if ((existing = existing.trim()).equals(changed = changed.trim())) {
                    return false;
                }
                String before = Strings.before((String)text, (String)"<!-- core components: START -->");
                String after = Strings.after((String)text, (String)"<!-- core components: END -->");
                text = before + "<!-- core components: START -->\n" + changed + "\n<!-- core components: END -->" + after;
                PackageHelper.writeText((File)file, (String)text);
                return true;
            }
            this.getLog().warn((CharSequence)("Cannot find markers in file " + file));
            this.getLog().warn((CharSequence)"Add the following markers");
            this.getLog().warn((CharSequence)"\t<!-- core components: START -->");
            this.getLog().warn((CharSequence)"\t<!-- core components: END -->");
            return false;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error reading file " + file + " Reason: " + e, e);
        }
    }

    private boolean updateComponents(File file, String changed) throws MojoExecutionException {
        if (!file.exists()) {
            return false;
        }
        try {
            String text = PackageHelper.loadText((File)file);
            String existing = Strings.between((String)text, (String)"<!-- components: START -->", (String)"<!-- components: END -->");
            if (existing != null) {
                if ((existing = existing.trim()).equals(changed = changed.trim())) {
                    return false;
                }
                String before = Strings.before((String)text, (String)"<!-- components: START -->");
                String after = Strings.after((String)text, (String)"<!-- components: END -->");
                text = before + "<!-- components: START -->\n" + changed + "\n<!-- components: END -->" + after;
                PackageHelper.writeText((File)file, (String)text);
                return true;
            }
            this.getLog().warn((CharSequence)("Cannot find markers in file " + file));
            this.getLog().warn((CharSequence)"Add the following markers");
            this.getLog().warn((CharSequence)"\t<!-- components: START -->");
            this.getLog().warn((CharSequence)"\t<!-- components: END -->");
            return false;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error reading file " + file + " Reason: " + e, e);
        }
    }

    private boolean updateOthers(File file, String changed) throws MojoExecutionException {
        if (!file.exists()) {
            return false;
        }
        try {
            String text = PackageHelper.loadText((File)file);
            String existing = Strings.between((String)text, (String)"<!-- others: START -->", (String)"<!-- others: END -->");
            if (existing != null) {
                if ((existing = existing.trim()).equals(changed = changed.trim())) {
                    return false;
                }
                String before = Strings.before((String)text, (String)"<!-- others: START -->");
                String after = Strings.after((String)text, (String)"<!-- others: END -->");
                text = before + "<!-- others: START -->\n" + changed + "\n<!-- others: END -->" + after;
                PackageHelper.writeText((File)file, (String)text);
                return true;
            }
            this.getLog().warn((CharSequence)("Cannot find markers in file " + file));
            this.getLog().warn((CharSequence)"Add the following markers");
            this.getLog().warn((CharSequence)"\t<!-- others: START -->");
            this.getLog().warn((CharSequence)"\t<!-- others: END -->");
            return false;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error reading file " + file + " Reason: " + e, e);
        }
    }

    private boolean updateDataFormats(File file, String changed) throws MojoExecutionException {
        if (!file.exists()) {
            return false;
        }
        try {
            String text = PackageHelper.loadText((File)file);
            String existing = Strings.between((String)text, (String)"<!-- dataformats: START -->", (String)"<!-- dataformats: END -->");
            if (existing != null) {
                if ((existing = existing.trim()).equals(changed = changed.trim())) {
                    return false;
                }
                String before = Strings.before((String)text, (String)"<!-- dataformats: START -->");
                String after = Strings.after((String)text, (String)"<!-- dataformats: END -->");
                text = before + "<!-- dataformats: START -->\n" + changed + "\n<!-- dataformats: END -->" + after;
                PackageHelper.writeText((File)file, (String)text);
                return true;
            }
            this.getLog().warn((CharSequence)("Cannot find markers in file " + file));
            this.getLog().warn((CharSequence)"Add the following markers");
            this.getLog().warn((CharSequence)"\t<!-- dataformats: START -->");
            this.getLog().warn((CharSequence)"\t<!-- dataformats: END -->");
            return false;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error reading file " + file + " Reason: " + e, e);
        }
    }

    private boolean updateLanguages(File file, String changed) throws MojoExecutionException {
        if (!file.exists()) {
            return false;
        }
        try {
            String text = PackageHelper.loadText((File)file);
            String existing = Strings.between((String)text, (String)"<!-- languages: START -->", (String)"<!-- languages: END -->");
            if (existing != null) {
                if ((existing = existing.trim()).equals(changed = changed.trim())) {
                    return false;
                }
                String before = Strings.before((String)text, (String)"<!-- languages: START -->");
                String after = Strings.after((String)text, (String)"<!-- languages: END -->");
                text = before + "<!-- languages: START -->\n" + changed + "\n<!-- languages: END -->" + after;
                PackageHelper.writeText((File)file, (String)text);
                return true;
            }
            this.getLog().warn((CharSequence)("Cannot find markers in file " + file));
            this.getLog().warn((CharSequence)"Add the following markers");
            this.getLog().warn((CharSequence)"\t<!-- languages: START -->");
            this.getLog().warn((CharSequence)"\t<!-- languages: END -->");
            return false;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error reading file " + file + " Reason: " + e, e);
        }
    }

    private static String link(ComponentModel model) {
        return "[" + model.getTitle() + "](" + model.getScheme() + "-component.adoc)";
    }

    private static String link(OtherModel model) {
        return "[" + model.getTitle() + "](" + model.getName() + ".adoc)";
    }

    private static String link(DataFormatModel model) {
        String name = PrepareUserGuideMojo.asDataFormatName(model.getName());
        return "[" + model.getTitle() + "](" + name + "-dataformat.adoc)";
    }

    private static String link(LanguageModel model) {
        return "[" + model.getTitle() + "](" + model.getName() + "-language.adoc)";
    }

    private static String asDataFormatName(String name) {
        if (name.startsWith("bindy")) {
            return "bindy";
        }
        return name;
    }
}

