/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.util.Collections;
import org.apache.camel.maven.packaging.AbstractGeneratorMojo;
import org.apache.camel.tooling.model.JsonMapper;
import org.apache.camel.tooling.model.OtherModel;
import org.apache.camel.tooling.util.Strings;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="generate-others-list", threadSafe=true)
public class PackageOtherMojo
extends AbstractGeneratorMojo {
    @Parameter(defaultValue="${project.basedir}/src/generated/resources")
    protected File otherOutDir;
    @Parameter(defaultValue="${project.basedir}/src/generated/resources")
    protected File schemaOutDir;

    public PackageOtherMojo() {
    }

    public PackageOtherMojo(Log log, MavenProject project, MavenProjectHelper projectHelper, File otherOutDir, File schemaOutDir, BuildContext buildContext) {
        this.setLog(log);
        this.project = project;
        this.projectHelper = projectHelper;
        this.otherOutDir = otherOutDir;
        this.schemaOutDir = schemaOutDir;
        this.buildContext = buildContext;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        File f = new File(this.project.getBasedir(), "target/classes");
        File comp = new File(f, "META-INF/services/org/apache/camel/component");
        if (comp.exists() && comp.isDirectory()) {
            return;
        }
        File df = new File(f, "META-INF/services/org/apache/camel/dataformat");
        if (df.exists() && df.isDirectory()) {
            return;
        }
        File lan = new File(f, "META-INF/services/org/apache/camel/language");
        if (lan.exists() && lan.isDirectory()) {
            return;
        }
        this.prepareOthers();
    }

    public void prepareOthers() throws MojoExecutionException {
        String name;
        Log log = this.getLog();
        if (this.projectHelper != null) {
            this.projectHelper.addResource(this.project, this.otherOutDir.getPath(), Collections.singletonList("**/other.properties"), Collections.emptyList());
        }
        if ((name = this.project.getArtifactId()).startsWith("camel-")) {
            name = name.substring(6);
        }
        try {
            OtherModel otherModel = new OtherModel();
            otherModel.setName(name);
            otherModel.setGroupId(this.project.getGroupId());
            otherModel.setArtifactId(this.project.getArtifactId());
            otherModel.setVersion(this.project.getVersion());
            otherModel.setDescription(this.project.getDescription());
            otherModel.setDeprecated(this.project.getName() != null && this.project.getName().contains("(deprecated)"));
            otherModel.setFirstVersion(this.project.getProperties().getProperty("firstVersion"));
            otherModel.setLabel(this.project.getProperties().getProperty("label"));
            String title = this.project.getProperties().getProperty("title");
            if (title == null) {
                title = Strings.camelDashToTitle((String)name);
            }
            otherModel.setTitle(title);
            if (log.isDebugEnabled()) {
                log.debug((CharSequence)("Model: " + otherModel));
            }
            String schema = JsonMapper.createJsonSchema((OtherModel)otherModel);
            String fileName = name + ".json";
            this.updateResource(this.schemaOutDir.toPath(), fileName, schema);
            if (log.isDebugEnabled()) {
                log.debug((CharSequence)("Generated " + fileName + " containing JSon schema for " + name + " other"));
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error loading other model. Reason: " + e, e);
        }
        File camelMetaDir = new File(this.otherOutDir, "META-INF/services/org/apache/camel/");
        String properties = PackageOtherMojo.createProperties(this.project, "name", name);
        this.updateResource(camelMetaDir.toPath(), "other.properties", properties);
        log.info((CharSequence)("Generated other.properties containing 1 Camel other: " + name));
    }
}

