/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.core.models.Node;
import io.apicurio.datamodels.core.models.common.Contact;
import io.apicurio.datamodels.core.models.common.Info;
import io.apicurio.datamodels.core.models.common.License;
import io.apicurio.datamodels.core.models.common.Server;
import io.apicurio.datamodels.core.models.common.ServerVariable;
import io.apicurio.datamodels.openapi.models.OasDocument;
import io.apicurio.datamodels.openapi.v2.models.Oas20Document;
import io.apicurio.datamodels.openapi.v2.models.Oas20Info;
import io.apicurio.datamodels.openapi.v3.models.Oas30Document;
import io.apicurio.datamodels.openapi.v3.models.Oas30Info;
import io.apicurio.datamodels.openapi.v3.models.Oas30Server;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.openapi.BeanConfig;
import org.apache.camel.openapi.DefaultRestDefinitionsResolver;
import org.apache.camel.openapi.OpenApiHelper;
import org.apache.camel.openapi.RestApiResponseAdapter;
import org.apache.camel.openapi.RestDefinitionsResolver;
import org.apache.camel.openapi.RestOpenApiReader;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.support.ResolverHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestOpenApiSupport {
    static final String HEADER_X_FORWARDED_PREFIX = "X-Forwarded-Prefix";
    static final String HEADER_X_FORWARDED_HOST = "X-Forwarded-Host";
    static final String HEADER_X_FORWARDED_PROTO = "X-Forwarded-Proto";
    static final String HEADER_HOST = "Host";
    private static final Logger LOG = LoggerFactory.getLogger(RestOpenApiSupport.class);
    private final RestOpenApiReader reader = new RestOpenApiReader();
    private final RestDefinitionsResolver localRestDefinitionResolver = new DefaultRestDefinitionsResolver();
    private volatile RestDefinitionsResolver jmxRestDefinitionResolver;
    private boolean cors;

    private static void setupCorsHeaders(RestApiResponseAdapter response, Map<String, String> corsHeaders) {
        String maxAge;
        String allowHeaders;
        String allowMethods;
        String allowOrigin;
        String string = allowOrigin = corsHeaders != null ? corsHeaders.get("Access-Control-Allow-Origin") : null;
        if (allowOrigin == null) {
            allowOrigin = "*";
        }
        String string2 = allowMethods = corsHeaders != null ? corsHeaders.get("Access-Control-Allow-Methods") : null;
        if (allowMethods == null) {
            allowMethods = "GET, HEAD, POST, PUT, DELETE, TRACE, OPTIONS, CONNECT, PATCH";
        }
        String string3 = allowHeaders = corsHeaders != null ? corsHeaders.get("Access-Control-Allow-Headers") : null;
        if (allowHeaders == null) {
            allowHeaders = "Origin, Accept, X-Requested-With, Content-Type, Access-Control-Request-Method, Access-Control-Request-Headers";
        }
        String string4 = maxAge = corsHeaders != null ? corsHeaders.get("Access-Control-Max-Age") : null;
        if (maxAge == null) {
            maxAge = "3600";
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Using CORS headers[");
            LOG.trace("  Access-Control-Allow-Origin={}", (Object)allowOrigin);
            LOG.trace("  Access-Control-Allow-Methods={}", (Object)allowMethods);
            LOG.trace("  Access-Control-Allow-Headers={}", (Object)allowHeaders);
            LOG.trace("  Access-Control-Max-Age={}", (Object)maxAge);
            LOG.trace("]");
        }
        response.setHeader("Access-Control-Allow-Origin", allowOrigin);
        response.setHeader("Access-Control-Allow-Methods", allowMethods);
        response.setHeader("Access-Control-Allow-Headers", allowHeaders);
        response.setHeader("Access-Control-Max-Age", maxAge);
    }

    static void setupXForwardedHeaders(OasDocument openApi, Map<String, Object> headers) {
        String basePath = RestOpenApiSupport.getBasePathFromOasDocument(openApi);
        if (openApi instanceof Oas20Document) {
            String proto;
            String forwardedHost;
            String forwardedPrefix;
            String host = (String)headers.get(HEADER_HOST);
            if (ObjectHelper.isNotEmpty((Object)host)) {
                ((Oas20Document)openApi).host = host;
            }
            if (ObjectHelper.isNotEmpty((Object)(forwardedPrefix = (String)headers.get(HEADER_X_FORWARDED_PREFIX)))) {
                ((Oas20Document)openApi).basePath = URISupport.joinPaths((String[])new String[]{forwardedPrefix, basePath});
            }
            if (ObjectHelper.isNotEmpty((Object)(forwardedHost = (String)headers.get(HEADER_X_FORWARDED_HOST)))) {
                ((Oas20Document)openApi).host = forwardedHost;
            }
            if (ObjectHelper.isNotEmpty((Object)(proto = (String)headers.get(HEADER_X_FORWARDED_PROTO)))) {
                String[] schemes;
                for (String scheme : schemes = proto.split(",")) {
                    String trimmedScheme = scheme.trim();
                    if (!ObjectHelper.isNotEmpty((Object)trimmedScheme)) continue;
                    if (((Oas20Document)openApi).schemes == null) {
                        ((Oas20Document)openApi).schemes = new ArrayList();
                    }
                    ((Oas20Document)openApi).schemes.add(trimmedScheme.toLowerCase());
                }
            }
        } else if (openApi instanceof Oas30Document) {
            String forwardedHost;
            String host = (String)headers.get(HEADER_HOST);
            String forwardedPrefix = (String)headers.get(HEADER_X_FORWARDED_PREFIX);
            if (ObjectHelper.isNotEmpty((Object)forwardedPrefix)) {
                basePath = URISupport.joinPaths((String[])new String[]{forwardedPrefix, basePath});
            }
            if (ObjectHelper.isNotEmpty((Object)(forwardedHost = (String)headers.get(HEADER_X_FORWARDED_HOST)))) {
                host = forwardedHost;
            }
            String proto = (String)headers.get(HEADER_X_FORWARDED_PROTO);
            if (((Oas30Document)openApi).getServers() != null) {
                ((Oas30Document)openApi).getServers().clear();
            }
            if (ObjectHelper.isNotEmpty((Object)proto)) {
                String[] schemes;
                for (String schema : schemes = proto.split(",")) {
                    String trimmedScheme = schema.trim();
                    String serverUrl = String.format("%s://%s%s", trimmedScheme.toLowerCase(), host, basePath);
                    ((Oas30Document)openApi).addServer(serverUrl, null);
                }
            } else {
                ((Oas30Document)openApi).addServer(basePath, null);
            }
        }
    }

    public static String getHostFromOasDocument(OasDocument openapi) {
        String host = null;
        if (openapi instanceof Oas20Document) {
            host = ((Oas20Document)openapi).host;
        } else if (openapi instanceof Oas30Document && ((Oas30Document)openapi).getServers() != null && ((Oas30Document)openapi).getServers().get(0) != null) {
            try {
                URL serverUrl = new URL(RestOpenApiSupport.parseVariables(((Server)((Oas30Document)openapi).getServers().get((int)0)).url, (Oas30Server)((Oas30Document)openapi).getServers().get(0)));
                host = serverUrl.getHost();
            }
            catch (MalformedURLException e) {
                LOG.info("error when parsing OpenApi 3.0 doc server url", (Throwable)e);
            }
        }
        return host;
    }

    public static String getBasePathFromOasDocument(OasDocument openapi) {
        String basePath = null;
        if (openapi instanceof Oas20Document) {
            basePath = ((Oas20Document)openapi).basePath;
        } else if (openapi instanceof Oas30Document && ((Oas30Document)openapi).getServers() != null && ((Oas30Document)openapi).getServers().get(0) != null) {
            try {
                URL serverUrl;
                Oas30Server server = (Oas30Server)((Oas30Document)openapi).getServers().get(0);
                if (server.variables != null && server.variables.get("basePath") != null) {
                    basePath = ((ServerVariable)server.variables.get((Object)"basePath")).default_;
                }
                if (basePath == null && "/".equals(basePath = (serverUrl = new URL(RestOpenApiSupport.parseVariables(((Server)((Oas30Document)openapi).getServers().get((int)0)).url, (Oas30Server)((Oas30Document)openapi).getServers().get(0)))).getPath().replaceAll("//", "/"))) {
                    basePath = "";
                }
            }
            catch (MalformedURLException e) {
                basePath = ((Server)((Oas30Document)openapi).getServers().get((int)0)).url;
            }
        }
        return basePath;
    }

    public static String parseVariables(String url, Oas30Server server) {
        Pattern p = Pattern.compile("\\{(.*?)}");
        Matcher m = p.matcher(url);
        while (m.find()) {
            String var = m.group(1);
            if (server == null || server.variables == null || server.variables.get(var) == null) continue;
            String varValue = ((ServerVariable)server.variables.get((Object)var)).default_;
            url = url.replace("{" + var + "}", varValue);
        }
        return url;
    }

    public void initOpenApi(BeanConfig openApiConfig, Map<String, Object> config) {
        String s = (String)config.get("openapi.version");
        if (s != null) {
            openApiConfig.setVersion(s);
        }
        if ((s = (String)config.get("base.path")) != null) {
            openApiConfig.setBasePath(s);
        }
        if ((s = (String)config.get("host")) != null) {
            openApiConfig.setHost(s);
        }
        if ((s = (String)config.get("cors")) != null) {
            this.cors = "true".equalsIgnoreCase(s);
        }
        if ((s = (String)config.get("schemes")) == null) {
            s = (String)config.get("schemas");
        }
        if (s != null) {
            String[] schemes = s.split(",");
            openApiConfig.setSchemes(schemes);
        } else {
            openApiConfig.setSchemes(new String[]{"http"});
        }
        String version = (String)config.get("api.version");
        String title = (String)config.get("api.title");
        String description = (String)config.get("api.description");
        String termsOfService = (String)config.get("api.termsOfService");
        String licenseName = (String)config.get("api.license.name");
        String licenseUrl = (String)config.get("api.license.url");
        String contactName = (String)config.get("api.contact.name");
        String contactUrl = (String)config.get("api.contact.url");
        String contactEmail = (String)config.get("api.contact.email");
        if (!openApiConfig.isOpenApi3()) {
            this.setInfoOas20(openApiConfig, version, title, description, termsOfService, licenseName, licenseUrl, contactName, contactUrl, contactEmail);
        } else {
            this.setInfoOas30(openApiConfig, version, title, description, termsOfService, licenseName, licenseUrl, contactName, contactUrl, contactEmail);
        }
    }

    private void setInfoOas30(BeanConfig openApiConfig, String version, String title, String description, String termsOfService, String licenseName, String licenseUrl, String contactName, String contactUrl, String contactEmail) {
        Oas30Info info = new Oas30Info();
        info.version = version;
        info.title = title;
        info.description = description;
        info.termsOfService = termsOfService;
        if (licenseName != null || licenseUrl != null) {
            License license = info.createLicense();
            license.name = licenseName;
            license.url = licenseUrl;
            info.license = license;
        }
        if (contactName != null || contactUrl != null || contactEmail != null) {
            Contact contact = info.createContact();
            contact.name = contactName;
            contact.url = contactUrl;
            contact.email = contactEmail;
            info.contact = contact;
        }
        openApiConfig.setInfo((Info)info);
    }

    private void setInfoOas20(BeanConfig openApiConfig, String version, String title, String description, String termsOfService, String licenseName, String licenseUrl, String contactName, String contactUrl, String contactEmail) {
        Oas20Info info = new Oas20Info();
        info.version = version;
        info.title = title;
        info.description = description;
        info.termsOfService = termsOfService;
        if (licenseName != null || licenseUrl != null) {
            License license = info.createLicense();
            license.name = licenseName;
            license.url = licenseUrl;
            info.license = license;
        }
        if (contactName != null || contactUrl != null || contactEmail != null) {
            Contact contact = info.createContact();
            contact.name = contactName;
            contact.url = contactUrl;
            contact.email = contactEmail;
            info.contact = contact;
        }
        openApiConfig.setInfo((Info)info);
    }

    public List<RestDefinition> getRestDefinitions(CamelContext camelContext) throws Exception {
        return this.localRestDefinitionResolver.getRestDefinitions(camelContext, null);
    }

    public List<RestDefinition> getRestDefinitions(CamelContext camelContext, String camelId) throws Exception {
        if (this.jmxRestDefinitionResolver == null) {
            this.jmxRestDefinitionResolver = this.createJmxRestDefinitionsResolver(camelContext);
        }
        return this.jmxRestDefinitionResolver.getRestDefinitions(camelContext, camelId);
    }

    protected RestDefinitionsResolver createJmxRestDefinitionsResolver(CamelContext camelContext) {
        return (RestDefinitionsResolver)ResolverHelper.resolveService((CamelContext)camelContext, (FactoryFinder)((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getBootstrapFactoryFinder(), (String)"jmx-rest-definition-resolver", RestDefinitionsResolver.class).orElseThrow(() -> new IllegalArgumentException("Cannot find camel-openapi-java on classpath."));
    }

    public void renderResourceListing(CamelContext camelContext, RestApiResponseAdapter response, BeanConfig openApiConfig, boolean json, boolean yaml, Map<String, Object> headers, ClassResolver classResolver, RestConfiguration configuration) throws Exception {
        List<RestDefinition> rests;
        LOG.trace("renderResourceListing");
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        if (this.cors) {
            RestOpenApiSupport.setupCorsHeaders(response, configuration.getCorsHeaders());
        }
        if ((rests = this.getRestDefinitions(camelContext)) != null) {
            Map apiProperties;
            Map map = apiProperties = configuration.getApiProperties() != null ? configuration.getApiProperties() : new HashMap();
            if (json) {
                response.setHeader("Content-Type", apiProperties.getOrDefault("api.specification.contentType.json", "application/json"));
                OasDocument openApi = this.reader.read(camelContext, rests, openApiConfig, camelContext.getName(), classResolver);
                if (configuration.isUseXForwardHeaders()) {
                    RestOpenApiSupport.setupXForwardedHeaders(openApi, headers);
                }
                if (!configuration.isApiVendorExtension()) {
                    OpenApiHelper.clearVendorExtensions(openApi);
                }
                Object dump = Library.writeNode((Node)openApi);
                byte[] bytes = mapper.writeValueAsBytes(dump);
                int len = bytes.length;
                response.setHeader("Content-Length", "" + len);
                response.writeBytes(bytes);
            } else {
                response.setHeader("Content-Type", apiProperties.getOrDefault("api.specification.contentType.yaml", "text/yaml"));
                OasDocument openApi = this.reader.read(camelContext, rests, openApiConfig, camelContext.getName(), classResolver);
                if (configuration.isUseXForwardHeaders()) {
                    RestOpenApiSupport.setupXForwardedHeaders(openApi, headers);
                }
                if (!configuration.isApiVendorExtension()) {
                    OpenApiHelper.clearVendorExtensions(openApi);
                }
                Object dump = Library.writeNode((Node)openApi);
                byte[] jsonData = mapper.writeValueAsBytes(dump);
                JsonNode node = mapper.readTree(jsonData);
                byte[] bytes = new YAMLMapper().writeValueAsString((Object)node).getBytes();
                int len = bytes.length;
                response.setHeader("Content-Length", "" + len);
                response.writeBytes(bytes);
            }
        } else {
            response.noContent();
        }
    }
}

