/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.oauth.vertx;

import com.nimbusds.jose.jwk.JWKSet;
import io.vertx.core.Vertx;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.oauth2.OAuth2Auth;
import io.vertx.ext.auth.oauth2.OAuth2AuthorizationURL;
import io.vertx.ext.auth.oauth2.OAuth2FlowType;
import io.vertx.ext.auth.oauth2.OAuth2Options;
import io.vertx.ext.auth.oauth2.Oauth2Credentials;
import io.vertx.ext.auth.oauth2.providers.OpenIDConnectAuth;
import java.net.URI;
import java.net.URL;
import org.apache.camel.CamelContext;
import org.apache.camel.oauth.AuthCodeCredentials;
import org.apache.camel.oauth.ClientCredentials;
import org.apache.camel.oauth.Credentials;
import org.apache.camel.oauth.OAuth;
import org.apache.camel.oauth.OAuthCodeFlowParams;
import org.apache.camel.oauth.OAuthConfig;
import org.apache.camel.oauth.OAuthException;
import org.apache.camel.oauth.OAuthLogoutParams;
import org.apache.camel.oauth.OAuthProperties;
import org.apache.camel.oauth.TokenCredentials;
import org.apache.camel.oauth.UserCredentials;
import org.apache.camel.oauth.UserProfile;
import org.apache.camel.oauth.vertx.VertxUserProfile;

public class VertxOAuth
extends OAuth {
    private final Vertx vertx;
    private OAuth2Auth oauth2;

    public VertxOAuth(Vertx vertx) {
        this.vertx = vertx;
    }

    @Override
    public void discoverOAuthConfig(CamelContext ctx) throws OAuthException {
        if (this.config == null) {
            String baseUri = OAuthProperties.getRequiredProperty(ctx, "camel.oauth.base-uri");
            String clientId = OAuthProperties.getRequiredProperty(ctx, "camel.oauth.client-id");
            String clientSecret = OAuthProperties.getRequiredProperty(ctx, "camel.oauth.client-secret");
            OAuthConfig config = new OAuthConfig().setBaseUrl(baseUri).setClientId(clientId).setClientSecret(clientSecret);
            OAuth2Options opts = new OAuth2Options().setSite(baseUri).setClientId(config.getClientId()).setClientSecret(config.getClientSecret());
            String wellKnownUri = baseUri + "/.well-known/openid-configuration";
            try {
                this.oauth2 = (OAuth2Auth)OpenIDConnectAuth.discover((Vertx)this.vertx, (OAuth2Options)opts).toCompletionStage().toCompletableFuture().get();
                config.setAuthorizationPath(opts.getAuthorizationPath()).setTokenPath(opts.getTokenPath()).setRevocationPath(opts.getRevocationPath()).setLogoutPath(opts.getLogoutPath()).setUserInfoPath(opts.getUserInfoPath()).setIntrospectionPath(opts.getIntrospectionPath()).setJwksPath(opts.getJwkPath());
                String jwksPath = config.getJwksPath();
                if (!jwksPath.isBlank()) {
                    config.setJWKSet(JWKSet.load((URL)URI.create(jwksPath).toURL()));
                }
            }
            catch (Exception ex) {
                throw new OAuthException("Cannot discover OAuth config from: " + wellKnownUri, ex);
            }
            this.config = config;
        }
    }

    @Override
    public String buildCodeFlowAuthRequestUrl(OAuthCodeFlowParams params) {
        if (params.getScopes() == null) {
            params.setScope("openid");
        }
        return this.oauth2.authorizeURL(new OAuth2AuthorizationURL().setRedirectUri(params.getRedirectUri()).setScopes(params.getScopes()));
    }

    @Override
    public UserProfile authenticate(Credentials creds) throws OAuthException {
        io.vertx.ext.auth.authentication.TokenCredentials vtxCreds;
        if (creds instanceof UserCredentials) {
            UserProfile userProfile = ((UserCredentials)creds).getUserProfile();
            this.log.info("Authenticate userProfile: {}", (Object)userProfile.subject());
            String scope = (String)userProfile.principal().get("scope");
            vtxCreds = new io.vertx.ext.auth.authentication.TokenCredentials().setToken(userProfile.accessToken().orElseThrow()).addScope(scope);
        } else if (creds instanceof AuthCodeCredentials) {
            AuthCodeCredentials params = (AuthCodeCredentials)creds;
            vtxCreds = new Oauth2Credentials().setFlow(OAuth2FlowType.AUTH_CODE).setRedirectUri(params.getRedirectUri()).setCode(params.getCode());
        } else if (creds instanceof TokenCredentials) {
            TokenCredentials params = (TokenCredentials)creds;
            vtxCreds = new io.vertx.ext.auth.authentication.TokenCredentials().setToken(params.getToken());
        } else if (creds instanceof ClientCredentials) {
            ClientCredentials params = (ClientCredentials)creds;
            vtxCreds = new Oauth2Credentials().setFlow(OAuth2FlowType.CLIENT).setUsername(params.getClientId()).setPassword(params.getClientSecret());
        } else {
            throw new OAuthException("Unsupported creds: " + creds.getClass().getName());
        }
        try {
            User vtxUser = (User)this.oauth2.authenticate((io.vertx.ext.auth.authentication.Credentials)vtxCreds).toCompletionStage().toCompletableFuture().get();
            return new VertxUserProfile(vtxUser);
        }
        catch (Exception ex) {
            throw new OAuthException("Cannot authenticate user", ex);
        }
    }

    @Override
    public String buildLogoutRequestUrl(OAuthLogoutParams params) {
        User user = ((VertxUserProfile)params.getUserProfile()).getVertxUser();
        Object endSessionURL = this.oauth2.endSessionURL(user);
        String postLogoutUrl = params.getRedirectUri();
        if (postLogoutUrl != null) {
            endSessionURL = (String)endSessionURL + "&post_logout_redirect_uri=" + postLogoutUrl;
        }
        return endSessionURL;
    }
}

