/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.oauth;

import java.util.List;

public class OAuthCodeFlowParams {
    private String clientId;
    private String redirectUri;
    private AuthRequestResponseType responseType;
    private List<String> scopes;
    private String state;
    private AuthRequestDisplayOpts display;
    private List<AuthRequestPromptOpts> prompt;
    private Integer maxAge;
    private String uiLocales;
    private String idTokenHint;
    private String loginHint;
    private String acrValues;

    public String getClientId() {
        return this.clientId;
    }

    public OAuthCodeFlowParams setClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public OAuthCodeFlowParams setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
        return this;
    }

    public AuthRequestResponseType getResponseType() {
        return this.responseType;
    }

    public OAuthCodeFlowParams setResponseType(AuthRequestResponseType responseType) {
        this.responseType = responseType;
        return this;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public OAuthCodeFlowParams setScope(String scope) {
        this.scopes = List.of(scope);
        return this;
    }

    public OAuthCodeFlowParams setScopes(List<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    public String getState() {
        return this.state;
    }

    public OAuthCodeFlowParams setState(String state) {
        this.state = state;
        return this;
    }

    public AuthRequestDisplayOpts getDisplay() {
        return this.display;
    }

    public OAuthCodeFlowParams setDisplay(AuthRequestDisplayOpts display) {
        this.display = display;
        return this;
    }

    public List<AuthRequestPromptOpts> getPrompt() {
        return this.prompt;
    }

    public OAuthCodeFlowParams setPrompt(List<AuthRequestPromptOpts> prompt) {
        this.prompt = prompt;
        return this;
    }

    public Integer getMaxAge() {
        return this.maxAge;
    }

    public OAuthCodeFlowParams setMaxAge(Integer maxAge) {
        this.maxAge = maxAge;
        return this;
    }

    public String getUiLocales() {
        return this.uiLocales;
    }

    public OAuthCodeFlowParams setUiLocales(String uiLocales) {
        this.uiLocales = uiLocales;
        return this;
    }

    public String getIdTokenHint() {
        return this.idTokenHint;
    }

    public OAuthCodeFlowParams setIdTokenHint(String idTokenHint) {
        this.idTokenHint = idTokenHint;
        return this;
    }

    public String getLoginHint() {
        return this.loginHint;
    }

    public OAuthCodeFlowParams setLoginHint(String loginHint) {
        this.loginHint = loginHint;
        return this;
    }

    public String getAcrValues() {
        return this.acrValues;
    }

    public OAuthCodeFlowParams setAcrValues(String acrValues) {
        this.acrValues = acrValues;
        return this;
    }

    public static enum AuthRequestResponseType {
        CODE,
        ID_TOKEN;

    }

    public static enum AuthRequestDisplayOpts {
        PAGE,
        POPUP,
        TOUCH,
        WAP;

    }

    public static enum AuthRequestPromptOpts {
        NONE,
        LOGIN,
        CONSENT,
        SELECT_ACCOUNT;

    }
}

