/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mongodb.processor.idempotent;

import com.mongodb.ErrorCategory;
import com.mongodb.MongoWriteException;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.result.DeleteResult;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.bson.Document;
import org.bson.conversions.Bson;

@Metadata(label="bean", description="Idempotent repository that uses MongoDB to store message ids.", annotations={"interfaceName=org.apache.camel.spi.IdempotentRepository"})
@Configurer(metadataOnly=true)
@ManagedResource(description="MongoDB based message id repository")
public class MongoDbIdempotentRepository
extends ServiceSupport
implements IdempotentRepository {
    @Metadata(description="The MongoClient to use for connecting to the MongoDB server", required=true)
    private MongoClient mongoClient;
    @Metadata(description="The Database name", required=true)
    private String dbName;
    @Metadata(description="The collection name", required=true)
    private String collectionName;
    private MongoCollection<Document> collection;

    public MongoDbIdempotentRepository() {
    }

    public MongoDbIdempotentRepository(MongoClient mongoClient, String collectionName, String dbName) {
        this.mongoClient = mongoClient;
        this.collectionName = collectionName;
        this.dbName = dbName;
    }

    @ManagedOperation(description="Adds the key to the store")
    public boolean add(String key) {
        Document document = new Document("_id", (Object)key);
        try {
            this.collection.insertOne((Object)document);
        }
        catch (MongoWriteException ex) {
            if (ex.getError().getCategory() == ErrorCategory.DUPLICATE_KEY) {
                return false;
            }
            throw ex;
        }
        return true;
    }

    @ManagedOperation(description="Does the store contain the given key")
    public boolean contains(String key) {
        Bson document = Filters.eq((String)"_id", (Object)key);
        long count = this.collection.countDocuments(document);
        return count > 0L;
    }

    @ManagedOperation(description="Remove the key from the store")
    public boolean remove(String key) {
        Bson document = Filters.eq((String)"_id", (Object)key);
        DeleteResult res = this.collection.deleteOne(document);
        return res.getDeletedCount() > 0L;
    }

    public boolean confirm(String key) {
        return true;
    }

    @ManagedOperation(description="Clear the store")
    public void clear() {
        this.collection.deleteMany((Bson)new Document());
    }

    protected void doStart() throws Exception {
        ObjectHelper.notNull((Object)this.mongoClient, (String)"cli");
        ObjectHelper.notNull((Object)this.dbName, (String)"dbName");
        ObjectHelper.notNull((Object)this.collectionName, (String)"collectionName");
        if (this.collection == null) {
            this.collection = this.mongoClient.getDatabase(this.dbName).getCollection(this.collectionName);
        }
    }

    protected void doStop() throws Exception {
    }

    public MongoClient getMongoClient() {
        return this.mongoClient;
    }

    public void setMongoClient(MongoClient mongoClient) {
        this.mongoClient = mongoClient;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }
}

