/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.camel.maven.EmbeddedMojo;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DotMojo
extends AbstractMavenReport {
    public static final String[] DEFAULT_GRAPHVIZ_OUTPUT_TYPES = new String[]{"png", "svg", "cmapx"};
    protected static final String SUBDIRECTORY = "cameldoc";
    private String indexHtmlContent;
    private MavenProject project;
    private File buildDirectory;
    private File outputDirectory;
    private String executable;
    private String graphvizOutputType;
    private String[] graphvizOutputTypes;
    private Renderer renderer;
    protected String duration;
    protected boolean runCamel;

    public String getDescription(Locale locale) {
        return this.getBundle(locale).getString("report.description");
    }

    public String getName(Locale locale) {
        return this.getBundle(locale).getString("report.name");
    }

    public String getOutputName() {
        return "cameldoc/index";
    }

    public void execute() throws MojoExecutionException {
        this.execute(this.buildDirectory, Locale.getDefault());
        try {
            this.writeIndexHtmlFile("index.html", this.indexHtmlContent);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed: " + e, (Exception)e);
        }
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        try {
            this.execute(this.outputDirectory, locale);
            Sink kitchenSink = this.getSink();
            if (kitchenSink != null) {
                kitchenSink.rawText(this.indexHtmlContent);
            } else {
                this.writeIndexHtmlFile("index.html", this.indexHtmlContent);
            }
        }
        catch (Exception e) {
            MavenReportException ex = new MavenReportException(e.getMessage());
            ex.initCause(e.getCause());
            throw ex;
        }
    }

    protected void execute(File outputDir, Locale locale) throws MojoExecutionException {
        try {
            this.runCamelEmbedded(outputDir);
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Failed: " + (Object)((Object)e), (Exception)((Object)e));
        }
        outputDir.mkdirs();
        ArrayList<File> files = new ArrayList<File>();
        this.appendFiles(files, this.outputDirectory);
        if (this.graphvizOutputTypes == null) {
            this.graphvizOutputTypes = this.graphvizOutputType == null ? DEFAULT_GRAPHVIZ_OUTPUT_TYPES : new String[]{this.graphvizOutputType};
        }
        try {
            for (int i = 0; i < files.size(); ++i) {
                int idx;
                File file = (File)files.get(i);
                StringWriter buffer = new StringWriter();
                PrintWriter out = new PrintWriter(buffer);
                this.printHtmlHeader(out);
                this.printHtmlFileHeader(out, file);
                for (int j = 0; j < this.graphvizOutputTypes.length; ++j) {
                    String format = this.graphvizOutputTypes[j];
                    String generated = this.convertFile(file, format);
                    if (!format.equals("cmapx")) continue;
                    this.addFileToBuffer(out, new File(generated));
                }
                this.printHtmlFileFooter(out, file);
                this.printHtmlFooter(out);
                String content = buffer.toString();
                String name = file.getName();
                if (name.equalsIgnoreCase("routes.dot") || i == 0) {
                    this.indexHtmlContent = content;
                }
                if ((idx = name.lastIndexOf(".")) >= 0) {
                    name = name.substring(0, idx);
                    name = name + ".html";
                }
                this.writeIndexHtmlFile(name, content);
            }
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("Failed: " + (Object)((Object)e), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed: " + e, (Exception)e);
        }
    }

    protected void runCamelEmbedded(File outputDir) throws DependencyResolutionRequiredException {
        if (this.runCamel) {
            this.getLog().info((CharSequence)"Running Camel embedded to load META-INF/spring/*.xml files");
            List list = this.project.getTestClasspathElements();
            this.getLog().debug((CharSequence)("Using classpath: " + list));
            EmbeddedMojo mojo = new EmbeddedMojo();
            mojo.setClasspathElements(list);
            mojo.setDotEnabled(true);
            mojo.setOutputDirectory(this.outputDirectory.getAbsolutePath());
            mojo.setDuration(this.duration);
            mojo.setLog(this.getLog());
            mojo.setPluginContext(this.getPluginContext());
            try {
                mojo.executeWithoutWrapping();
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)("Failed to run Camel embedded: " + e), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeIndexHtmlFile(String fileName, String content) throws IOException {
        File dir = this.outputDirectory;
        dir.mkdirs();
        File html = new File(dir, fileName);
        PrintWriter out = null;
        try {
            out = new PrintWriter(new FileWriter(html));
            out.println("<html>");
            out.println("<head>");
            out.println("</head>");
            out.println("<body>");
            out.println();
            if (content == null) {
                out.write("<p>No EIP diagrams available</p>");
            } else {
                out.write(content);
            }
            out.println("</body>");
            out.println("</html>");
        }
        finally {
            String description = "Failed to close html output file";
            this.close(out, description);
        }
    }

    protected void printHtmlHeader(PrintWriter out) {
        out.println("<h1>Camel EIP Patterns</h1>");
        out.println();
    }

    protected void printHtmlFileHeader(PrintWriter out, File file) {
        out.println("<p>");
        out.println("  <img src='" + this.removeFileExtension(file.getName()) + ".png' usemap='#CamelRoutes'>");
    }

    protected void printHtmlFileFooter(PrintWriter out, File file) {
        out.println("  </img>");
        out.println("</p>");
        out.println();
    }

    protected void printHtmlFooter(PrintWriter out) {
        out.println();
    }

    protected void close(Closeable closeable, String description) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)(description + ": " + e));
            }
        }
    }

    protected String convertFile(File file, String format) throws CommandLineException {
        String errOutput;
        String generatedFileName = this.removeFileExtension(file.getAbsolutePath()) + "." + format;
        Log log = this.getLog();
        Commandline cl = new Commandline();
        cl.setExecutable(this.executable);
        cl.createArgument().setValue("-T" + format);
        cl.createArgument().setValue("-o");
        cl.createArgument().setValue(generatedFileName);
        cl.createArgument().setValue(file.getAbsolutePath());
        log.debug((CharSequence)("executing: " + cl.toString()));
        CommandLineUtils.StringStreamConsumer stdout = new CommandLineUtils.StringStreamConsumer();
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        int exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)stdout, (StreamConsumer)stderr);
        String output = stdout.getOutput();
        if (output.length() > 0) {
            log.debug((CharSequence)output);
        }
        if ((errOutput = stderr.getOutput()).length() > 0) {
            log.warn((CharSequence)errOutput);
        }
        return generatedFileName;
    }

    protected String removeFileExtension(String name) {
        int idx = name.lastIndexOf(".");
        if (idx > 0) {
            return name.substring(0, idx);
        }
        return name;
    }

    private void appendFiles(List<File> output, File file) {
        if (file.isDirectory()) {
            this.appendDirectory(output, file);
        } else if (this.isValid(file)) {
            output.add(file);
        }
    }

    private void appendDirectory(List<File> output, File dir) {
        File[] files;
        for (File file : files = dir.listFiles()) {
            this.appendFiles(output, file);
        }
    }

    private boolean isValid(File file) {
        String name = file.getName().toLowerCase();
        return name.endsWith(".dot");
    }

    private void addFileToBuffer(PrintWriter out, File file) throws MojoExecutionException {
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(file));
            while ((line = reader.readLine()) != null) {
                out.println(line);
            }
            this.close(reader, "cmapx file");
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("Failed: " + e, (Exception)e);
            }
            catch (Throwable throwable) {
                this.close(reader, "cmapx file");
                throw throwable;
            }
        }
    }

    protected ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("camel-maven-plugin", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }

    protected Renderer getSiteRenderer() {
        return this.renderer;
    }

    protected String getOutputDirectory() {
        return this.outputDirectory.getAbsolutePath();
    }

    protected MavenProject getProject() {
        return this.project;
    }
}

