/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import org.apache.camel.CamelContext;
import org.apache.camel.Service;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedConsumerCacheMBean;
import org.apache.camel.management.mbean.ManagedService;
import org.apache.camel.spi.ConsumerCache;

@ManagedResource(description="Managed ConsumerCache")
public class ManagedConsumerCache
extends ManagedService
implements ManagedConsumerCacheMBean {
    private final ConsumerCache consumerCache;

    public ManagedConsumerCache(CamelContext context, ConsumerCache consumerCache) {
        super(context, (Service)consumerCache);
        this.consumerCache = consumerCache;
    }

    public ConsumerCache getConsumerCache() {
        return this.consumerCache;
    }

    public String getSource() {
        if (this.consumerCache.getSource() != null) {
            return this.consumerCache.getSource().toString();
        }
        return null;
    }

    public Integer getSize() {
        return this.consumerCache.size();
    }

    public Integer getMaximumCacheSize() {
        return this.consumerCache.getCapacity();
    }

    public Long getHits() {
        return this.consumerCache.getHits();
    }

    public Long getMisses() {
        return this.consumerCache.getMisses();
    }

    public Long getEvicted() {
        return this.consumerCache.getEvicted();
    }

    public void resetStatistics() {
        this.consumerCache.resetCacheStatistics();
    }

    public void purge() {
        this.consumerCache.purge();
    }
}

