/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mail;

import javax.mail.Folder;
import javax.mail.Message;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.mail.JavaMailConnection;
import org.apache.camel.component.mail.MailBinding;
import org.apache.camel.component.mail.MailComponent;
import org.apache.camel.component.mail.MailConfiguration;
import org.apache.camel.component.mail.MailConsumer;
import org.apache.camel.component.mail.MailExchange;
import org.apache.camel.component.mail.MailProducer;
import org.apache.camel.impl.ScheduledPollEndpoint;
import org.springframework.mail.javamail.JavaMailSender;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailEndpoint
extends ScheduledPollEndpoint<MailExchange> {
    private MailBinding binding;
    private MailConfiguration configuration;

    public MailEndpoint(String uri, MailComponent component, MailConfiguration configuration) {
        super(uri, (Component)component);
        this.configuration = configuration;
    }

    public Producer<MailExchange> createProducer() throws Exception {
        JavaMailConnection sender = this.configuration.createJavaMailConnection(this);
        return this.createProducer((JavaMailSender)sender);
    }

    public Producer<MailExchange> createProducer(JavaMailSender sender) throws Exception {
        return new MailProducer(this, sender);
    }

    public Consumer<MailExchange> createConsumer(Processor processor) throws Exception {
        String folderName;
        Folder folder;
        JavaMailConnection connection = this.configuration.createJavaMailConnection(this);
        String protocol = this.getConfiguration().getProtocol();
        if (protocol.equals("smtp")) {
            protocol = "pop3";
        }
        if ((folder = connection.getFolder(protocol, folderName = this.getConfiguration().getFolderName())) == null) {
            throw new IllegalArgumentException("No folder for protocol: " + protocol + " and name: " + folderName);
        }
        return this.createConsumer(processor, folder);
    }

    public Consumer<MailExchange> createConsumer(Processor processor, Folder folder) throws Exception {
        MailConsumer answer = new MailConsumer(this, processor, folder);
        this.configureConsumer((Consumer)answer);
        return answer;
    }

    public MailExchange createExchange(ExchangePattern pattern) {
        return new MailExchange(this.getContext(), pattern, this.getBinding());
    }

    public MailExchange createExchange(Message message) {
        return new MailExchange(this.getContext(), this.getExchangePattern(), this.getBinding(), message);
    }

    public MailBinding getBinding() {
        if (this.binding == null) {
            this.binding = new MailBinding();
        }
        return this.binding;
    }

    public void setBinding(MailBinding binding) {
        this.binding = binding;
    }

    public boolean isSingleton() {
        return false;
    }

    public MailConfiguration getConfiguration() {
        return this.configuration;
    }
}

