/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mail;

import java.net.URI;
import java.util.Properties;
import javax.mail.Session;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.mail.JavaMailConnection;
import org.apache.camel.component.mail.MailEndpoint;

public class MailConfiguration
implements Cloneable {
    private String defaultEncoding;
    private String host;
    private Properties javaMailProperties;
    private String password;
    private String protocol;
    private Session session;
    private String username;
    private int port = -1;
    private String destination;
    private String from = "camel@localhost";
    private boolean deleteProcessedMessages = true;
    private String folderName = "INBOX";

    public MailConfiguration copy() {
        try {
            return (MailConfiguration)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    public void configure(URI uri) {
        String fragment;
        int port;
        String userInfo;
        String scheme;
        String value = uri.getHost();
        if (value != null) {
            this.setHost(value);
        }
        if ((scheme = uri.getScheme()) != null) {
            this.setProtocol(scheme);
        }
        if ((userInfo = uri.getUserInfo()) != null) {
            this.setUsername(userInfo);
        }
        if ((port = uri.getPort()) >= 0) {
            this.setPort(port);
        }
        if ((fragment = uri.getFragment()) == null || fragment.length() == 0) {
            fragment = userInfo + "@" + this.host;
        } else {
            this.setFolderName(fragment);
        }
        this.setDestination(fragment);
    }

    public JavaMailConnection createJavaMailConnection(MailEndpoint mailEndpoint) {
        JavaMailConnection answer = new JavaMailConnection();
        if (this.defaultEncoding != null) {
            answer.setDefaultEncoding(this.defaultEncoding);
        }
        if (this.host != null) {
            answer.setHost(this.host);
        }
        if (this.javaMailProperties != null) {
            answer.setJavaMailProperties(this.javaMailProperties);
        }
        if (this.port >= 0) {
            answer.setPort(this.port);
        }
        if (this.password != null) {
            answer.setPassword(this.password);
        }
        if (this.protocol != null) {
            answer.setProtocol(this.protocol);
        }
        if (this.session != null) {
            answer.setSession(this.session);
        }
        if (this.username != null) {
            answer.setUsername(this.username);
        }
        return answer;
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public void setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Properties getJavaMailProperties() {
        return this.javaMailProperties;
    }

    public void setJavaMailProperties(Properties javaMailProperties) {
        this.javaMailProperties = javaMailProperties;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public boolean isDeleteProcessedMessages() {
        return this.deleteProcessedMessages;
    }

    public void setDeleteProcessedMessages(boolean deleteProcessedMessages) {
        this.deleteProcessedMessages = deleteProcessedMessages;
    }

    public String getFolderName() {
        return this.folderName;
    }

    public void setFolderName(String folderName) {
        this.folderName = folderName;
    }
}

