/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.langchain4j.agent.api;

import dev.langchain4j.service.AiServices;
import dev.langchain4j.service.tool.ToolProvider;
import org.apache.camel.component.langchain4j.agent.api.Agent;
import org.apache.camel.component.langchain4j.agent.api.AgentConfiguration;
import org.apache.camel.component.langchain4j.agent.api.AiAgentBody;
import org.apache.camel.component.langchain4j.agent.api.AiAgentWithMemoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentWithMemory
implements Agent {
    private static final Logger LOG = LoggerFactory.getLogger(AgentWithMemory.class);
    private final AgentConfiguration configuration;

    public AgentWithMemory(AgentConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public String chat(AiAgentBody<?> aiAgentBody, ToolProvider toolProvider) {
        AiAgentWithMemoryService agentService = this.createAiAgentService(toolProvider);
        return aiAgentBody.getSystemMessage() != null ? agentService.chat(aiAgentBody.getMemoryId(), aiAgentBody.getUserMessage(), aiAgentBody.getSystemMessage()) : agentService.chat(aiAgentBody.getMemoryId(), aiAgentBody.getUserMessage());
    }

    private AiAgentWithMemoryService createAiAgentService(ToolProvider toolProvider) {
        AiServices builder = AiServices.builder(AiAgentWithMemoryService.class).chatModel(this.configuration.getChatModel()).chatMemoryProvider(this.configuration.getChatMemoryProvider());
        if (toolProvider != null) {
            builder.toolProvider(toolProvider);
        }
        if (this.configuration.getCustomTools() != null && !this.configuration.getCustomTools().isEmpty()) {
            builder.tools(this.configuration.getCustomTools());
        }
        if (this.configuration.getRetrievalAugmentor() != null) {
            builder.retrievalAugmentor(this.configuration.getRetrievalAugmentor());
        }
        if (this.configuration.getInputGuardrailClasses() != null && !this.configuration.getInputGuardrailClasses().isEmpty()) {
            builder.inputGuardrailClasses(this.configuration.getInputGuardrailClasses());
        }
        if (this.configuration.getOutputGuardrailClasses() != null && !this.configuration.getOutputGuardrailClasses().isEmpty()) {
            builder.outputGuardrailClasses(this.configuration.getOutputGuardrailClasses());
        }
        return (AiAgentWithMemoryService)builder.build();
    }
}

