/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jsonvalidator;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.schema.JsonSchema;
import java.io.Closeable;
import java.io.InputStream;
import java.util.Set;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.ValidationException;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.ResourceEndpoint;
import org.apache.camel.component.jsonvalidator.DefaultJsonSchemaLoader;
import org.apache.camel.component.jsonvalidator.DefaultJsonValidationErrorHandler;
import org.apache.camel.component.jsonvalidator.JsonSchemaLoader;
import org.apache.camel.component.jsonvalidator.JsonValidatorErrorHandler;
import org.apache.camel.component.jsonvalidator.NoJsonBodyValidationException;
import org.apache.camel.component.jsonvalidator.NoJsonHeaderValidationException;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.util.IOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedResource(description="Managed JsonValidatorEndpoint")
@UriEndpoint(scheme="json-validator", firstVersion="2.20.0", title="JSON Schema Validator", syntax="json-validator:resourceUri", producerOnly=true, label="validation")
public class JsonValidatorEndpoint
extends ResourceEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(JsonValidatorEndpoint.class);
    private volatile JsonSchema schema;
    @UriParam(defaultValue="true")
    private boolean failOnNullBody = true;
    @UriParam(defaultValue="true")
    private boolean failOnNullHeader = true;
    @UriParam(description="To validate against a header instead of the message body.")
    private String headerName;
    @UriParam(label="advanced")
    private JsonValidatorErrorHandler errorHandler = new DefaultJsonValidationErrorHandler();
    @UriParam(label="advanced")
    private JsonSchemaLoader schemaLoader = new DefaultJsonSchemaLoader();

    public JsonValidatorEndpoint(String endpointUri, Component component, String resourceUri) {
        super(endpointUri, component, resourceUri);
    }

    public void clearContentCache() {
        this.schema = null;
        super.clearContentCache();
    }

    public ExchangePattern getExchangePattern() {
        return ExchangePattern.InOut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onExchange(Exchange exchange) throws Exception {
        InputStream is;
        block11: {
            is = null;
            JsonSchema localSchema = this.schema;
            if (localSchema == null) {
                localSchema = this.getOrCreateSchema();
            }
            try {
                is = this.getContentToValidate(exchange, InputStream.class);
                if (this.shouldUseHeader()) {
                    if (is == null && this.isFailOnNullHeader()) {
                        throw new NoJsonHeaderValidationException(exchange, this.headerName);
                    }
                } else if (is == null && this.isFailOnNullBody()) {
                    throw new NoJsonBodyValidationException(exchange);
                }
                if (is == null) break block11;
                ObjectMapper mapper = new ObjectMapper();
                JsonNode node = mapper.readTree(is);
                Set errors = localSchema.validate(node);
                if (errors.size() > 0) {
                    LOG.debug("Validated JSon has {} errors", (Object)errors.size());
                    this.errorHandler.handleErrors(exchange, this.schema, errors);
                    break block11;
                }
                LOG.debug("Validated JSon success");
            }
            catch (Exception e) {
                try {
                    if (e instanceof ValidationException) {
                        throw e;
                    }
                    this.errorHandler.handleErrors(exchange, this.schema, e);
                }
                catch (Throwable throwable) {
                    IOHelper.close(is);
                    throw throwable;
                }
                IOHelper.close((Closeable)is);
            }
        }
        IOHelper.close((Closeable)is);
    }

    private <T> T getContentToValidate(Exchange exchange, Class<T> clazz) {
        if (this.shouldUseHeader()) {
            return (T)exchange.getIn().getHeader(this.headerName, clazz);
        }
        return (T)exchange.getIn().getBody(clazz);
    }

    private boolean shouldUseHeader() {
        return this.headerName != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsonSchema getOrCreateSchema() throws Exception {
        JsonValidatorEndpoint jsonValidatorEndpoint = this;
        synchronized (jsonValidatorEndpoint) {
            if (this.schema == null) {
                this.schema = this.schemaLoader.createSchema(this.getCamelContext(), this.getResourceAsInputStream());
            }
        }
        return this.schema;
    }

    protected String createEndpointUri() {
        return "json-validator:" + this.getResourceUri();
    }

    public JsonValidatorErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(JsonValidatorErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public JsonSchemaLoader getSchemaLoader() {
        return this.schemaLoader;
    }

    public void setSchemaLoader(JsonSchemaLoader schemaLoader) {
        this.schemaLoader = schemaLoader;
    }

    public boolean isFailOnNullBody() {
        return this.failOnNullBody;
    }

    public void setFailOnNullBody(boolean failOnNullBody) {
        this.failOnNullBody = failOnNullBody;
    }

    public boolean isFailOnNullHeader() {
        return this.failOnNullHeader;
    }

    public void setFailOnNullHeader(boolean failOnNullHeader) {
        this.failOnNullHeader = failOnNullHeader;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public void setHeaderName(String headerName) {
        this.headerName = headerName;
    }
}

