/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jslt;

import com.schibsted.spt.data.jslt.Function;
import com.schibsted.spt.data.jslt.filters.JsonFilter;
import java.util.Collection;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.jslt.JsltEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.ResourceHelper;

@Component(value="jslt")
public class JsltComponent
extends DefaultComponent {
    @Metadata(defaultValue="true", description="Sets whether to use resource content cache or not")
    private boolean contentCache = true;
    @Metadata
    private boolean allowTemplateFromHeader;
    @Metadata(label="advanced")
    private Collection<Function> functions;
    @Metadata(label="advanced")
    private JsonFilter objectFilter;

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        boolean cache = (Boolean)this.getAndRemoveParameter(parameters, "contentCache", Boolean.class, this.contentCache);
        JsltEndpoint answer = new JsltEndpoint(uri, this, remaining);
        answer.setContentCache(cache);
        answer.setAllowTemplateFromHeader(this.allowTemplateFromHeader);
        this.setProperties((Endpoint)answer, parameters);
        if (ResourceHelper.isHttpUri((String)remaining)) {
            remaining = ResourceHelper.appendParameters((String)remaining, parameters);
            answer.setResourceUri(remaining);
        }
        return answer;
    }

    public boolean isContentCache() {
        return this.contentCache;
    }

    public void setContentCache(boolean contentCache) {
        this.contentCache = contentCache;
    }

    public Collection<Function> getFunctions() {
        return this.functions;
    }

    public void setFunctions(Collection<Function> functions) {
        this.functions = functions;
    }

    public boolean isAllowTemplateFromHeader() {
        return this.allowTemplateFromHeader;
    }

    public void setAllowTemplateFromHeader(boolean allowTemplateFromHeader) {
        this.allowTemplateFromHeader = allowTemplateFromHeader;
    }

    public JsonFilter getObjectFilter() {
        return this.objectFilter;
    }

    public void setObjectFilter(JsonFilter objectFilter) {
        this.objectFilter = objectFilter;
    }
}

