/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.scp;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Logger;
import java.net.URI;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.remote.RemoteFileComponent;
import org.apache.camel.component.scp.ScpConfiguration;
import org.apache.camel.component.scp.ScpEndpoint;
import org.apache.camel.component.scp.ScpFile;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.util.StringHelper;

@Component(value="scp")
public class ScpComponent
extends RemoteFileComponent<ScpFile> {
    @Metadata
    private boolean verboseLogging;

    public ScpComponent() {
    }

    public ScpComponent(CamelContext context) {
        super(context);
    }

    protected GenericFileEndpoint<ScpFile> buildFileEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String tmp = StringHelper.before((String)uri, (String)"?", (String)uri);
        return new ScpEndpoint(uri, this, new ScpConfiguration(new URI(tmp)));
    }

    protected void afterPropertiesSet(GenericFileEndpoint<ScpFile> endpoint) throws Exception {
    }

    protected void doInit() throws Exception {
        super.doInit();
        this.initJsch();
    }

    public boolean isVerboseLogging() {
        return this.verboseLogging;
    }

    public void setVerboseLogging(boolean verboseLogging) {
        this.verboseLogging = verboseLogging;
    }

    protected void initJsch() {
        JSch.setConfig((String)"StrictHostKeyChecking", (String)"yes");
        JSch.setLogger((Logger)new Logger(){

            public boolean isEnabled(int level) {
                return level == 4 || level == 3 ? ScpComponent.this.log.isErrorEnabled() : (level == 2 ? ScpComponent.this.log.isWarnEnabled() : (level == 1 ? ScpComponent.this.log.isInfoEnabled() : ScpComponent.this.log.isDebugEnabled()));
            }

            public void log(int level, String message) {
                if (level == 4 || level == 3) {
                    ScpComponent.this.log.error("[JSCH] {}", (Object)message);
                } else if (level == 2) {
                    ScpComponent.this.log.warn("[JSCH] {}", (Object)message);
                } else if (level == 1) {
                    if (ScpComponent.this.isVerboseLogging()) {
                        ScpComponent.this.log.info("[JSCH] {}", (Object)message);
                    } else {
                        ScpComponent.this.log.debug("[JSCH] {}", (Object)message);
                    }
                } else {
                    ScpComponent.this.log.debug("[JSCH] {}", (Object)message);
                }
            }
        });
    }
}

