/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.irc;

import java.net.URI;
import org.apache.camel.RuntimeCamelException;

public class IrcConfiguration
implements Cloneable {
    private String target;
    private String hostname;
    private String password;
    private String nickname;
    private String realname;
    private String username;
    private boolean persistent = true;
    private boolean colors = true;
    private boolean onNick = true;
    private boolean onQuit = true;
    private boolean onJoin = true;
    private boolean onKick = true;
    private boolean onMode = true;
    private boolean onPart = true;
    private boolean onTopic = true;
    private boolean onPrivmsg = true;
    private int[] ports = new int[]{6667, 6668, 6669};

    public IrcConfiguration() {
    }

    public IrcConfiguration(String hostname, String nickname, String displayname, String target) {
        this.target = target;
        this.hostname = hostname;
        this.nickname = nickname;
        this.username = nickname;
        this.realname = displayname;
    }

    public IrcConfiguration(String hostname, String username, String password, String nickname, String displayname, String target) {
        this.target = target;
        this.hostname = hostname;
        this.username = username;
        this.password = password;
        this.nickname = nickname;
        this.realname = displayname;
    }

    public IrcConfiguration copy() {
        try {
            return (IrcConfiguration)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    public String getCacheKey() {
        return this.hostname + ":" + this.nickname;
    }

    public void configure(URI uri) {
        this.setNickname(uri.getUserInfo());
        this.setUsername(uri.getUserInfo());
        this.setRealname(uri.getUserInfo());
        this.setHostname(uri.getHost());
        this.setTarget(uri.getPath().substring(1));
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public String getRealname() {
        return this.realname;
    }

    public void setRealname(String realname) {
        this.realname = realname;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public int[] getPorts() {
        return this.ports;
    }

    public void setPorts(int[] ports) {
        this.ports = ports;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public boolean isColors() {
        return this.colors;
    }

    public void setColors(boolean colors) {
        this.colors = colors;
    }

    public boolean isOnNick() {
        return this.onNick;
    }

    public void setOnNick(boolean onNick) {
        this.onNick = onNick;
    }

    public boolean isOnQuit() {
        return this.onQuit;
    }

    public void setOnQuit(boolean onQuit) {
        this.onQuit = onQuit;
    }

    public boolean isOnJoin() {
        return this.onJoin;
    }

    public void setOnJoin(boolean onJoin) {
        this.onJoin = onJoin;
    }

    public boolean isOnKick() {
        return this.onKick;
    }

    public void setOnKick(boolean onKick) {
        this.onKick = onKick;
    }

    public boolean isOnMode() {
        return this.onMode;
    }

    public void setOnMode(boolean onMode) {
        this.onMode = onMode;
    }

    public boolean isOnPart() {
        return this.onPart;
    }

    public void setOnPart(boolean onPart) {
        this.onPart = onPart;
    }

    public boolean isOnTopic() {
        return this.onTopic;
    }

    public void setOnTopic(boolean onTopic) {
        this.onTopic = onTopic;
    }

    public boolean isOnPrivmsg() {
        return this.onPrivmsg;
    }

    public void setOnPrivmsg(boolean onPrivmsg) {
        this.onPrivmsg = onPrivmsg;
    }

    public String toString() {
        return "IrcConfiguration{target='" + this.target + '\'' + ", hostname='" + this.hostname + '\'' + ", password='" + this.password + '\'' + ", nickname='" + this.nickname + '\'' + ", realname='" + this.realname + '\'' + ", username='" + this.username + '\'' + ", persistent=" + this.persistent + ", colors=" + this.colors + ", onNick=" + this.onNick + ", onQuit=" + this.onQuit + ", onJoin=" + this.onJoin + ", onKick=" + this.onKick + ", onMode=" + this.onMode + ", onPart=" + this.onPart + ", onTopic=" + this.onTopic + ", onPrivmsg=" + this.onPrivmsg + ", ports=" + this.ports + '}';
    }
}

