/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import java.util.Optional;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.NameValuePair;

public final class HttpUtil {
    private HttpUtil() {
    }

    public static Optional<Header> responseHeader(HttpResponse response, String headerName) {
        return Optional.ofNullable(response.getFirstHeader(headerName));
    }

    public static Optional<String> responseHeaderValue(HttpResponse response, String headerName) {
        return HttpUtil.responseHeader(response, headerName).map(NameValuePair::getValue);
    }

    public static String removeHttpOrHttpsProtocol(String uri) {
        if (uri.startsWith("http://")) {
            uri = uri.substring(7);
        } else if (uri.startsWith("http:")) {
            uri = uri.substring(5);
        } else if (uri.startsWith("https://")) {
            uri = uri.substring(8);
        } else if (uri.startsWith("https:")) {
            uri = uri.substring(6);
        }
        return uri;
    }
}

