/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import java.util.List;
import org.apache.camel.component.http.HttpClientConfigurer;
import org.apache.camel.component.http.HttpCredentialsHelper;
import org.apache.hc.client5.http.auth.BearerToken;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.NTCredentials;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.auth.BasicSchemeFactory;
import org.apache.hc.client5.http.impl.auth.BearerSchemeFactory;
import org.apache.hc.client5.http.impl.auth.DigestSchemeFactory;
import org.apache.hc.client5.http.impl.auth.NTLMSchemeFactory;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.core5.http.config.Lookup;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;

public class DefaultAuthenticationHttpClientConfigurer
implements HttpClientConfigurer {
    private final String username;
    private final char[] password;
    private final String domain;
    private final String host;
    private final String bearerToken;
    private final HttpCredentialsHelper credentialsHelper;

    public DefaultAuthenticationHttpClientConfigurer(String user, String pwd, String domain, String host, String bearerToken, HttpCredentialsHelper credentialsHelper) {
        this.username = user;
        this.password = pwd == null ? new char[]{} : pwd.toCharArray();
        this.domain = domain;
        this.host = host;
        this.bearerToken = bearerToken;
        this.credentialsHelper = credentialsHelper;
    }

    @Override
    public void configureHttpClient(HttpClientBuilder clientBuilder) {
        Object defaultcreds;
        if (this.domain != null) {
            defaultcreds = new NTCredentials(this.username, this.password, this.host, this.domain);
            Registry autoSchemes = RegistryBuilder.create().register("Basic", (Object)BasicSchemeFactory.INSTANCE).register("Digest", (Object)DigestSchemeFactory.INSTANCE).register("Bearer", (Object)BearerSchemeFactory.INSTANCE).register("NTLM", (Object)NTLMSchemeFactory.INSTANCE).build();
            RequestConfig requestConfig = RequestConfig.custom().setTargetPreferredAuthSchemes(List.of("NTLM")).build();
            clientBuilder.setDefaultAuthSchemeRegistry((Lookup)autoSchemes).setDefaultRequestConfig(requestConfig);
            clientBuilder.setDefaultAuthSchemeRegistry((Lookup)autoSchemes);
        } else {
            defaultcreds = this.bearerToken != null ? new BearerToken(this.bearerToken) : new UsernamePasswordCredentials(this.username, this.password);
        }
        clientBuilder.setDefaultCredentialsProvider(this.credentialsHelper.getCredentialsProvider(this.host, null, (Credentials)defaultcreds));
    }
}

