/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;

public enum HttpMethods implements Expression
{
    GET(HttpGet.class),
    PATCH(HttpPatch.class),
    POST(HttpPost.class),
    PUT(HttpPut.class),
    DELETE(HttpDelete.class),
    HEAD(HttpHead.class),
    OPTIONS(HttpOptions.class),
    TRACE(HttpTrace.class);

    final boolean entity;

    private HttpMethods(Class<? extends HttpRequestBase> clazz) {
        this.entity = HttpEntityEnclosingRequestBase.class.isAssignableFrom(clazz);
    }

    public HttpRequestBase createMethod(String url) {
        switch (this) {
            case GET: {
                return new HttpGet(url);
            }
            case PATCH: {
                return new HttpPatch(url);
            }
            case POST: {
                return new HttpPost(url);
            }
            case PUT: {
                return new HttpPut(url);
            }
            case DELETE: {
                return new HttpDelete(url);
            }
            case HEAD: {
                return new HttpHead(url);
            }
            case OPTIONS: {
                return new HttpOptions(url);
            }
            case TRACE: {
                return new HttpTrace(url);
            }
        }
        throw new RuntimeException("no such method " + (Object)((Object)this));
    }

    public final boolean isEntityEnclosing() {
        return this.entity;
    }

    public <T> T evaluate(Exchange exchange, Class<T> type) {
        return (T)ExpressionBuilder.constantExpression((Object)this.name()).evaluate(exchange, type);
    }
}

