/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import java.io.InputStream;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.DeferredContextBinding;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.http.HttpEntityConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;
import org.apache.http.HttpEntity;

@DeferredContextBinding
public final class HttpEntityConverterLoader
implements TypeConverterLoader,
CamelContextAware {
    private CamelContext camelContext;

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        HttpEntityConverterLoader.addTypeConverter(registry, HttpEntity.class, byte[].class, false, (type, exchange, value) -> HttpEntityConverter.toHttpEntity((byte[])value, exchange));
        HttpEntityConverterLoader.addTypeConverter(registry, HttpEntity.class, InputStream.class, false, (type, exchange, value) -> HttpEntityConverter.toHttpEntity((InputStream)value, exchange));
        HttpEntityConverterLoader.addTypeConverter(registry, HttpEntity.class, String.class, false, (type, exchange, value) -> HttpEntityConverter.toHttpEntity((String)value, exchange));
    }

    private static void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, (TypeConverter)new SimpleTypeConverter(allowNull, method));
    }
}

