/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.camel.Message;
import org.apache.camel.component.http.HttpExchange;
import org.apache.camel.component.http.HttpMessage;

public class HttpBinding {
    public void writeResponse(HttpExchange exchange, HttpServletResponse response) throws IOException {
        Message out = exchange.getOut();
        if (out != null) {
            for (String key : out.getHeaders().keySet()) {
                String value = (String)out.getHeader(key, String.class);
                if (value == null) continue;
                response.setHeader(key, value);
            }
            if (out.getBody() != null) {
                InputStream is = (InputStream)out.getBody(InputStream.class);
                if (is != null) {
                    int c;
                    ServletOutputStream os = response.getOutputStream();
                    while ((c = is.read()) >= 0) {
                        os.write(c);
                    }
                } else {
                    String data = (String)out.getBody(String.class);
                    if (data != null) {
                        response.getWriter().print(data);
                    }
                }
            }
        }
    }

    public Object parseBody(HttpMessage httpMessage) throws IOException {
        HttpServletRequest request = httpMessage.getRequest();
        return request.getReader();
    }
}

