/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.pubsub.consumer;

import com.google.cloud.pubsub.v1.AckReplyConsumer;
import com.google.cloud.pubsub.v1.MessageReceiver;
import com.google.common.base.Strings;
import com.google.pubsub.v1.PubsubMessage;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.google.pubsub.GooglePubsubConstants;
import org.apache.camel.component.google.pubsub.GooglePubsubConsumer;
import org.apache.camel.component.google.pubsub.GooglePubsubEndpoint;
import org.apache.camel.component.google.pubsub.GooglePubsubHeaderFilterStrategy;
import org.apache.camel.component.google.pubsub.consumer.AcknowledgeAsync;
import org.apache.camel.component.google.pubsub.consumer.AcknowledgeCompletion;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.Synchronization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelMessageReceiver
implements MessageReceiver {
    private final Logger localLog;
    private final GooglePubsubConsumer consumer;
    private final GooglePubsubEndpoint endpoint;
    private final Processor processor;
    private final HeaderFilterStrategy headerFilterStrategy;

    public CamelMessageReceiver(GooglePubsubConsumer consumer, GooglePubsubEndpoint endpoint, Processor processor) {
        this.consumer = consumer;
        this.endpoint = endpoint;
        this.processor = processor;
        String loggerId = endpoint.getLoggerId();
        if (Strings.isNullOrEmpty((String)loggerId)) {
            loggerId = this.getClass().getName();
        }
        this.localLog = LoggerFactory.getLogger((String)loggerId);
        this.headerFilterStrategy = new GooglePubsubHeaderFilterStrategy(endpoint.isIncludeAllGoogleProperties());
    }

    public void receiveMessage(PubsubMessage pubsubMessage, AckReplyConsumer ackReplyConsumer) {
        if (this.localLog.isTraceEnabled()) {
            this.localLog.trace("Received message ID : {}", (Object)pubsubMessage.getMessageId());
        }
        Exchange exchange = this.consumer.createExchange(true);
        exchange.getIn().setBody((Object)pubsubMessage.getData().toByteArray());
        exchange.getIn().setHeader("CamelGooglePubsubMessageId", (Object)pubsubMessage.getMessageId());
        exchange.getIn().setHeader("CamelGooglePubsubPublishTime", (Object)pubsubMessage.getPublishTime());
        exchange.getIn().setHeader("CamelGooglePubsubAttributes", (Object)pubsubMessage.getAttributesMap());
        AcknowledgeAsync acknowledge = new AcknowledgeAsync(ackReplyConsumer);
        if (this.endpoint.getAckMode() != GooglePubsubConstants.AckMode.NONE) {
            exchange.getExchangeExtension().addOnCompletion((Synchronization)new AcknowledgeCompletion(acknowledge));
        } else {
            exchange.getIn().setHeader("CamelGooglePubsubAcknowledge", (Object)acknowledge);
        }
        for (String pubSubHeader : pubsubMessage.getAttributesMap().keySet()) {
            String value = (String)pubsubMessage.getAttributesMap().get(pubSubHeader);
            if (this.headerFilterStrategy != null && this.headerFilterStrategy.applyFilterToExternalHeaders(pubSubHeader, (Object)value, exchange)) continue;
            exchange.getIn().setHeader(pubSubHeader, (Object)value);
        }
        try {
            this.processor.process(exchange);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        if (exchange.getException() != null) {
            this.consumer.getExceptionHandler().handleException((Throwable)exchange.getException());
        }
    }
}

