/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.pubsublite;

import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.google.pubsublite.GooglePubsubLiteComponent;
import org.apache.camel.component.google.pubsublite.GooglePubsubLiteConstants;
import org.apache.camel.component.google.pubsublite.GooglePubsubLiteConsumer;
import org.apache.camel.component.google.pubsublite.GooglePubsubLiteProducer;
import org.apache.camel.component.google.pubsublite.serializer.DefaultGooglePubsubSerializer;
import org.apache.camel.component.google.pubsublite.serializer.GooglePubsubSerializer;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="4.6.0", scheme="google-pubsub-lite", title="Google PubSub Lite", syntax="google-pubsub-lite:projectId:location:destinationName", category={Category.CLOUD, Category.MESSAGING}, headersClass=GooglePubsubLiteConstants.class)
public class GooglePubsubLiteEndpoint
extends DefaultEndpoint
implements EndpointServiceLocation {
    private Logger log;
    @UriPath(label="common", description="The Google Cloud PubSub Lite Project Id")
    @Metadata(required=true)
    private Long projectId;
    @UriPath(label="common", description="The Google Cloud PubSub Lite location")
    @Metadata(required=true)
    private String location;
    @UriPath(label="common", description="The Destination Name. For the consumer this will be the subscription name, while for the producer this will be the topic name.")
    @Metadata(required=true)
    private String destinationName;
    @UriParam(label="security", description="The Service account key that can be used as credentials for the PubSub publisher/subscriber. It can be loaded by default from  classpath, but you can prefix with classpath:, file:, or http: to load the resource from different systems.")
    private String serviceAccountKey;
    @UriParam(name="loggerId", description="Logger ID to use when a match to the parent route required")
    private String loggerId;
    @UriParam(label="consumer", description="The number of parallel streams consuming from the subscription", defaultValue="1")
    private Integer concurrentConsumers = 1;
    @UriParam(label="consumer", description="The max number of messages to receive from the server in a single API call", defaultValue="1")
    private Integer maxMessagesPerPoll = 1;
    @UriParam(label="consumer", defaultValue="AUTO", enums="AUTO,NONE", description="AUTO = exchange gets ack'ed/nack'ed on completion. NONE = downstream process has to ack/nack explicitly")
    private GooglePubsubLiteConstants.AckMode ackMode = GooglePubsubLiteConstants.AckMode.AUTO;
    @UriParam(label="consumer", name="maxAckExtensionPeriod", description="Set the maximum period a message ack deadline will be extended. Value in seconds", defaultValue="3600")
    private int maxAckExtensionPeriod = 3600;
    @UriParam(description="Pub/Sub endpoint to use. Required when using message ordering, and ensures that messages are received in order even when multiple publishers are used", label="producer,advanced")
    private String pubsubEndpoint;
    @UriParam(name="serializer", description="A custom GooglePubsubLiteSerializer to use for serializing message payloads in the producer", label="producer,advanced")
    @Metadata(autowired=true)
    private GooglePubsubSerializer serializer;

    public GooglePubsubLiteEndpoint(String uri, Component component) {
        super(uri, component);
    }

    public GooglePubsubLiteComponent getComponent() {
        return (GooglePubsubLiteComponent)super.getComponent();
    }

    public void afterPropertiesSet() {
        this.log = ObjectHelper.isEmpty((String)this.loggerId) ? LoggerFactory.getLogger((String)((Object)((Object)this)).getClass().getName()) : LoggerFactory.getLogger((String)this.loggerId);
        this.log.trace("Project ID: {}", (Object)this.projectId);
        this.log.trace("Destination Name: {}", (Object)this.destinationName);
    }

    public Producer createProducer() throws Exception {
        this.afterPropertiesSet();
        if (ObjectHelper.isEmpty((Object)this.serializer)) {
            this.serializer = new DefaultGooglePubsubSerializer();
        }
        return new GooglePubsubLiteProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        this.afterPropertiesSet();
        this.setExchangePattern(ExchangePattern.InOnly);
        GooglePubsubLiteConsumer consumer = new GooglePubsubLiteConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public ExecutorService createExecutor(Object source) {
        return this.getCamelContext().getExecutorServiceManager().newFixedThreadPool(source, "GooglePubsubLiteConsumer[" + this.getDestinationName() + "]", this.concurrentConsumers.intValue());
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public void setProjectId(String projectId) {
        this.setProjectId(Long.parseLong(projectId));
    }

    public String getLoggerId() {
        return this.loggerId;
    }

    public void setLoggerId(String loggerId) {
        this.loggerId = loggerId;
    }

    public String getServiceAccountKey() {
        return this.serviceAccountKey;
    }

    public void setServiceAccountKey(String serviceAccountKey) {
        this.serviceAccountKey = serviceAccountKey;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    public Integer getConcurrentConsumers() {
        return this.concurrentConsumers;
    }

    public void setConcurrentConsumers(Integer concurrentConsumers) {
        this.concurrentConsumers = concurrentConsumers;
    }

    public Integer getMaxMessagesPerPoll() {
        return this.maxMessagesPerPoll;
    }

    public void setMaxMessagesPerPoll(Integer maxMessagesPerPoll) {
        this.maxMessagesPerPoll = maxMessagesPerPoll;
    }

    public GooglePubsubLiteConstants.AckMode getAckMode() {
        return this.ackMode;
    }

    public void setAckMode(GooglePubsubLiteConstants.AckMode ackMode) {
        this.ackMode = ackMode;
    }

    public int getMaxAckExtensionPeriod() {
        return this.maxAckExtensionPeriod;
    }

    public void setMaxAckExtensionPeriod(int maxAckExtensionPeriod) {
        this.maxAckExtensionPeriod = maxAckExtensionPeriod;
    }

    public GooglePubsubSerializer getSerializer() {
        return this.serializer;
    }

    public void setSerializer(GooglePubsubSerializer serializer) {
        this.serializer = serializer;
    }

    public String getPubsubEndpoint() {
        return this.pubsubEndpoint;
    }

    public void setPubsubEndpoint(String pubsubEndpoint) {
        this.pubsubEndpoint = pubsubEndpoint;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getServiceUrl() {
        if (ObjectHelper.isNotEmpty((String)this.getPubsubEndpoint())) {
            return this.getServiceProtocol() + ":" + this.getPubsubEndpoint();
        }
        return null;
    }

    public String getServiceProtocol() {
        return "pubsub-lite";
    }

    public Map<String, String> getServiceMetadata() {
        if (this.getDestinationName() != null) {
            return Map.of("destinationName", this.getDestinationName());
        }
        return null;
    }
}

