/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.bigquery.sql;

import com.google.cloud.RetryOption;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryException;
import com.google.cloud.bigquery.Job;
import com.google.cloud.bigquery.JobConfiguration;
import com.google.cloud.bigquery.JobId;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.JobStatistics;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.QueryParameterValue;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardSQLTypeName;
import com.google.cloud.bigquery.TableResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.StreamSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.component.google.bigquery.sql.FieldValueListMapper;
import org.apache.camel.component.google.bigquery.sql.GoogleBigQuerySQLConfiguration;
import org.apache.camel.component.google.bigquery.sql.GoogleBigQuerySQLEndpoint;
import org.apache.camel.component.google.bigquery.sql.SqlHelper;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.support.RowMapper;
import org.apache.camel.support.StreamListIterator;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleBigQuerySQLProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(GoogleBigQuerySQLProducer.class);
    private final GoogleBigQuerySQLConfiguration configuration;
    private final BigQuery bigquery;
    private String query;
    private Set<String> queryParameterNames;

    public GoogleBigQuerySQLProducer(BigQuery bigquery, GoogleBigQuerySQLEndpoint endpoint, GoogleBigQuerySQLConfiguration configuration) {
        super((Endpoint)endpoint);
        this.bigquery = bigquery;
        this.configuration = configuration;
    }

    public void process(Exchange exchange) throws Exception {
        String translatedQuery = SqlHelper.translateQuery(this.query, exchange);
        Map<String, Object> queryParameters = this.extractParameters(exchange);
        Message message = exchange.getMessage();
        message.setHeader("CamelGoogleBigQueryTranslatedQuery", (Object)translatedQuery);
        JobId jobId = (JobId)message.getHeader("CamelGoogleBigQueryJobId", JobId.class);
        Job job = this.executeJob(jobId, translatedQuery, queryParameters);
        if (GoogleBigQuerySQLProducer.isSelectQueryJob(job)) {
            this.processSelectQueryJob(message, job);
        } else {
            long affectedRows = ((JobStatistics.QueryStatistics)job.getStatistics()).getNumDmlAffectedRows();
            LOG.debug("The query {} affected {} rows", (Object)this.query, (Object)affectedRows);
            message.setBody((Object)affectedRows);
        }
    }

    private void processSelectQueryJob(Message message, Job job) throws Exception {
        long pageSize = this.configuration.getPageSize();
        String pageToken = (String)message.getHeader("CamelGoogleBigQueryPageToken", this.configuration::getPageToken, String.class);
        TableResult result = this.getTableResult(job, pageSize, pageToken);
        Schema schema = result.getSchema();
        if (schema == null) {
            LOG.debug("Query result schema is null. Unable to process the result set.");
            message.setBody((Object)result.getTotalRows());
            return;
        }
        switch (this.configuration.getOutputType()) {
            case SELECT_LIST: {
                List<Map<String, Object>> rows = this.processSelectResult(result, schema);
                LOG.debug("The query {} returned {} rows", (Object)this.query, (Object)rows.size());
                message.setBody(rows);
                message.setHeader("CamelGoogleBigQueryNextPageToken", (Object)result.getNextPageToken());
                message.setHeader("CamelGoogleBigQueryJobId", (Object)job.getJobId());
                break;
            }
            case STREAM_LIST: {
                StreamListIterator iterator = new StreamListIterator((RowMapper)new FieldValueListMapper(schema.getFields()), result.iterateAll().iterator());
                message.setBody((Object)iterator);
            }
        }
    }

    private Job executeJob(JobId jobId, String translatedQuery, Map<String, Object> queryParameters) throws Exception {
        QueryJobConfiguration.Builder builder = QueryJobConfiguration.newBuilder((String)translatedQuery).setUseLegacySql(Boolean.valueOf(false));
        this.setQueryParameters(queryParameters, builder);
        QueryJobConfiguration queryJobConfiguration = builder.build();
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Sending query to bigquery standard sql: {}", (Object)translatedQuery);
            }
            Job job = ObjectHelper.isNotEmpty((Object)jobId) ? this.bigquery.getJob(jobId, new BigQuery.JobOption[0]) : this.bigquery.create(this.getJobInfo(queryJobConfiguration), new BigQuery.JobOption[0]);
            return job.waitFor(new RetryOption[0]);
        }
        catch (BigQueryException e) {
            throw new Exception("Query " + translatedQuery + " failed: " + String.valueOf(e.getError()), e);
        }
    }

    private JobInfo getJobInfo(QueryJobConfiguration queryJobConfiguration) {
        return JobInfo.of((JobId)JobId.newBuilder().setRandomJob().setProject(this.configuration.getProjectId()).build(), (JobConfiguration)queryJobConfiguration);
    }

    private TableResult getTableResult(Job job, long pageSize, String pageToken) throws Exception {
        String translatedQuery = ((QueryJobConfiguration)job.getConfiguration()).getQuery();
        try {
            BigQuery.QueryResultsOption[] queryResultsOptions = GoogleBigQuerySQLProducer.getQueryResultsOptions(pageSize, pageToken);
            return job.getQueryResults(queryResultsOptions);
        }
        catch (BigQueryException e) {
            throw new Exception("Query " + translatedQuery + " failed: " + String.valueOf(e.getError()), e);
        }
    }

    private static BigQuery.QueryResultsOption[] getQueryResultsOptions(long pageSize, String pageToken) {
        ArrayList<BigQuery.QueryResultsOption> options = new ArrayList<BigQuery.QueryResultsOption>();
        if (pageSize > 0L) {
            options.add(BigQuery.QueryResultsOption.pageSize((long)pageSize));
        }
        if (pageToken != null) {
            options.add(BigQuery.QueryResultsOption.pageToken((String)pageToken));
        }
        return options.toArray(new BigQuery.QueryResultsOption[0]);
    }

    private static boolean isSelectQueryJob(Job job) {
        JobStatistics.QueryStatistics statistics = (JobStatistics.QueryStatistics)job.getStatistics();
        return statistics.getStatementType().equals((Object)JobStatistics.QueryStatistics.StatementType.SELECT);
    }

    private Map<String, Object> extractParameters(Exchange exchange) {
        if (this.queryParameterNames == null || this.queryParameterNames.isEmpty()) {
            return null;
        }
        Message message = exchange.getMessage();
        HashMap headers = new HashMap(message.getHeaders());
        if (message.getBody() instanceof Map) {
            try {
                headers.putAll((Map)message.getBody(Map.class));
            }
            catch (ClassCastException e) {
                LOG.warn("Unable to perform cast while extracting header parameters: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>(this.queryParameterNames.size());
        this.queryParameterNames.forEach(s -> {
            Object value = headers.get(s);
            if (value == null) {
                throw new RuntimeExchangeException("SQL parameter with name '" + s + "' not found in the message headers", exchange);
            }
            result.put((String)s, headers.get(s));
        });
        return result;
    }

    private void setQueryParameters(Map<String, Object> params, QueryJobConfiguration.Builder builder) {
        if (params == null) {
            return;
        }
        params.forEach((key, value) -> {
            QueryParameterValue parameterValue;
            try {
                parameterValue = QueryParameterValue.of((Object)value, value.getClass());
            }
            catch (IllegalArgumentException e) {
                LOG.warn("{} Fallback to *.toString() value.", (Object)e.getMessage());
                parameterValue = QueryParameterValue.of((Object)value.toString(), (StandardSQLTypeName)StandardSQLTypeName.STRING);
            }
            builder.addNamedParameter(key, parameterValue);
        });
    }

    private List<Map<String, Object>> processSelectResult(TableResult result, Schema schema) {
        FieldValueListMapper mapper = new FieldValueListMapper(schema.getFields());
        return StreamSupport.stream(result.getValues().spliterator(), false).map(mapper::map).toList();
    }

    public GoogleBigQuerySQLEndpoint getEndpoint() {
        return (GoogleBigQuerySQLEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        super.doStart();
        String placeholder = ":#";
        this.query = SqlHelper.resolveQuery(this.getEndpoint().getCamelContext(), this.configuration.getQueryString(), placeholder);
        this.queryParameterNames = SqlHelper.extractParameterNames(this.query);
    }
}

