/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.git.consumer;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.git.GitEndpoint;
import org.apache.camel.component.git.consumer.AbstractGitConsumer;
import org.apache.camel.util.ObjectHelper;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.revwalk.RevCommit;

public class GitCommitConsumer
extends AbstractGitConsumer {
    private final List<ObjectId> commitsConsumed = new ArrayList<ObjectId>();

    public GitCommitConsumer(GitEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
    }

    public GitEndpoint getEndpoint() {
        return (GitEndpoint)super.getEndpoint();
    }

    protected int poll() throws Exception {
        ArrayDeque<Object> exchanges = new ArrayDeque<Object>();
        String branch = this.getEndpoint().getBranchName();
        ObjectId id = null;
        if (ObjectHelper.isNotEmpty((String)branch)) {
            id = this.getGit().getRepository().resolve(branch);
        }
        Iterable commits = id != null ? this.getGit().log().add((AnyObjectId)id).call() : this.getGit().log().all().call();
        for (RevCommit commit : commits) {
            if (this.commitsConsumed.contains(commit.getId())) continue;
            Exchange e = this.createExchange(true);
            e.getMessage().setBody((Object)commit.getFullMessage());
            e.getMessage().setHeader("CamelGitCommitId", (Object)commit.getId());
            e.getMessage().setHeader("CamelGitAuthorName", (Object)commit.getAuthorIdent().getName());
            e.getMessage().setHeader("CamelGitCommiterName", (Object)commit.getCommitterIdent().getName());
            e.getMessage().setHeader("CamelGitCommitTime", (Object)commit.getCommitTime());
            exchanges.add(e);
        }
        return this.processBatch(exchanges);
    }

    @Override
    public Object onPreProcessed(Exchange exchange) {
        return exchange.getMessage().getHeader("CamelGitCommitId");
    }

    @Override
    public void onProcessed(Exchange exchange, Object value) {
        if (value instanceof ObjectId) {
            ObjectId oid = (ObjectId)value;
            this.commitsConsumed.add(oid);
        }
    }
}

