/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.example.cdi.kubernetes;

import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.client.KubernetesClientException;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Named;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.cdi.ContextName;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.model.OnExceptionDefinition;

public class Application {
    static String formatDuration(Duration duration) {
        if (Duration.ofDays(1L).compareTo(duration) < 0) {
            return duration.toDays() + "d";
        }
        if (Duration.ofHours(1L).compareTo(duration) < 0) {
            return duration.toHours() + "h";
        }
        if (Duration.ofMinutes(1L).compareTo(duration) < 0) {
            return duration.toMinutes() + "m";
        }
        return duration.getSeconds() + "s";
    }

    @Produces
    @ApplicationScoped
    @Named(value="properties")
    PropertiesComponent properties() {
        PropertiesComponent component = new PropertiesComponent();
        component.setLocation("classpath:application.properties");
        return component;
    }

    @ContextName(value="camel-example-kubernetes-cdi")
    static class KubernetesRoute
    extends RouteBuilder {
        KubernetesRoute() {
        }

        public void configure() {
            ((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)this.from("timer:client?period=10s").routeId("kubernetes-client").onException(KubernetesClientException.class).handled(true).log(LoggingLevel.ERROR, "${exception.message}")).log("Stopping the Kubernetes route...")).to("controlbus:route?routeId=kubernetes-client&action=stop&async=true&loggingLevel=DEBUG")).end().to("kubernetes://{{kubernetes-master-url:{{env:KUBERNETES_MASTER}}}}?oauthToken={{kubernetes-oauth-token:}}&category=pods&operation=listPods").log("We currently have ${body.size()} pods:").process(exchange -> {
                List pods = (List)exchange.getIn().getBody(List.class);
                String tty = "%-" + (pods.stream().mapToInt(pod -> pod.getMetadata().getName().length()).max().orElse(30) + 2) + "s %-9s %-9s %-10s %s";
                System.out.println(String.format(tty, "NAME", "READY", "STATUS", "RESTARTS", "AGE"));
                pods.stream().map(pod -> String.format(tty, pod.getMetadata().getName(), pod.getStatus().getContainerStatuses().stream().filter(ContainerStatus::getReady).count() + "/" + pod.getStatus().getContainerStatuses().size(), pod.getStatus().getPhase(), pod.getStatus().getContainerStatuses().stream().mapToInt(ContainerStatus::getRestartCount).sum(), Application.formatDuration(Duration.between(ZonedDateTime.parse(pod.getStatus().getStartTime()), ZonedDateTime.now())))).forEach(System.out::println);
            });
        }
    }
}

