/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.drill;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.drill.DrillEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrillProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(DrillProducer.class);
    private DrillEndpoint endpoint;
    private Connection connection;

    public DrillProducer(DrillEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.createJDBCConnection();
    }

    protected void doStop() throws Exception {
        super.doStop();
        try {
            this.connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Exchange exchange) throws Exception {
        String query = (String)exchange.getIn().getHeader("CamelDrillQuery", String.class);
        Statement st = null;
        ResultSet rs = null;
        try {
            st = this.connection.createStatement();
            rs = st.executeQuery(query);
            exchange.getIn().setBody(this.endpoint.queryForList(rs));
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception exception) {}
            try {
                st.close();
            }
            catch (Exception exception) {}
        }
    }

    private void createJDBCConnection() throws ClassNotFoundException, SQLException {
        Class.forName("org.apache.drill.jdbc.Driver");
        if (LOG.isInfoEnabled()) {
            LOG.info("connection url: {}", (Object)this.endpoint.toJDBCUri());
        }
        this.connection = DriverManager.getConnection(this.endpoint.toJDBCUri());
    }
}

