/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dhis2.api;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.hisp.dhis.integration.sdk.api.Dhis2Client;
import org.hisp.dhis.integration.sdk.api.Dhis2Response;
import org.hisp.dhis.integration.sdk.api.operation.PostOperation;

public class Dhis2Post {
    private final Dhis2Client dhis2Client;

    public Dhis2Post(Dhis2Client dhis2Client) {
        this.dhis2Client = dhis2Client;
    }

    public InputStream resource(String path, Object resource, Map<String, Object> queryParams) {
        PostOperation postOperation = this.dhis2Client.post(path, new String[0]);
        if (queryParams != null) {
            for (Map.Entry<String, Object> queryParam : queryParams.entrySet()) {
                if (queryParam.getValue() instanceof List) {
                    for (String queryValue : (List)queryParam.getValue()) {
                        postOperation.withParameter(queryParam.getKey(), queryValue);
                    }
                    continue;
                }
                postOperation.withParameter(queryParam.getKey(), (String)queryParam.getValue());
            }
        }
        if (resource != null) {
            postOperation.withResource(resource);
        }
        return ((Dhis2Response)postOperation.transfer()).read();
    }
}

