/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.csv;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.dataformat.csv.CsvRecordConverter;
import org.apache.commons.csv.CSVRecord;

final class CsvRecordConverters {
    private CsvRecordConverters() {
    }

    public static CsvRecordConverter<List<String>> listConverter() {
        return ListCsvRecordConverter.SINGLETON;
    }

    public static CsvRecordConverter<Map<String, String>> mapConverter() {
        return MapCsvRecordConverter.SINGLETON;
    }

    public static CsvRecordConverter<Map<String, String>> orderedMapConverter() {
        return OrderedMapCsvRecordConverter.SINGLETON;
    }

    private static class OrderedMapCsvRecordConverter
    implements CsvRecordConverter<Map<String, String>> {
        private static final OrderedMapCsvRecordConverter SINGLETON = new OrderedMapCsvRecordConverter();

        private OrderedMapCsvRecordConverter() {
        }

        @Override
        public Map<String, String> convertRecord(CSVRecord record) {
            LinkedHashMap<String, String> answer = new LinkedHashMap<String, String>();
            try {
                Field field = record.getClass().getDeclaredField("mapping");
                field.setAccessible(true);
                Map mapping = (Map)field.get(record);
                if (mapping != null) {
                    Iterator iterator = mapping.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry o;
                        Map.Entry entry = o = iterator.next();
                        int col = (Integer)entry.getValue();
                        answer.put((String)entry.getKey(), record.get(col));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return answer;
        }
    }

    private static class MapCsvRecordConverter
    implements CsvRecordConverter<Map<String, String>> {
        private static final MapCsvRecordConverter SINGLETON = new MapCsvRecordConverter();

        private MapCsvRecordConverter() {
        }

        @Override
        public Map<String, String> convertRecord(CSVRecord record) {
            return record.toMap();
        }
    }

    private static final class ListCsvRecordConverter
    implements CsvRecordConverter<List<String>> {
        private static final ListCsvRecordConverter SINGLETON = new ListCsvRecordConverter();

        private ListCsvRecordConverter() {
        }

        @Override
        public List<String> convertRecord(CSVRecord record) {
            ArrayList<String> answer = new ArrayList<String>(record.size());
            for (int i = 0; i < record.size(); ++i) {
                answer.add(record.get(i));
            }
            return answer;
        }
    }
}

