/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.csv;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.dataformat.csv.CsvDataFormat;
import org.apache.camel.dataformat.csv.CsvRecordConverter;
import org.apache.camel.dataformat.csv.CsvRecordConverters;
import org.apache.camel.dataformat.csv.CsvUnmarshalOnCompletion;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.util.IOHelper;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

abstract class CsvUnmarshaller {
    protected final CSVFormat format;
    protected final CsvRecordConverter<?> converter;

    private CsvUnmarshaller(CSVFormat format, CsvDataFormat dataFormat) {
        this.format = format;
        this.converter = CsvUnmarshaller.extractConverter(dataFormat);
    }

    public static CsvUnmarshaller create(CSVFormat format, CsvDataFormat dataFormat) {
        if ((dataFormat.isUseMaps() || dataFormat.isUseOrderedMaps()) && format.getHeader() == null) {
            format = format.withHeader(new String[0]);
        }
        if (format.getSkipHeaderRecord() && format.getHeader() == null) {
            format = format.withHeader(new String[0]);
        }
        if (dataFormat.isLazyLoad()) {
            return new StreamCsvUnmarshaller(format, dataFormat);
        }
        return new BulkCsvUnmarshaller(format, dataFormat);
    }

    public abstract Object unmarshal(Exchange var1, InputStream var2) throws IOException;

    private static CsvRecordConverter<?> extractConverter(CsvDataFormat dataFormat) {
        if (dataFormat.getRecordConverter() != null) {
            return dataFormat.getRecordConverter();
        }
        if (dataFormat.isUseOrderedMaps()) {
            return CsvRecordConverters.orderedMapConverter();
        }
        if (dataFormat.isUseMaps()) {
            return CsvRecordConverters.mapConverter();
        }
        return CsvRecordConverters.listConverter();
    }

    private static final class CsvIterator<T>
    implements Iterator<T>,
    Closeable {
        private final CSVParser parser;
        private final Iterator<CSVRecord> iterator;
        private final CsvRecordConverter<T> converter;

        private CsvIterator(CSVParser parser, CsvRecordConverter<T> converter) {
            this.parser = parser;
            this.iterator = parser.iterator();
            this.converter = converter;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public T next() {
            return this.converter.convertRecord(this.iterator.next());
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }

        @Override
        public void close() throws IOException {
            if (!this.parser.isClosed()) {
                this.parser.close();
            }
        }
    }

    private static final class StreamCsvUnmarshaller
    extends CsvUnmarshaller {
        private StreamCsvUnmarshaller(CSVFormat format, CsvDataFormat dataFormat) {
            super(format, dataFormat);
        }

        @Override
        public Object unmarshal(Exchange exchange, InputStream inputStream) throws IOException {
            InputStreamReader reader = null;
            try {
                reader = new InputStreamReader(inputStream, IOHelper.getCharsetName((Exchange)exchange));
                CSVParser parser = new CSVParser((Reader)reader, this.format);
                CsvIterator answer = new CsvIterator(parser, this.converter);
                exchange.addOnCompletion((Synchronization)new CsvUnmarshalOnCompletion(answer));
                return answer;
            }
            catch (Exception e) {
                IOHelper.close(reader);
                throw e;
            }
        }
    }

    private static final class BulkCsvUnmarshaller
    extends CsvUnmarshaller {
        private BulkCsvUnmarshaller(CSVFormat format, CsvDataFormat dataFormat) {
            super(format, dataFormat);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object unmarshal(Exchange exchange, InputStream inputStream) throws IOException {
            CSVParser parser = new CSVParser((Reader)new InputStreamReader(inputStream, IOHelper.getCharsetName((Exchange)exchange)), this.format);
            try {
                List list = this.asList(parser.iterator(), this.converter);
                return list;
            }
            finally {
                IOHelper.close((Closeable)parser);
            }
        }

        private <T> List<T> asList(Iterator<CSVRecord> iterator, CsvRecordConverter<T> converter) {
            ArrayList<T> answer = new ArrayList<T>();
            while (iterator.hasNext()) {
                answer.add(converter.convertRecord(iterator.next()));
            }
            return answer;
        }
    }
}

