/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.console;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.spi.BrowsableEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;

@DevConsole(name="browse", description="Browse pending messages on Camel components")
public class BrowseDevConsole
extends AbstractDevConsole {
    public static final String FILTER = "filter";
    public static final String LIMIT = "limit";
    public static final String TAIL = "tail";
    public static final String DUMP = "dump";
    public static final String INCLUDE_BODY = "includeBody";
    public static final String FRESH_SIZE = "freshSize";
    public static final String BODY_MAX_CHARS = "bodyMaxChars";
    @Metadata(defaultValue="32768", description="Maximum size of the message body to include in the dump")
    private int bodyMaxChars = 32768;
    @Metadata(defaultValue="100", description="Maximum number of messages per endpoint to include in the dump")
    private int limit = 100;

    public BrowseDevConsole() {
        super("camel", "browse", "Browse", "Browse pending messages on Camel components");
    }

    public int getBodyMaxChars() {
        return this.bodyMaxChars;
    }

    public void setBodyMaxChars(int bodyMaxChars) {
        this.bodyMaxChars = bodyMaxChars;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    protected String doCallText(Map<String, Object> options) {
        StringBuilder sb = new StringBuilder();
        String filter = (String)options.get(FILTER);
        String lim = (String)options.get(LIMIT);
        String tail = (String)options.get(TAIL);
        int pos = tail == null ? 0 : Integer.parseInt(tail);
        int max = lim == null ? this.limit : Integer.parseInt(lim);
        boolean freshSize = "true".equals(options.getOrDefault(FRESH_SIZE, "false"));
        boolean dump = "true".equals(options.getOrDefault(DUMP, "true"));
        boolean includeBody = "true".equals(options.getOrDefault(INCLUDE_BODY, "true"));
        int maxChars = Integer.parseInt((String)options.getOrDefault(BODY_MAX_CHARS, "" + this.bodyMaxChars));
        TreeSet<Endpoint> endpoints = new TreeSet<Endpoint>(Comparator.comparing(Endpoint::getEndpointUri));
        endpoints.addAll(this.getCamelContext().getEndpoints());
        for (Endpoint endpoint : endpoints) {
            if (!(endpoint instanceof BrowsableEndpoint)) continue;
            BrowsableEndpoint be = (BrowsableEndpoint)endpoint;
            if (filter != null && !PatternHelper.matchPattern((String)endpoint.getEndpointUri(), (String)filter)) continue;
            if (dump) {
                List list = freshSize ? be.getExchanges(Integer.MAX_VALUE, null) : be.getExchanges(max, null);
                int queueSize = list != null ? list.size() : 0;
                int begin = 0;
                if (list != null && pos > 0) {
                    begin = Math.max(0, list.size() - pos);
                    list = list.subList(begin, list.size());
                }
                if (list == null) continue;
                sb.append("\n");
                sb.append(String.format("Browse: %s (size: %d limit: %d position: %d)%n", endpoint.getEndpointUri(), queueSize, max, begin));
                for (Exchange e : list) {
                    String json = MessageHelper.dumpAsJSon((Message)e.getMessage(), (boolean)false, (boolean)false, (boolean)includeBody, (int)2, (boolean)true, (boolean)true, (boolean)true, (int)maxChars, (boolean)true);
                    sb.append(json);
                    sb.append("\n");
                }
                continue;
            }
            BrowsableEndpoint.BrowseStatus status = be.getBrowseStatus(Integer.MAX_VALUE);
            sb.append(String.format("Browse: %s (size: %d%n", endpoint.getEndpointUri(), status.size()));
        }
        sb.append("\n");
        return sb.toString();
    }

    protected JsonObject doCallJson(Map<String, Object> options) {
        JsonObject root = new JsonObject();
        JsonArray arr = new JsonArray();
        String filter = (String)options.get(FILTER);
        String lim = (String)options.get(LIMIT);
        String tail = (String)options.get(TAIL);
        int pos = tail == null ? 0 : Integer.parseInt(tail);
        int max = lim == null ? this.limit : Integer.parseInt(lim);
        boolean freshSize = "true".equals(options.getOrDefault(FRESH_SIZE, "false"));
        boolean dump = "true".equals(options.getOrDefault(DUMP, "true"));
        boolean includeBody = "true".equals(options.getOrDefault(INCLUDE_BODY, "true"));
        int maxChars = Integer.parseInt((String)options.getOrDefault(BODY_MAX_CHARS, "" + this.bodyMaxChars));
        TreeSet<Endpoint> endpoints = new TreeSet<Endpoint>(Comparator.comparing(Endpoint::getEndpointUri));
        endpoints.addAll(this.getCamelContext().getEndpoints());
        for (Endpoint endpoint : endpoints) {
            if (!(endpoint instanceof BrowsableEndpoint)) continue;
            BrowsableEndpoint be = (BrowsableEndpoint)endpoint;
            if (filter != null && !PatternHelper.matchPattern((String)endpoint.getEndpointUri(), (String)filter)) continue;
            if (dump) {
                List list = freshSize ? be.getExchanges(Integer.MAX_VALUE, null) : be.getExchanges(max, null);
                int queueSize = list != null ? list.size() : 0;
                int begin = 0;
                if (list != null && pos > 0) {
                    begin = Math.max(0, list.size() - pos);
                    list = list.subList(begin, list.size());
                }
                if (list == null) continue;
                JsonObject jo = new JsonObject();
                jo.put((Object)"endpointUri", (Object)endpoint.getEndpointUri());
                jo.put((Object)"queueSize", (Object)queueSize);
                jo.put((Object)LIMIT, (Object)max);
                jo.put((Object)"position", (Object)begin);
                if (!list.isEmpty()) {
                    long ts = (Long)((Exchange)list.get(0)).getMessage().getHeader("CamelMessageTimestamp", (Object)0L, Long.TYPE);
                    if (ts > 0L) {
                        jo.put((Object)"firstTimestamp", (Object)ts);
                    }
                    if (list.size() > 1 && (ts = ((Long)((Exchange)list.get(list.size() - 1)).getMessage().getHeader("CamelMessageTimestamp", (Object)0L, Long.TYPE)).longValue()) > 0L) {
                        jo.put((Object)"lastTimestamp", (Object)ts);
                    }
                }
                arr.add((Object)jo);
                JsonArray arr2 = new JsonArray();
                for (Exchange e : list) {
                    arr2.add((Object)MessageHelper.dumpAsJSonObject((Message)e.getMessage(), (boolean)false, (boolean)false, (boolean)includeBody, (boolean)true, (boolean)true, (boolean)true, (int)maxChars));
                }
                if (arr2.isEmpty()) continue;
                jo.put((Object)"messages", (Object)arr2);
                continue;
            }
            BrowsableEndpoint.BrowseStatus status = be.getBrowseStatus(Integer.MAX_VALUE);
            JsonObject jo = new JsonObject();
            jo.put((Object)"endpointUri", (Object)endpoint.getEndpointUri());
            jo.put((Object)"queueSize", (Object)status.size());
            if (status.firstTimestamp() > 0L) {
                jo.put((Object)"firstTimestamp", (Object)status.firstTimestamp());
            }
            if (status.lastTimestamp() > 0L) {
                jo.put((Object)"lastTimestamp", (Object)status.lastTimestamp());
            }
            arr.add((Object)jo);
        }
        if (!arr.isEmpty()) {
            root.put((Object)"browse", (Object)arr);
        }
        return root;
    }
}

