/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.console;

import java.util.Map;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.json.JsonObject;

@DevConsole(name="type-converters", description="Camel Type Converter information")
public class TypeConverterConsole
extends AbstractDevConsole {
    public TypeConverterConsole() {
        super("camel", "type-converters", "Type Converters", "Camel Type Converter information");
    }

    protected String doCallText(Map<String, Object> options) {
        StringBuilder sb = new StringBuilder();
        TypeConverterRegistry reg = this.getCamelContext().getTypeConverterRegistry();
        sb.append(String.format("\n    Converters: %s", reg.size()));
        sb.append(String.format("\n    Exists: %s", reg.getTypeConverterExists().name()));
        sb.append(String.format("\n    Exists LoggingLevel: %s", reg.getTypeConverterExistsLoggingLevel()));
        TypeConverterRegistry.Statistics statistics = reg.getStatistics();
        statistics.computeIfEnabled(() -> ((TypeConverterRegistry.Statistics)statistics).getAttemptCounter(), v -> sb.append(String.format("\n    Attempts: %s", v)));
        statistics.computeIfEnabled(() -> ((TypeConverterRegistry.Statistics)statistics).getHitCounter(), v -> sb.append(String.format("\n    Hit: %s", v)));
        statistics.computeIfEnabled(() -> ((TypeConverterRegistry.Statistics)statistics).getMissCounter(), v -> sb.append(String.format("\n    Miss: %s", v)));
        statistics.computeIfEnabled(() -> ((TypeConverterRegistry.Statistics)statistics).getFailedCounter(), v -> sb.append(String.format("\n    Failed: %s", v)));
        statistics.computeIfEnabled(() -> ((TypeConverterRegistry.Statistics)statistics).getNoopCounter(), v -> sb.append(String.format("\n    Noop: %s", v)));
        return sb.toString();
    }

    protected JsonObject doCallJson(Map<String, Object> options) {
        JsonObject root = new JsonObject();
        TypeConverterRegistry reg = this.getCamelContext().getTypeConverterRegistry();
        root.put((Object)"size", (Object)reg.size());
        root.put((Object)"exists", (Object)reg.getTypeConverterExists().name());
        root.put((Object)"existsLoggingLevel", (Object)reg.getTypeConverterExistsLoggingLevel().name());
        TypeConverterRegistry.Statistics statistics = reg.getStatistics();
        JsonObject props = new JsonObject();
        statistics.computeIfEnabled(() -> ((TypeConverterRegistry.Statistics)statistics).getAttemptCounter(), v -> props.put((Object)"attemptCounter", (Object)v));
        statistics.computeIfEnabled(() -> ((TypeConverterRegistry.Statistics)statistics).getHitCounter(), v -> props.put((Object)"hitCounter", (Object)v));
        statistics.computeIfEnabled(() -> ((TypeConverterRegistry.Statistics)statistics).getMissCounter(), v -> props.put((Object)"missCounter", (Object)v));
        statistics.computeIfEnabled(() -> ((TypeConverterRegistry.Statistics)statistics).getFailedCounter(), v -> props.put((Object)"failedCounter", (Object)v));
        statistics.computeIfEnabled(() -> ((TypeConverterRegistry.Statistics)statistics).getFailedCounter(), v -> props.put((Object)"noopCounter", (Object)v));
        if (!props.isEmpty()) {
            root.put((Object)"statistics", (Object)props);
        }
        return root;
    }
}

