/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import java.time.Duration;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.qdrant.QdrantComponent;
import org.apache.camel.component.qdrant.QdrantConfiguration;

public interface QdrantComponentBuilderFactory {
    public static QdrantComponentBuilder qdrant() {
        return new QdrantComponentBuilderImpl();
    }

    public static class QdrantComponentBuilderImpl
    extends AbstractComponentBuilder<QdrantComponent>
    implements QdrantComponentBuilder {
        @Override
        protected QdrantComponent buildConcreteComponent() {
            return new QdrantComponent();
        }

        private QdrantConfiguration getOrCreateConfiguration(QdrantComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new QdrantConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "apiKey": {
                    this.getOrCreateConfiguration((QdrantComponent)component).setApiKey((String)value);
                    return true;
                }
                case "configuration": {
                    ((QdrantComponent)component).setConfiguration((QdrantConfiguration)value);
                    return true;
                }
                case "host": {
                    this.getOrCreateConfiguration((QdrantComponent)component).setHost((String)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((QdrantComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "port": {
                    this.getOrCreateConfiguration((QdrantComponent)component).setPort(((Integer)value).intValue());
                    return true;
                }
                case "timeout": {
                    this.getOrCreateConfiguration((QdrantComponent)component).setTimeout((Duration)value);
                    return true;
                }
                case "tls": {
                    this.getOrCreateConfiguration((QdrantComponent)component).setTls(((Boolean)value).booleanValue());
                    return true;
                }
                case "autowiredEnabled": {
                    ((QdrantComponent)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
            }
            return false;
        }
    }

    public static interface QdrantComponentBuilder
    extends ComponentBuilder<QdrantComponent> {
        default public QdrantComponentBuilder apiKey(String apiKey) {
            this.doSetProperty("apiKey", apiKey);
            return this;
        }

        default public QdrantComponentBuilder configuration(QdrantConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public QdrantComponentBuilder host(String host) {
            this.doSetProperty("host", host);
            return this;
        }

        default public QdrantComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public QdrantComponentBuilder port(int port) {
            this.doSetProperty("port", port);
            return this;
        }

        default public QdrantComponentBuilder timeout(Duration timeout) {
            this.doSetProperty("timeout", timeout);
            return this;
        }

        default public QdrantComponentBuilder tls(boolean tls) {
            this.doSetProperty("tls", tls);
            return this;
        }

        default public QdrantComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }
    }
}

