/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import com.azure.core.amqp.AmqpRetryOptions;
import com.azure.core.amqp.AmqpTransportType;
import com.azure.core.credential.TokenCredential;
import com.azure.messaging.eventhubs.CheckpointStore;
import com.azure.messaging.eventhubs.EventHubProducerAsyncClient;
import com.azure.messaging.eventhubs.models.EventPosition;
import com.azure.storage.common.StorageSharedKeyCredential;
import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.azure.eventhubs.CredentialType;
import org.apache.camel.component.azure.eventhubs.EventHubsComponent;
import org.apache.camel.component.azure.eventhubs.EventHubsConfiguration;

public interface AzureEventhubsComponentBuilderFactory {
    public static AzureEventhubsComponentBuilder azureEventhubs() {
        return new AzureEventhubsComponentBuilderImpl();
    }

    public static class AzureEventhubsComponentBuilderImpl
    extends AbstractComponentBuilder<EventHubsComponent>
    implements AzureEventhubsComponentBuilder {
        @Override
        protected EventHubsComponent buildConcreteComponent() {
            return new EventHubsComponent();
        }

        private EventHubsConfiguration getOrCreateConfiguration(EventHubsComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new EventHubsConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "amqpRetryOptions": {
                    this.getOrCreateConfiguration((EventHubsComponent)component).setAmqpRetryOptions((AmqpRetryOptions)value);
                    return true;
                }
                case "amqpTransportType": {
                    this.getOrCreateConfiguration((EventHubsComponent)component).setAmqpTransportType((AmqpTransportType)value);
                    return true;
                }
                case "configuration": {
                    ((EventHubsComponent)component).setConfiguration((EventHubsConfiguration)value);
                    return true;
                }
                case "blobAccessKey": {
                    this.getOrCreateConfiguration((EventHubsComponent)component).setBlobAccessKey((String)value);
                    return true;
                }
                case "blobAccountName": {
                    this.getOrCreateConfiguration((EventHubsComponent)component).setBlobAccountName((String)value);
                    return true;
                }
                case "blobContainerName": {
                    this.getOrCreateConfiguration((EventHubsComponent)component).setBlobContainerName((String)value);
                    return true;
                }
                case "blobStorageSharedKeyCredential": {
                    this.getOrCreateConfiguration((EventHubsComponent)component).setBlobStorageSharedKeyCredential((StorageSharedKeyCredential)value);
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((EventHubsComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "checkpointBatchSize": {
                    this.getOrCreateConfiguration((EventHubsComponent)component).setCheckpointBatchSize(((Integer)value).intValue());
                    return true;
                }
                case "checkpointBatchTimeout": {
                    this.getOrCreateConfiguration((EventHubsComponent)component).setCheckpointBatchTimeout(((Integer)value).intValue());
                    return true;
                }
                case "checkpointStore": {
                    this.getOrCreateConfiguration((EventHubsComponent)component).setCheckpointStore((CheckpointStore)value);
                    return true;
                }
                case "consumerGroupName": {
                    this.getOrCreateConfiguration((EventHubsComponent)component).setConsumerGroupName((String)value);
                    return true;
                }
                case "eventPosition": {
                    this.getOrCreateConfiguration((EventHubsComponent)component).setEventPosition((Map)value);
                    return true;
                }
                case "prefetchCount": {
                    this.getOrCreateConfiguration((EventHubsComponent)component).setPrefetchCount(((Integer)value).intValue());
                    return true;
                }
                case "lazyStartProducer": {
                    ((EventHubsComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "partitionId": {
                    this.getOrCreateConfiguration((EventHubsComponent)component).setPartitionId((String)value);
                    return true;
                }
                case "partitionKey": {
                    this.getOrCreateConfiguration((EventHubsComponent)component).setPartitionKey((String)value);
                    return true;
                }
                case "producerAsyncClient": {
                    this.getOrCreateConfiguration((EventHubsComponent)component).setProducerAsyncClient((EventHubProducerAsyncClient)value);
                    return true;
                }
                case "autowiredEnabled": {
                    ((EventHubsComponent)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "connectionString": {
                    this.getOrCreateConfiguration((EventHubsComponent)component).setConnectionString((String)value);
                    return true;
                }
                case "credentialType": {
                    this.getOrCreateConfiguration((EventHubsComponent)component).setCredentialType((CredentialType)value);
                    return true;
                }
                case "sharedAccessKey": {
                    this.getOrCreateConfiguration((EventHubsComponent)component).setSharedAccessKey((String)value);
                    return true;
                }
                case "sharedAccessName": {
                    this.getOrCreateConfiguration((EventHubsComponent)component).setSharedAccessName((String)value);
                    return true;
                }
                case "tokenCredential": {
                    this.getOrCreateConfiguration((EventHubsComponent)component).setTokenCredential((TokenCredential)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface AzureEventhubsComponentBuilder
    extends ComponentBuilder<EventHubsComponent> {
        default public AzureEventhubsComponentBuilder amqpRetryOptions(AmqpRetryOptions amqpRetryOptions) {
            this.doSetProperty("amqpRetryOptions", amqpRetryOptions);
            return this;
        }

        default public AzureEventhubsComponentBuilder amqpTransportType(AmqpTransportType amqpTransportType) {
            this.doSetProperty("amqpTransportType", amqpTransportType);
            return this;
        }

        default public AzureEventhubsComponentBuilder configuration(EventHubsConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public AzureEventhubsComponentBuilder blobAccessKey(String blobAccessKey) {
            this.doSetProperty("blobAccessKey", blobAccessKey);
            return this;
        }

        default public AzureEventhubsComponentBuilder blobAccountName(String blobAccountName) {
            this.doSetProperty("blobAccountName", blobAccountName);
            return this;
        }

        default public AzureEventhubsComponentBuilder blobContainerName(String blobContainerName) {
            this.doSetProperty("blobContainerName", blobContainerName);
            return this;
        }

        default public AzureEventhubsComponentBuilder blobStorageSharedKeyCredential(StorageSharedKeyCredential blobStorageSharedKeyCredential) {
            this.doSetProperty("blobStorageSharedKeyCredential", blobStorageSharedKeyCredential);
            return this;
        }

        default public AzureEventhubsComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public AzureEventhubsComponentBuilder checkpointBatchSize(int checkpointBatchSize) {
            this.doSetProperty("checkpointBatchSize", checkpointBatchSize);
            return this;
        }

        default public AzureEventhubsComponentBuilder checkpointBatchTimeout(int checkpointBatchTimeout) {
            this.doSetProperty("checkpointBatchTimeout", checkpointBatchTimeout);
            return this;
        }

        default public AzureEventhubsComponentBuilder checkpointStore(CheckpointStore checkpointStore) {
            this.doSetProperty("checkpointStore", checkpointStore);
            return this;
        }

        default public AzureEventhubsComponentBuilder consumerGroupName(String consumerGroupName) {
            this.doSetProperty("consumerGroupName", consumerGroupName);
            return this;
        }

        default public AzureEventhubsComponentBuilder eventPosition(Map<String, EventPosition> eventPosition) {
            this.doSetProperty("eventPosition", eventPosition);
            return this;
        }

        default public AzureEventhubsComponentBuilder prefetchCount(int prefetchCount) {
            this.doSetProperty("prefetchCount", prefetchCount);
            return this;
        }

        default public AzureEventhubsComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public AzureEventhubsComponentBuilder partitionId(String partitionId) {
            this.doSetProperty("partitionId", partitionId);
            return this;
        }

        default public AzureEventhubsComponentBuilder partitionKey(String partitionKey) {
            this.doSetProperty("partitionKey", partitionKey);
            return this;
        }

        default public AzureEventhubsComponentBuilder producerAsyncClient(EventHubProducerAsyncClient producerAsyncClient) {
            this.doSetProperty("producerAsyncClient", producerAsyncClient);
            return this;
        }

        default public AzureEventhubsComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public AzureEventhubsComponentBuilder connectionString(String connectionString) {
            this.doSetProperty("connectionString", connectionString);
            return this;
        }

        default public AzureEventhubsComponentBuilder credentialType(CredentialType credentialType) {
            this.doSetProperty("credentialType", credentialType);
            return this;
        }

        default public AzureEventhubsComponentBuilder sharedAccessKey(String sharedAccessKey) {
            this.doSetProperty("sharedAccessKey", sharedAccessKey);
            return this;
        }

        default public AzureEventhubsComponentBuilder sharedAccessName(String sharedAccessName) {
            this.doSetProperty("sharedAccessName", sharedAccessName);
            return this;
        }

        default public AzureEventhubsComponentBuilder tokenCredential(TokenCredential tokenCredential) {
            this.doSetProperty("tokenCredential", tokenCredential);
            return this;
        }
    }
}

