/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.pinecone.PineconeVectorDbComponent;
import org.apache.camel.component.pinecone.PineconeVectorDbConfiguration;

public interface PineconeComponentBuilderFactory {
    public static PineconeComponentBuilder pinecone() {
        return new PineconeComponentBuilderImpl();
    }

    public static class PineconeComponentBuilderImpl
    extends AbstractComponentBuilder<PineconeVectorDbComponent>
    implements PineconeComponentBuilder {
        @Override
        protected PineconeVectorDbComponent buildConcreteComponent() {
            return new PineconeVectorDbComponent();
        }

        private PineconeVectorDbConfiguration getOrCreateConfiguration(PineconeVectorDbComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new PineconeVectorDbConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "configuration": {
                    ((PineconeVectorDbComponent)component).setConfiguration((PineconeVectorDbConfiguration)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((PineconeVectorDbComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "token": {
                    this.getOrCreateConfiguration((PineconeVectorDbComponent)component).setToken((String)value);
                    return true;
                }
                case "autowiredEnabled": {
                    ((PineconeVectorDbComponent)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
            }
            return false;
        }
    }

    public static interface PineconeComponentBuilder
    extends ComponentBuilder<PineconeVectorDbComponent> {
        default public PineconeComponentBuilder configuration(PineconeVectorDbConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public PineconeComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public PineconeComponentBuilder token(String token) {
            this.doSetProperty("token", token);
            return this;
        }

        default public PineconeComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }
    }
}

