/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.cli.connector;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.Route;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.api.management.ManagedCamelContext;
import org.apache.camel.builder.ModelRoutesBuilder;
import org.apache.camel.cli.connector.LoggerHelper;
import org.apache.camel.console.DevConsole;
import org.apache.camel.console.DevConsoleRegistry;
import org.apache.camel.model.HasExpressionType;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.spi.CliConnector;
import org.apache.camel.spi.CliConnectorFactory;
import org.apache.camel.spi.ContextReloadStrategy;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.ResourceLoader;
import org.apache.camel.spi.ResourceReloadStrategy;
import org.apache.camel.spi.RoutesLoader;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.concurrent.ThreadHelper;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;
import org.apache.camel.util.json.Jsoner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalCliConnector
extends ServiceSupport
implements CliConnector,
CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(LocalCliConnector.class);
    private static final int BODY_MAX_CHARS = 131072;
    private final CliConnectorFactory cliConnectorFactory;
    private CamelContext camelContext;
    private int delay = 1000;
    private long counter;
    private String platform;
    private String platformVersion;
    private String mainClass;
    private final AtomicBoolean terminating = new AtomicBoolean();
    private ScheduledExecutorService executor;
    private volatile ExecutorService terminateExecutor;
    private ProducerTemplate producer;
    private ConsumerTemplate consumer;
    private File lockFile;
    private File statusFile;
    private File actionFile;
    private File outputFile;
    private File traceFile;
    private long traceFilePos;
    private File debugFile;
    private File receiveFile;
    private long receiveFilePos;
    private byte[] lastSource;
    private ExpressionDefinition lastSourceExpression;

    public LocalCliConnector(CliConnectorFactory cliConnectorFactory) {
        this.cliConnectorFactory = cliConnectorFactory;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    protected void doStart() throws Exception {
        this.terminating.set(false);
        this.mainClass = this.cliConnectorFactory.getRuntimeStartClass();
        if (this.mainClass == null) {
            this.mainClass = this.camelContext.getGlobalOption("CamelMainClass");
        }
        this.platform = this.cliConnectorFactory.getRuntime();
        if (this.platform == null) {
            String sn = this.camelContext.getClass().getSimpleName().toLowerCase(Locale.ROOT);
            this.platform = sn.contains("boot") ? "Spring Boot" : (sn.contains("spring") ? "Spring" : (sn.contains("quarkus") ? "Quarkus" : (sn.contains("osgi") ? "Karaf" : (sn.contains("cdi") ? "CDI" : (this.camelContext.getName().equals("CamelJBang") ? "JBang" : "Camel")))));
        }
        this.platformVersion = this.cliConnectorFactory.getRuntimeVersion();
        this.producer = this.camelContext.createProducerTemplate();
        this.consumer = this.camelContext.createConsumerTemplate();
        this.executor = Executors.newSingleThreadScheduledExecutor(r -> {
            String threadName = ThreadHelper.resolveThreadName(null, (String)"LocalCliConnector");
            return new Thread(r, threadName);
        });
        this.lockFile = LocalCliConnector.createLockFile(LocalCliConnector.getPid());
        if (this.lockFile != null) {
            this.statusFile = LocalCliConnector.createLockFile(this.lockFile.getName() + "-status.json");
            this.actionFile = LocalCliConnector.createLockFile(this.lockFile.getName() + "-action.json");
            this.outputFile = LocalCliConnector.createLockFile(this.lockFile.getName() + "-output.json");
            this.traceFile = LocalCliConnector.createLockFile(this.lockFile.getName() + "-trace.json");
            this.debugFile = LocalCliConnector.createLockFile(this.lockFile.getName() + "-debug.json");
            this.receiveFile = LocalCliConnector.createLockFile(this.lockFile.getName() + "-receive.json");
            this.executor.scheduleWithFixedDelay(this::task, 0L, this.delay, TimeUnit.MILLISECONDS);
            LOG.info("Camel JBang CLI enabled");
        } else {
            LOG.warn("Cannot create PID file: {}. This integration cannot be managed by Camel JBang CLI.", (Object)LocalCliConnector.getPid());
        }
    }

    public void sigterm() {
        this.terminating.set(true);
        this.terminateExecutor = Executors.newSingleThreadExecutor(r -> {
            String threadName = ThreadHelper.resolveThreadName(null, (String)"Terminate JVM task");
            return new Thread(r, threadName);
        });
        this.terminateExecutor.submit(new Runnable(){

            @Override
            public void run() {
                LOG.info("Camel JBang terminating JVM");
                try {
                    LocalCliConnector.this.camelContext.stop();
                }
                finally {
                    ServiceHelper.stopAndShutdownService((Object)this);
                }
            }
        });
    }

    protected void task() {
        if (!this.lockFile.exists() && this.terminating.compareAndSet(false, true)) {
            this.sigterm();
            return;
        }
        if (!this.statusFile.exists()) {
            return;
        }
        this.actionTask();
        this.statusTask();
        if (++this.counter % 2L == 0L) {
            this.traceTask();
        }
    }

    protected void actionTask() {
        Object action = null;
        try {
            JsonObject root = this.loadAction();
            if (root == null || root.isEmpty()) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Action: {}", (Object)root);
            }
            if ("route".equals(action = root.getString("action"))) {
                this.doActionRouteTask(root);
            } else if ("logger".equals(action)) {
                this.doActionLoggerTask(root);
            } else if ("gc".equals(action)) {
                System.gc();
            } else if ("reload".equals(action)) {
                this.doActionReloadTask();
            } else if ("debug".equals(action)) {
                this.doActionDebugTask(root);
            } else if ("reset-stats".equals(action)) {
                this.doActionResetStatsTask();
            } else if ("thread-dump".equals(action)) {
                this.doActionThreadDumpTask();
            } else if ("top-processors".equals(action)) {
                this.doActionTopProcessorsTask();
            } else if ("source".equals(action)) {
                this.doActionSourceTask(root);
            } else if ("route-dump".equals(action)) {
                this.doActionRouteDumpTask(root);
            } else if ("route-controller".equals(action)) {
                this.doActionRouteControllerTask(root);
            } else if ("startup-recorder".equals(action)) {
                this.doActionStartupRecorder();
            } else if ("stub".equals(action)) {
                this.doActionStubTask(root);
            } else if ("send".equals(action)) {
                this.doActionSendTask(root);
            } else if ("transform".equals(action)) {
                this.doActionTransformTask(root);
            } else if ("bean".equals(action)) {
                this.doActionBeanTask(root);
            } else if ("kafka".equals(action)) {
                this.doActionKafkaTask();
            } else if ("trace".equals(action)) {
                this.doActionTraceTask(root);
            } else if ("browse".equals(action)) {
                this.doActionBrowseTask(root);
            } else if ("receive".equals(action)) {
                this.doActionReceiveTask(root);
            }
        }
        catch (Exception e) {
            LOG.warn("Error executing action: {} due to: {}. This exception is ignored.", new Object[]{action != null ? action : this.actionFile, e.getMessage(), e});
        }
        finally {
            FileUtil.deleteFile((File)this.actionFile);
        }
    }

    private void doActionTransformTask(JsonObject root) throws Exception {
        StopWatch watch = new StopWatch();
        long timestamp = System.currentTimeMillis();
        Object source = root.getString("source");
        String language = root.getString("language");
        String component = root.getString("component");
        String dataformat = root.getString("dataformat");
        Object template = Jsoner.unescape((String)root.getStringOrDefault("template", ""));
        if (component == null && ((String)template).startsWith("file:")) {
            template = "resource:" + (String)template;
        }
        String body = Jsoner.unescape((String)root.getString("body"));
        FileInputStream is = null;
        String b = body;
        if (body.startsWith("file:")) {
            File file = new File(body.substring(5));
            is = new FileInputStream(file);
            b = IOHelper.loadText((InputStream)is);
        }
        String inputBody = b;
        LinkedHashMap<String, String> map = null;
        Collection headers = root.getCollection("headers");
        if (headers != null) {
            map = new LinkedHashMap<String, String>();
            for (JsonObject jo : headers) {
                map.put(jo.getString("key"), jo.getString("value"));
            }
        }
        LinkedHashMap<String, String> inputHeaders = map;
        LinkedHashMap<String, String> map2 = null;
        Collection options = root.getCollection("options");
        if (options != null) {
            map2 = new LinkedHashMap<String, String>();
            for (JsonObject jo : options) {
                map2.put(jo.getString("key"), jo.getString("value"));
            }
        }
        LinkedHashMap<String, String> inputOptions = map2;
        Exchange out = this.camelContext.getCamelContextExtension().getExchangeFactory().create(false);
        try {
            if (source != null) {
                Integer sourceLine = LoggerHelper.extractSourceLocationLineNumber((String)source);
                String sourceId = LoggerHelper.extractSourceLocationId((String)source);
                source = LoggerHelper.stripSourceLocationLineNumber((String)source);
                LOG.debug("Source: {} line: {} id: {}", new Object[]{source, sourceLine, sourceId});
                boolean update = true;
                File f = new File((String)source);
                if (f.isFile() && f.exists()) {
                    byte[] data = Files.readAllBytes(f.toPath());
                    if (Arrays.equals(this.lastSource, data)) {
                        LOG.debug("Source file: {} is not updated since last", source);
                        update = false;
                    }
                    this.lastSource = data;
                }
                if (update) {
                    if (sourceLine != null) {
                        LOG.info("Transforming from source: {}:{}", source, (Object)sourceLine);
                    } else if (sourceId != null) {
                        LOG.info("Transforming from source: {}:{}", source, (Object)sourceId);
                    } else {
                        LOG.info("Transforming from source: {}", source);
                    }
                    if (!((String)source).startsWith("file:")) {
                        source = "file:" + (String)source;
                    }
                    Resource res = ((ResourceLoader)this.camelContext.getCamelContextExtension().getContextPlugin(ResourceLoader.class)).resolveResource((String)source);
                    RoutesLoader loader = (RoutesLoader)this.camelContext.getCamelContextExtension().getContextPlugin(RoutesLoader.class);
                    Collection builders = loader.findRoutesBuilders(new Resource[]{res});
                    for (RoutesBuilder builder : builders) {
                        ModelRoutesBuilder mrb = (ModelRoutesBuilder)builder;
                        mrb.prepareModel(this.camelContext);
                        ExpressionDefinition found = null;
                        for (RouteDefinition rd : mrb.getRoutes().getRoutes()) {
                            Collection defs = ProcessorDefinitionHelper.filterTypeInOutputs((List)rd.getOutputs(), ProcessorDefinition.class);
                            for (ProcessorDefinition p : defs) {
                                HasExpressionType et;
                                ExpressionDefinition def;
                                if (!(p instanceof HasExpressionType) || (def = (et = (HasExpressionType)p).getExpressionType()) == null) continue;
                                if (sourceLine != null) {
                                    if (p.getLineNumber() != -1 && p.getLineNumber() > sourceLine) continue;
                                    found = def;
                                    continue;
                                }
                                if (sourceId != null) {
                                    if (!sourceId.equals(p.getId()) && !sourceId.equals(def.getId())) continue;
                                    found = def;
                                    continue;
                                }
                                found = def;
                            }
                            if (found == null) continue;
                            this.lastSourceExpression = found;
                        }
                    }
                }
                if (this.lastSourceExpression != null) {
                    out.setPattern(ExchangePattern.InOut);
                    out.getMessage().setBody((Object)inputBody);
                    if (inputHeaders != null) {
                        out.getMessage().setHeaders(inputHeaders);
                    }
                    String result = (String)this.lastSourceExpression.evaluate(out, String.class);
                    out.getMessage().setBody((Object)result);
                }
            } else if (component != null) {
                out.setPattern(ExchangePattern.InOut);
                out.getMessage().setBody((Object)inputBody);
                if (inputHeaders != null) {
                    out.getMessage().setHeaders(inputHeaders);
                }
                uri = component + ":" + (String)template;
                EndpointUriFactory euf = this.camelContext.getCamelContextExtension().getEndpointUriFactory(component);
                if (euf.propertyNames().contains("contentCache")) {
                    uri = (String)uri + "?contentCache=false";
                }
                if (inputOptions != null) {
                    uri = URISupport.appendParametersToURI((String)uri, inputOptions);
                }
                out = this.producer.send((String)uri, out);
            } else if (dataformat != null) {
                out.setPattern(ExchangePattern.InOut);
                out.getMessage().setBody((Object)inputBody);
                if (inputHeaders != null) {
                    out.getMessage().setHeaders(inputHeaders);
                }
                uri = "dataformat:" + dataformat + ":unmarshal";
                if (inputOptions != null) {
                    uri = URISupport.appendParametersToURI((String)uri, inputOptions);
                }
                out = this.producer.send((String)uri, out);
            } else {
                Language lan = this.camelContext.resolveLanguage(language);
                Expression exp = lan.createExpression((String)template);
                if (inputOptions != null) {
                    PropertyBindingSupport.build().withCamelContext(this.camelContext).withTarget((Object)exp).withProperties(inputOptions).bind();
                }
                exp.init(this.camelContext);
                out.setPattern(ExchangePattern.InOut);
                out.getMessage().setBody((Object)inputBody);
                if (inputHeaders != null) {
                    out.getMessage().setHeaders(inputHeaders);
                }
                String result = (String)exp.evaluate(out, String.class);
                out.getMessage().setBody((Object)result);
            }
            IOHelper.close((Closeable)is);
        }
        catch (Exception e) {
            out.setException((Throwable)e);
        }
        LOG.trace("Updating output file: {}", (Object)this.outputFile);
        if (out.getException() != null) {
            jo = new JsonObject();
            if (language != null) {
                jo.put((Object)"language", (Object)language);
            }
            if (source != null) {
                jo.put((Object)"source", source);
            }
            jo.put((Object)"exchangeId", (Object)out.getExchangeId());
            jo.put((Object)"timestamp", (Object)timestamp);
            jo.put((Object)"elapsed", (Object)watch.taken());
            jo.put((Object)"status", (Object)"failed");
            jo.put((Object)"exception", (Object)MessageHelper.dumpExceptionAsJSonObject((Throwable)out.getException()).getMap("exception"));
            IOHelper.writeText((String)jo.toJson(), (File)this.outputFile);
        } else {
            jo = new JsonObject();
            if (language != null) {
                jo.put((Object)"language", (Object)language);
            }
            if (source != null) {
                jo.put((Object)"source", source);
            }
            jo.put((Object)"exchangeId", (Object)out.getExchangeId());
            jo.put((Object)"timestamp", (Object)timestamp);
            jo.put((Object)"elapsed", (Object)watch.taken());
            jo.put((Object)"status", (Object)"success");
            jo.put((Object)"message", (Object)MessageHelper.dumpAsJSonObject((Message)out.getMessage(), (boolean)true, (boolean)true, (boolean)true, (boolean)true, (boolean)true, (boolean)true, (int)131072).getMap("message"));
            IOHelper.writeText((String)jo.toJson(), (File)this.outputFile);
        }
        this.camelContext.getCamelContextExtension().getExchangeFactory().release(out);
    }

    private void doActionSendTask(JsonObject root) throws Exception {
        DevConsole dc = ((DevConsoleRegistry)this.camelContext.getCamelContextExtension().getContextPlugin(DevConsoleRegistry.class)).resolveById("send");
        if (dc != null) {
            Collection headers;
            StopWatch watch = new StopWatch();
            while (!this.camelContext.isStarted() && watch.taken() < 5000L) {
                Thread.sleep(100L);
            }
            String endpoint = root.getString("endpoint");
            String body = root.getString("body");
            String exchangePattern = root.getString("exchangePattern");
            String poll = root.getString("poll");
            String pollTimeout = root.getString("pollTimeout");
            LinkedHashMap<String, String> args = new LinkedHashMap<String, String>();
            if (endpoint != null) {
                args.put("endpoint", endpoint);
            }
            if (body != null) {
                args.put("body", body);
            }
            if (exchangePattern != null) {
                args.put("exchangePattern", exchangePattern);
            }
            if (poll != null) {
                args.put("poll", poll);
            }
            if (pollTimeout != null) {
                args.put("pollTimeout", pollTimeout);
            }
            if ((headers = root.getCollection("headers")) != null) {
                for (JsonObject jo : headers) {
                    args.put(jo.getString("key"), jo.getString("value"));
                }
            }
            JsonObject json = (JsonObject)dc.call(DevConsole.MediaType.JSON, args);
            LOG.trace("Updating output file: {}", (Object)this.outputFile);
            IOHelper.writeText((String)json.toJson(), (File)this.outputFile);
        } else {
            IOHelper.writeText((String)"{}", (File)this.outputFile);
        }
    }

    private void doActionStubTask(JsonObject root) throws Exception {
        String filter = root.getString("filter");
        String limit = root.getString("limit");
        String browse = root.getString("browse");
        DevConsole dc = ((DevConsoleRegistry)this.camelContext.getCamelContextExtension().getContextPlugin(DevConsoleRegistry.class)).resolveById("stub");
        if (dc != null) {
            JsonObject json = (JsonObject)dc.call(DevConsole.MediaType.JSON, Map.of("filter", filter, "limit", limit, "browse", browse));
            LOG.trace("Updating output file: {}", (Object)this.outputFile);
            IOHelper.writeText((String)json.toJson(), (File)this.outputFile);
        } else {
            IOHelper.writeText((String)"{}", (File)this.outputFile);
        }
    }

    private void doActionStartupRecorder() throws Exception {
        DevConsole dc = ((DevConsoleRegistry)this.camelContext.getCamelContextExtension().getContextPlugin(DevConsoleRegistry.class)).resolveById("startup-recorder");
        if (dc != null) {
            JsonObject json = (JsonObject)dc.call(DevConsole.MediaType.JSON);
            LOG.trace("Updating output file: {}", (Object)this.outputFile);
            IOHelper.writeText((String)json.toJson(), (File)this.outputFile);
        } else {
            IOHelper.writeText((String)"{}", (File)this.outputFile);
        }
    }

    private void doActionRouteControllerTask(JsonObject root) throws Exception {
        DevConsole dc = ((DevConsoleRegistry)this.camelContext.getCamelContextExtension().getContextPlugin(DevConsoleRegistry.class)).resolveById("route-controller");
        if (dc != null) {
            String stacktrace = root.getString("stacktrace");
            JsonObject json = (JsonObject)dc.call(DevConsole.MediaType.JSON, Map.of("stacktrace", stacktrace));
            LOG.trace("Updating output file: {}", (Object)this.outputFile);
            IOHelper.writeText((String)json.toJson(), (File)this.outputFile);
        } else {
            IOHelper.writeText((String)"{}", (File)this.outputFile);
        }
    }

    private void doActionRouteDumpTask(JsonObject root) throws Exception {
        DevConsole dc = ((DevConsoleRegistry)this.camelContext.getCamelContextExtension().getContextPlugin(DevConsoleRegistry.class)).resolveById("route-dump");
        if (dc != null) {
            String filter = root.getString("filter");
            String format = root.getString("format");
            String uriAsParameters = root.getString("uriAsParameters");
            JsonObject json = (JsonObject)dc.call(DevConsole.MediaType.JSON, Map.of("filter", filter, "format", format, "uriAsParameters", uriAsParameters));
            LOG.trace("Updating output file: {}", (Object)this.outputFile);
            IOHelper.writeText((String)json.toJson(), (File)this.outputFile);
        } else {
            IOHelper.writeText((String)"{}", (File)this.outputFile);
        }
    }

    private void doActionSourceTask(JsonObject root) throws Exception {
        DevConsole dc = ((DevConsoleRegistry)this.camelContext.getCamelContextExtension().getContextPlugin(DevConsoleRegistry.class)).resolveById("source");
        if (dc != null) {
            String filter = root.getString("filter");
            JsonObject json = (JsonObject)dc.call(DevConsole.MediaType.JSON, Map.of("filter", filter));
            LOG.trace("Updating output file: {}", (Object)this.outputFile);
            IOHelper.writeText((String)json.toJson(), (File)this.outputFile);
        } else {
            IOHelper.writeText((String)"{}", (File)this.outputFile);
        }
    }

    private void doActionTopProcessorsTask() throws IOException {
        DevConsole dc = ((DevConsoleRegistry)this.camelContext.getCamelContextExtension().getContextPlugin(DevConsoleRegistry.class)).resolveById("top");
        if (dc != null) {
            JsonObject json = (JsonObject)dc.call(DevConsole.MediaType.JSON, Map.of("CamelHttpPath", "/*"));
            LOG.trace("Updating output file: {}", (Object)this.outputFile);
            IOHelper.writeText((String)json.toJson(), (File)this.outputFile);
        } else {
            IOHelper.writeText((String)"{}", (File)this.outputFile);
        }
    }

    private void doActionThreadDumpTask() throws IOException {
        DevConsole dc = ((DevConsoleRegistry)this.camelContext.getCamelContextExtension().getContextPlugin(DevConsoleRegistry.class)).resolveById("thread");
        if (dc != null) {
            JsonObject json = (JsonObject)dc.call(DevConsole.MediaType.JSON, Map.of("stackTrace", "true"));
            LOG.trace("Updating output file: {}", (Object)this.outputFile);
            IOHelper.writeText((String)json.toJson(), (File)this.outputFile);
        } else {
            IOHelper.writeText((String)"{}", (File)this.outputFile);
        }
    }

    private void doActionKafkaTask() throws IOException {
        DevConsole dc = ((DevConsoleRegistry)this.camelContext.getCamelContextExtension().getContextPlugin(DevConsoleRegistry.class)).resolveById("kafka");
        if (dc != null) {
            JsonObject json = (JsonObject)dc.call(DevConsole.MediaType.JSON, Map.of("committed", "true"));
            LOG.trace("Updating output file: {}", (Object)this.outputFile);
            IOHelper.writeText((String)json.toJson(), (File)this.outputFile);
        } else {
            IOHelper.writeText((String)"{}", (File)this.outputFile);
        }
    }

    private void doActionTraceTask(JsonObject root) throws IOException {
        DevConsole dc = ((DevConsoleRegistry)this.camelContext.getCamelContextExtension().getContextPlugin(DevConsoleRegistry.class)).resolveById("trace");
        if (dc != null) {
            String enabled = root.getString("enabled");
            JsonObject json = enabled != null ? (JsonObject)dc.call(DevConsole.MediaType.JSON, Map.of("enabled", enabled)) : (JsonObject)dc.call(DevConsole.MediaType.JSON);
            LOG.trace("Updating output file: {}", (Object)this.outputFile);
            IOHelper.writeText((String)json.toJson(), (File)this.outputFile);
        } else {
            IOHelper.writeText((String)"{}", (File)this.outputFile);
        }
    }

    private void doActionBrowseTask(JsonObject root) throws IOException {
        DevConsole dc = ((DevConsoleRegistry)this.camelContext.getCamelContextExtension().getContextPlugin(DevConsoleRegistry.class)).resolveById("browse");
        if (dc != null) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("filter", root.getString("filter"));
            map.put("limit", root.getString("limit"));
            map.put("tail", root.getString("tail"));
            map.put("freshSize", root.getString("freshSize"));
            map.put("dump", root.getString("dump"));
            map.put("includeBody", root.getString("includeBody"));
            String bodyMaxChars = root.getString("bodyMaxChars");
            if (bodyMaxChars != null) {
                map.put("bodyMaxChars", bodyMaxChars);
            }
            JsonObject json = (JsonObject)dc.call(DevConsole.MediaType.JSON, map);
            LOG.trace("Updating output file: {}", (Object)this.outputFile);
            IOHelper.writeText((String)json.toJson(), (File)this.outputFile);
        } else {
            IOHelper.writeText((String)"{}", (File)this.outputFile);
        }
    }

    private void doActionReceiveTask(JsonObject root) throws Exception {
        DevConsole dc = ((DevConsoleRegistry)this.camelContext.getCamelContextExtension().getContextPlugin(DevConsoleRegistry.class)).resolveById("receive");
        if (dc != null) {
            StopWatch watch = new StopWatch();
            while (!this.camelContext.isStarted() && watch.taken() < 5000L) {
                Thread.sleep(100L);
            }
            String endpoint = root.getString("endpoint");
            JsonObject json = endpoint != null ? (JsonObject)dc.call(DevConsole.MediaType.JSON, Map.of("enabled", "true", "endpoint", endpoint)) : (JsonObject)dc.call(DevConsole.MediaType.JSON, Map.of("enabled", "false"));
            LOG.trace("Updating output file: {}", (Object)this.outputFile);
            IOHelper.writeText((String)json.toJson(), (File)this.outputFile);
        } else {
            IOHelper.writeText((String)"{}", (File)this.outputFile);
        }
    }

    private void doActionBeanTask(JsonObject root) throws IOException {
        JsonObject json;
        String filter = root.getStringOrDefault("filter", "");
        String properties = root.getStringOrDefault("properties", "true");
        String nulls = root.getStringOrDefault("nulls", "true");
        String internal = root.getStringOrDefault("internal", "false");
        Map<String, String> options = Map.of("filter", filter, "properties", properties, "nulls", nulls, "internal", internal);
        JsonObject answer = new JsonObject();
        DevConsole dc1 = ((DevConsoleRegistry)this.camelContext.getCamelContextExtension().getContextPlugin(DevConsoleRegistry.class)).resolveById("bean");
        DevConsole dc2 = ((DevConsoleRegistry)this.camelContext.getCamelContextExtension().getContextPlugin(DevConsoleRegistry.class)).resolveById("bean-model");
        if (dc1 != null) {
            json = (JsonObject)dc1.call(DevConsole.MediaType.JSON, options);
            answer.put((Object)"beans", (Object)json.getMap("beans"));
        }
        if (dc2 != null) {
            json = (JsonObject)dc2.call(DevConsole.MediaType.JSON, options);
            answer.put((Object)"bean-models", (Object)json.getMap("beans"));
        }
        LOG.trace("Updating output file: {}", (Object)this.outputFile);
        IOHelper.writeText((String)answer.toJson(), (File)this.outputFile);
    }

    private void doActionResetStatsTask() throws Exception {
        ManagedCamelContext mcc = (ManagedCamelContext)this.camelContext.getCamelContextExtension().getContextPlugin(ManagedCamelContext.class);
        if (mcc != null) {
            mcc.getManagedCamelContext().reset(true);
        }
    }

    private void doActionDebugTask(JsonObject root) throws Exception {
        DevConsole dc = ((DevConsoleRegistry)this.camelContext.getCamelContextExtension().getContextPlugin(DevConsoleRegistry.class)).resolveById("debug");
        if (dc != null) {
            String cmd = root.getStringOrDefault("command", "");
            String bp = root.getStringOrDefault("breakpoint", "");
            String history = root.getStringOrDefault("history", "false");
            JsonObject json = (JsonObject)dc.call(DevConsole.MediaType.JSON, Map.of("command", cmd, "breakpoint", bp, "history", history));
            LOG.trace("Updating output file: {}", (Object)this.outputFile);
            IOHelper.writeText((String)json.toJson(), (File)this.outputFile);
        } else {
            IOHelper.writeText((String)"{}", (File)this.outputFile);
        }
    }

    private void doActionReloadTask() {
        ContextReloadStrategy cr = (ContextReloadStrategy)this.camelContext.hasService(ContextReloadStrategy.class);
        if (cr != null) {
            cr.onReload((Object)"Camel JBang");
        } else {
            ResourceReloadStrategy rr = (ResourceReloadStrategy)this.camelContext.hasService(ResourceReloadStrategy.class);
            if (rr != null) {
                rr.onReload((Object)"Camel JBang");
            }
        }
    }

    private void doActionLoggerTask(JsonObject root) {
        try {
            String command = root.getString("command");
            if ("set-logging-level".equals(command)) {
                String logger = root.getString("logger-name");
                String level = root.getString("logging-level");
                LoggerHelper.changeLoggingLevel(logger, level);
            }
        }
        catch (Exception e) {
            LOG.warn("Error changing logging level due to {}. This exception is ignored.", (Object)e.getMessage(), (Object)e);
        }
    }

    private void doActionRouteTask(JsonObject root) {
        String[] patterns = root.getString("id").split(",");
        boolean all = patterns.length == 1 && "*".equals(patterns[0]);
        List<String> ids = all ? List.of("*") : this.camelContext.getRoutes().stream().map(Route::getRouteId).filter(routeId -> {
            for (String p : patterns) {
                if (!PatternHelper.matchPattern((String)routeId, (String)p)) continue;
                return true;
            }
            return false;
        }).toList();
        for (String id : ids) {
            String command = root.getString("command");
            try {
                if ("start".equals(command)) {
                    if ("*".equals(id)) {
                        this.camelContext.getRouteController().startAllRoutes();
                        continue;
                    }
                    this.camelContext.getRouteController().startRoute(id);
                    continue;
                }
                if ("stop".equals(command)) {
                    if ("*".equals(id)) {
                        this.camelContext.getRouteController().stopAllRoutes();
                        continue;
                    }
                    this.camelContext.getRouteController().stopRoute(id);
                    continue;
                }
                if ("suspend".equals(command)) {
                    if ("*".equals(id)) {
                        for (Route r : this.camelContext.getRoutes()) {
                            this.camelContext.getRouteController().suspendRoute(r.getRouteId());
                        }
                        continue;
                    }
                    this.camelContext.getRouteController().suspendRoute(id);
                    continue;
                }
                if (!"resume".equals(command)) continue;
                if ("*".equals(id)) {
                    for (Route r : this.camelContext.getRoutes()) {
                        this.camelContext.getRouteController().resumeRoute(r.getRouteId());
                    }
                    continue;
                }
                this.camelContext.getRouteController().resumeRoute(id);
            }
            catch (Exception e) {
                LOG.warn("Error {} route: {} due to: {}. This exception is ignored.", new Object[]{command, id, e.getMessage(), e});
            }
        }
    }

    JsonObject loadAction() {
        try {
            if (this.actionFile != null && this.actionFile.exists()) {
                FileInputStream fis = new FileInputStream(this.actionFile);
                String text = IOHelper.loadText((InputStream)fis);
                IOHelper.close((Closeable)fis);
                if (!text.isEmpty()) {
                    return (JsonObject)Jsoner.deserialize((String)text);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected void statusTask() {
        try {
            JsonObject vaults;
            JsonObject gc;
            JsonObject threads;
            JsonObject cl;
            JsonObject mem;
            RuntimeMXBean mb;
            JsonObject root = new JsonObject();
            JsonObject rc = new JsonObject();
            String dir = new File(".").getAbsolutePath();
            dir = FileUtil.onlyPath((String)dir);
            rc.put((Object)"pid", (Object)ProcessHandle.current().pid());
            rc.put((Object)"directory", (Object)dir);
            ProcessHandle.current().info().user().ifPresent(u -> rc.put((Object)"user", u));
            rc.put((Object)"platform", (Object)this.platform);
            if (this.platformVersion != null) {
                rc.put((Object)"platformVersion", (Object)this.platformVersion);
            }
            if (this.mainClass != null) {
                rc.put((Object)"mainClass", (Object)this.mainClass);
            }
            if ((mb = ManagementFactory.getRuntimeMXBean()) != null) {
                rc.put((Object)"javaVersion", (Object)mb.getVmVersion());
            }
            root.put((Object)"runtime", (Object)rc);
            DevConsoleRegistry dcr = (DevConsoleRegistry)this.camelContext.getCamelContextExtension().getContextPlugin(DevConsoleRegistry.class);
            if (dcr != null) {
                JsonObject json;
                DevConsole dc23;
                JsonObject json2;
                DevConsole dc22;
                JsonObject json3;
                DevConsole dc21;
                JsonObject json4;
                DevConsole dc20;
                JsonObject json5;
                DevConsole dc19;
                JsonObject json6;
                DevConsole dc18;
                JsonObject json7;
                DevConsole dc17;
                JsonObject json8;
                DevConsole dc16;
                JsonObject json9;
                DevConsole dc15;
                JsonObject json10;
                DevConsole dc14;
                JsonObject json11;
                DevConsole dc13;
                JsonObject json12;
                DevConsole dc12;
                JsonObject json13;
                DevConsole dc11;
                JsonObject json14;
                DevConsole dc10;
                JsonObject json15;
                DevConsole dc9;
                JsonObject json16;
                DevConsole dc8;
                JsonObject json17;
                DevConsole dc7;
                JsonObject json18;
                DevConsole dc6;
                JsonObject json19;
                DevConsole dc5;
                JsonObject json20;
                DevConsole dc4;
                JsonObject json21;
                DevConsole dc3;
                DevConsole dc = dcr.resolveById("context");
                DevConsole dc2 = dcr.resolveById("route");
                if (dc != null && dc2 != null) {
                    JsonObject json22 = (JsonObject)dc.call(DevConsole.MediaType.JSON);
                    JsonObject json23 = (JsonObject)dc2.call(DevConsole.MediaType.JSON, Map.of("processors", "true"));
                    if (json22 != null && json23 != null) {
                        root.put((Object)"context", (Object)json22);
                        root.put((Object)"routes", json23.get((Object)"routes"));
                    }
                }
                if ((dc3 = dcr.resolveById("endpoint")) != null && (json21 = (JsonObject)dc3.call(DevConsole.MediaType.JSON)) != null && !json21.isEmpty()) {
                    root.put((Object)"endpoints", (Object)json21);
                }
                if ((dc4 = dcr.resolveById("health")) != null && (json20 = (JsonObject)dc4.call(DevConsole.MediaType.JSON, Map.of("exposureLevel", "full"))) != null && !json20.isEmpty()) {
                    root.put((Object)"healthChecks", (Object)json20);
                }
                if ((dc5 = dcr.resolveById("event")) != null && (json19 = (JsonObject)dc5.call(DevConsole.MediaType.JSON)) != null && !json19.isEmpty()) {
                    root.put((Object)"events", (Object)json19);
                }
                if ((dc6 = dcr.resolveById("log")) != null && (json18 = (JsonObject)dc6.call(DevConsole.MediaType.JSON)) != null && !json18.isEmpty()) {
                    root.put((Object)"logger", (Object)json18);
                }
                if ((dc7 = dcr.resolveById("inflight")) != null && (json17 = (JsonObject)dc7.call(DevConsole.MediaType.JSON)) != null && !json17.isEmpty()) {
                    root.put((Object)"inflight", (Object)json17);
                }
                if ((dc8 = dcr.resolveById("blocked")) != null && (json16 = (JsonObject)dc8.call(DevConsole.MediaType.JSON)) != null && !json16.isEmpty()) {
                    root.put((Object)"blocked", (Object)json16);
                }
                if ((dc9 = dcr.resolveById("micrometer")) != null && (json15 = (JsonObject)dc9.call(DevConsole.MediaType.JSON)) != null && !json15.isEmpty()) {
                    root.put((Object)"micrometer", (Object)json15);
                }
                if ((dc10 = dcr.resolveById("resilience4j")) != null && (json14 = (JsonObject)dc10.call(DevConsole.MediaType.JSON)) != null && !json14.isEmpty()) {
                    root.put((Object)"resilience4j", (Object)json14);
                }
                if ((dc11 = dcr.resolveById("fault-tolerance")) != null && (json13 = (JsonObject)dc11.call(DevConsole.MediaType.JSON)) != null && !json13.isEmpty()) {
                    root.put((Object)"fault-tolerance", (Object)json13);
                }
                if ((dc12 = dcr.resolveById("circuit-breaker")) != null && (json12 = (JsonObject)dc12.call(DevConsole.MediaType.JSON)) != null && !json12.isEmpty()) {
                    root.put((Object)"circuit-breaker", (Object)json12);
                }
                if ((dc13 = dcr.resolveById("trace")) != null && (json11 = (JsonObject)dc13.call(DevConsole.MediaType.JSON)) != null && !json11.isEmpty()) {
                    root.put((Object)"trace", (Object)json11);
                }
                if ((dc14 = dcr.resolveById("consumer")) != null && (json10 = (JsonObject)dc14.call(DevConsole.MediaType.JSON)) != null && !json10.isEmpty()) {
                    root.put((Object)"consumers", (Object)json10);
                }
                if ((dc15 = dcr.resolveById("variables")) != null && (json9 = (JsonObject)dc15.call(DevConsole.MediaType.JSON)) != null && !json9.isEmpty()) {
                    root.put((Object)"variables", (Object)json9);
                }
                if ((dc16 = dcr.resolveById("transformers")) != null && (json8 = (JsonObject)dc16.call(DevConsole.MediaType.JSON)) != null && !json8.isEmpty()) {
                    root.put((Object)"transformers", (Object)json8);
                }
                if ((dc17 = dcr.resolveById("service")) != null && (json7 = (JsonObject)dc17.call(DevConsole.MediaType.JSON)) != null && !json7.isEmpty()) {
                    root.put((Object)"services", (Object)json7);
                }
                if ((dc18 = dcr.resolveById("platform-http")) != null && (json6 = (JsonObject)dc18.call(DevConsole.MediaType.JSON)) != null && !json6.isEmpty()) {
                    root.put((Object)"platform-http", (Object)json6);
                }
                if ((dc19 = dcr.resolveById("rest")) != null && (json5 = (JsonObject)dc19.call(DevConsole.MediaType.JSON)) != null && !json5.isEmpty()) {
                    root.put((Object)"rests", (Object)json5);
                }
                if ((dc20 = dcr.resolveById("kafka")) != null && (json4 = (JsonObject)dc20.call(DevConsole.MediaType.JSON)) != null && !json4.isEmpty()) {
                    root.put((Object)"kafka", (Object)json4);
                }
                if ((dc21 = dcr.resolveById("properties")) != null && (json3 = (JsonObject)dc21.call(DevConsole.MediaType.JSON)) != null && !json3.isEmpty()) {
                    root.put((Object)"properties", (Object)json3);
                }
                if ((dc22 = dcr.resolveById("main-configuration")) != null && (json2 = (JsonObject)dc22.call(DevConsole.MediaType.JSON)) != null && !json2.isEmpty()) {
                    root.put((Object)"main-configuration", (Object)json2);
                }
                if ((dc23 = dcr.resolveById("receive")) != null && (json = (JsonObject)dc23.call(DevConsole.MediaType.JSON)) != null && !json.isEmpty()) {
                    root.put((Object)"receive", (Object)json);
                }
            }
            if ((mem = this.collectMemory()) != null) {
                root.put((Object)"memory", (Object)mem);
            }
            if ((cl = this.collectClassLoading()) != null) {
                root.put((Object)"classLoading", (Object)cl);
            }
            if ((threads = this.collectThreads()) != null) {
                root.put((Object)"threads", (Object)threads);
            }
            if ((gc = this.collectGC()) != null) {
                root.put((Object)"gc", (Object)gc);
            }
            if (!(vaults = this.collectVaults()).isEmpty()) {
                root.put((Object)"vaults", (Object)vaults);
            }
            LOG.trace("Updating status file: {}", (Object)this.statusFile);
            IOHelper.writeText((String)root.toJson(), (File)this.statusFile);
        }
        catch (Exception e) {
            LOG.trace("Error updating status file: {} due to: {}. This exception is ignored.", new Object[]{this.statusFile, e.getMessage(), e});
        }
    }

    protected void traceTask() {
        String data;
        JsonArray arr;
        JsonObject json;
        try {
            DevConsole dc12 = ((DevConsoleRegistry)this.camelContext.getCamelContextExtension().getContextPlugin(DevConsoleRegistry.class)).resolveById("trace");
            if (dc12 != null) {
                json = (JsonObject)dc12.call(DevConsole.MediaType.JSON, Map.of("dump", "true"));
                arr = (JsonArray)json.getCollection("traces");
                if (this.traceFilePos > 0L) {
                    arr.removeIf(r -> {
                        JsonObject jo = (JsonObject)r;
                        return jo.getLong("uid") <= this.traceFilePos;
                    });
                }
                if (arr != null && !arr.isEmpty()) {
                    LOG.trace("Updating trace file: {}", (Object)this.traceFile);
                    data = json.toJson() + System.lineSeparator();
                    IOHelper.appendText((String)data, (File)this.traceFile);
                    json = (JsonObject)arr.getMap(arr.size() - 1);
                    this.traceFilePos = json.getLong("uid");
                }
            }
        }
        catch (Exception e) {
            LOG.trace("Error updating trace file: {} due to: {}. This exception is ignored.", new Object[]{this.traceFile, e.getMessage(), e});
        }
        try {
            DevConsole dc13 = ((DevConsoleRegistry)this.camelContext.getCamelContextExtension().getContextPlugin(DevConsoleRegistry.class)).resolveById("debug");
            if (dc13 != null) {
                json = (JsonObject)dc13.call(DevConsole.MediaType.JSON);
                LOG.trace("Updating debug file: {}", (Object)this.debugFile);
                String data2 = json.toJson() + System.lineSeparator();
                IOHelper.writeText((String)data2, (File)this.debugFile);
            }
        }
        catch (Exception e) {
            LOG.trace("Error updating debug file: {} due to: {}. This exception is ignored.", new Object[]{this.debugFile, e.getMessage(), e});
        }
        try {
            DevConsole dc14 = ((DevConsoleRegistry)this.camelContext.getCamelContextExtension().getContextPlugin(DevConsoleRegistry.class)).resolveById("receive");
            if (dc14 != null) {
                json = (JsonObject)dc14.call(DevConsole.MediaType.JSON, Map.of("dump", "true"));
                arr = (JsonArray)json.getCollection("messages");
                if (this.receiveFilePos > 0L) {
                    arr.removeIf(r -> {
                        JsonObject jo = (JsonObject)r;
                        return jo.getLong("uid") <= this.receiveFilePos;
                    });
                }
                if (arr != null && !arr.isEmpty()) {
                    LOG.trace("Updating receive file: {}", (Object)this.receiveFile);
                    data = json.toJson() + System.lineSeparator();
                    IOHelper.appendText((String)data, (File)this.receiveFile);
                    json = (JsonObject)arr.getMap(arr.size() - 1);
                    this.receiveFilePos = json.getLong("uid");
                }
            }
        }
        catch (Exception e) {
            LOG.trace("Error updating receive file: {} due to: {}. This exception is ignored.", new Object[]{this.receiveFile, e.getMessage(), e});
        }
    }

    private JsonObject collectMemory() {
        MemoryMXBean mb = ManagementFactory.getMemoryMXBean();
        if (mb != null) {
            JsonObject root = new JsonObject();
            root.put((Object)"heapMemoryUsed", (Object)mb.getHeapMemoryUsage().getUsed());
            root.put((Object)"heapMemoryCommitted", (Object)mb.getHeapMemoryUsage().getCommitted());
            root.put((Object)"heapMemoryMax", (Object)mb.getHeapMemoryUsage().getMax());
            root.put((Object)"nonHeapMemoryUsed", (Object)mb.getNonHeapMemoryUsage().getUsed());
            root.put((Object)"nonHeapMemoryCommitted", (Object)mb.getNonHeapMemoryUsage().getCommitted());
            return root;
        }
        return null;
    }

    private JsonObject collectClassLoading() {
        ClassLoadingMXBean cb = ManagementFactory.getClassLoadingMXBean();
        if (cb != null) {
            JsonObject root = new JsonObject();
            root.put((Object)"loadedClassCount", (Object)cb.getLoadedClassCount());
            root.put((Object)"unloadedClassCount", (Object)cb.getUnloadedClassCount());
            root.put((Object)"totalLoadedClassCount", (Object)cb.getTotalLoadedClassCount());
            return root;
        }
        return null;
    }

    private JsonObject collectThreads() {
        ThreadMXBean tb = ManagementFactory.getThreadMXBean();
        if (tb != null) {
            JsonObject root = new JsonObject();
            root.put((Object)"threadCount", (Object)tb.getThreadCount());
            root.put((Object)"peakThreadCount", (Object)tb.getPeakThreadCount());
            return root;
        }
        return null;
    }

    private JsonObject collectGC() {
        List<GarbageCollectorMXBean> gcs = ManagementFactory.getGarbageCollectorMXBeans();
        if (gcs != null && !gcs.isEmpty()) {
            JsonObject root = new JsonObject();
            long count = 0L;
            long time = 0L;
            for (GarbageCollectorMXBean gc : gcs) {
                count += gc.getCollectionCount();
                time += gc.getCollectionTime();
            }
            root.put((Object)"collectionCount", (Object)count);
            root.put((Object)"collectionTime", (Object)time);
            return root;
        }
        return null;
    }

    private JsonObject collectVaults() {
        JsonObject json;
        Optional cmcKubernetes;
        JsonObject json2;
        Optional dcHashicorp;
        JsonObject json3;
        Optional dcKubernetes;
        JsonObject json4;
        Optional dcAzure;
        JsonObject json5;
        Optional dcGcp;
        JsonObject json6;
        JsonObject root = new JsonObject();
        Optional dcAws = PluginHelper.getDevConsoleResolver((CamelContext)this.camelContext).lookupDevConsole("aws-secrets");
        if (dcAws.isPresent() && (json6 = (JsonObject)((DevConsole)dcAws.get()).call(DevConsole.MediaType.JSON)) != null) {
            root.put((Object)"aws-secrets", (Object)json6);
        }
        if ((dcGcp = PluginHelper.getDevConsoleResolver((CamelContext)this.camelContext).lookupDevConsole("gcp-secrets")).isPresent() && (json5 = (JsonObject)((DevConsole)dcGcp.get()).call(DevConsole.MediaType.JSON)) != null) {
            root.put((Object)"gcp-secrets", (Object)json5);
        }
        if ((dcAzure = PluginHelper.getDevConsoleResolver((CamelContext)this.camelContext).lookupDevConsole("azure-secrets")).isPresent() && (json4 = (JsonObject)((DevConsole)dcAzure.get()).call(DevConsole.MediaType.JSON)) != null) {
            root.put((Object)"azure-secrets", (Object)json4);
        }
        if ((dcKubernetes = PluginHelper.getDevConsoleResolver((CamelContext)this.camelContext).lookupDevConsole("kubernetes-secrets")).isPresent() && (json3 = (JsonObject)((DevConsole)dcKubernetes.get()).call(DevConsole.MediaType.JSON)) != null) {
            root.put((Object)"kubernetes-secrets", (Object)json3);
        }
        if ((dcHashicorp = PluginHelper.getDevConsoleResolver((CamelContext)this.camelContext).lookupDevConsole("hashicorp-secrets")).isPresent() && (json2 = (JsonObject)((DevConsole)dcHashicorp.get()).call(DevConsole.MediaType.JSON)) != null) {
            root.put((Object)"hashicorp-secrets", (Object)json2);
        }
        if ((cmcKubernetes = PluginHelper.getDevConsoleResolver((CamelContext)this.camelContext).lookupDevConsole("kubernetes-configmaps")).isPresent() && (json = (JsonObject)((DevConsole)cmcKubernetes.get()).call(DevConsole.MediaType.JSON)) != null) {
            root.put((Object)"kubernetes-configmaps", (Object)json);
        }
        return root;
    }

    protected void doStop() throws Exception {
        if (this.lockFile != null) {
            FileUtil.deleteFile((File)this.lockFile);
        }
        if (this.statusFile != null) {
            FileUtil.deleteFile((File)this.statusFile);
        }
        if (this.actionFile != null) {
            FileUtil.deleteFile((File)this.actionFile);
        }
        if (this.outputFile != null) {
            FileUtil.deleteFile((File)this.outputFile);
        }
        if (this.traceFile != null) {
            FileUtil.deleteFile((File)this.traceFile);
        }
        if (this.debugFile != null) {
            FileUtil.deleteFile((File)this.debugFile);
        }
        if (this.receiveFile != null) {
            FileUtil.deleteFile((File)this.receiveFile);
        }
        if (this.executor != null) {
            this.camelContext.getExecutorServiceManager().shutdown((ExecutorService)this.executor);
            this.executor = null;
        }
        ServiceHelper.stopService((Object[])new Object[]{this.producer, this.consumer});
    }

    private static String getPid() {
        return String.valueOf(ProcessHandle.current().pid());
    }

    private static File createLockFile(String name) {
        File answer = null;
        if (name != null) {
            File dir = new File(System.getProperty("user.home"), ".camel");
            try {
                dir.mkdirs();
                answer = new File(dir, name);
                if (!answer.exists()) {
                    answer.createNewFile();
                }
                answer.deleteOnExit();
            }
            catch (Exception e) {
                answer = null;
            }
        }
        return answer;
    }
}

