/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.catalog;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.CamelCatalogJSonSchemaResolver;
import org.apache.camel.catalog.DefaultRuntimeProvider;
import org.apache.camel.catalog.DefaultVersionManager;
import org.apache.camel.catalog.RuntimeProvider;
import org.apache.camel.catalog.VersionHelper;
import org.apache.camel.catalog.VersionManager;
import org.apache.camel.catalog.impl.AbstractCamelCatalog;
import org.apache.camel.catalog.impl.CatalogHelper;
import org.apache.camel.tooling.model.BaseModel;
import org.apache.camel.tooling.model.ComponentModel;
import org.apache.camel.tooling.model.DataFormatModel;
import org.apache.camel.tooling.model.EipModel;
import org.apache.camel.tooling.model.JsonMapper;
import org.apache.camel.tooling.model.LanguageModel;
import org.apache.camel.tooling.model.MainModel;
import org.apache.camel.tooling.model.OtherModel;
import org.apache.camel.util.json.JsonObject;
import org.w3c.dom.Document;

public class DefaultCamelCatalog
extends AbstractCamelCatalog
implements CamelCatalog {
    private static final String MODELS_CATALOG = "org/apache/camel/catalog/models.properties";
    private static final String MODEL_DIR = "org/apache/camel/catalog/models";
    private static final String DOC_DIR = "org/apache/camel/catalog/docs";
    private static final String ARCHETYPES_CATALOG = "org/apache/camel/catalog/archetypes/archetype-catalog.xml";
    private static final String SCHEMAS_XML = "org/apache/camel/catalog/schemas";
    private static final String MAIN_DIR = "org/apache/camel/catalog/main";
    private final VersionHelper version = new VersionHelper();
    private final Map<String, String> extraComponents = new HashMap<String, String>();
    private final Map<String, String> extraComponentsJSonSchema = new HashMap<String, String>();
    private final Map<String, String> extraDataFormats = new HashMap<String, String>();
    private final Map<String, String> extraDataFormatsJSonSchema = new HashMap<String, String>();
    private final Map<String, Object> cache = new HashMap<String, Object>();
    private boolean caching;
    private VersionManager versionManager = new DefaultVersionManager(this);
    private RuntimeProvider runtimeProvider = new DefaultRuntimeProvider(this);

    public DefaultCamelCatalog() {
        this(false);
    }

    public DefaultCamelCatalog(boolean caching) {
        this.caching = caching;
        this.setJSonSchemaResolver(new CamelCatalogJSonSchemaResolver(this, this.extraComponents, this.extraComponentsJSonSchema, this.extraDataFormats, this.extraDataFormatsJSonSchema));
    }

    @Override
    public RuntimeProvider getRuntimeProvider() {
        return this.runtimeProvider;
    }

    @Override
    public void setRuntimeProvider(RuntimeProvider runtimeProvider) {
        this.runtimeProvider = runtimeProvider;
        this.runtimeProvider.setCamelCatalog(this);
        this.cache.remove("findComponentNames");
        this.cache.remove("listComponentsAsJson");
        this.cache.remove("findDataFormatNames");
        this.cache.remove("listDataFormatsAsJson");
        this.cache.remove("findLanguageNames");
        this.cache.remove("listLanguagesAsJson");
    }

    @Override
    public void enableCache() {
        this.caching = true;
    }

    @Override
    public boolean isCaching() {
        return this.caching;
    }

    @Override
    public void setVersionManager(VersionManager versionManager) {
        this.versionManager = versionManager;
    }

    @Override
    public VersionManager getVersionManager() {
        return this.versionManager;
    }

    @Override
    public void addComponent(String name, String className) {
        this.extraComponents.put(name, className);
        this.cache.remove("findComponentNames");
        this.cache.remove("findComponentLabels");
        this.cache.remove("listComponentsAsJson");
    }

    @Override
    public void addComponent(String name, String className, String jsonSchema) {
        this.addComponent(name, className);
        if (jsonSchema != null) {
            this.extraComponentsJSonSchema.put(name, jsonSchema);
        }
    }

    @Override
    public void addDataFormat(String name, String className) {
        this.extraDataFormats.put(name, className);
        this.cache.remove("findDataFormatNames");
        this.cache.remove("findDataFormatLabels");
        this.cache.remove("listDataFormatsAsJson");
    }

    @Override
    public void addDataFormat(String name, String className, String jsonSchema) {
        this.addDataFormat(name, className);
        if (jsonSchema != null) {
            this.extraDataFormatsJSonSchema.put(name, jsonSchema);
        }
    }

    @Override
    public String getCatalogVersion() {
        return this.version.getVersion();
    }

    @Override
    public boolean loadVersion(String version) {
        if (version.equals(this.versionManager.getLoadedVersion())) {
            return true;
        }
        if (this.versionManager.loadVersion(version)) {
            this.cache.clear();
            return true;
        }
        return false;
    }

    @Override
    public String getLoadedVersion() {
        return this.versionManager.getLoadedVersion();
    }

    @Override
    public String getRuntimeProviderLoadedVersion() {
        return this.versionManager.getRuntimeProviderLoadedVersion();
    }

    @Override
    public boolean loadRuntimeProviderVersion(String groupId, String artifactId, String version) {
        return this.versionManager.loadRuntimeProviderVersion(groupId, artifactId, version);
    }

    @Override
    public List<String> findComponentNames() {
        return this.cache("findComponentNames", () -> Stream.of(this.runtimeProvider.findComponentNames(), this.extraComponents.keySet()).flatMap(Collection::stream).sorted().collect(Collectors.toList()));
    }

    @Override
    public List<String> findDataFormatNames() {
        return this.cache("findDataFormatNames", () -> Stream.of(this.runtimeProvider.findDataFormatNames(), this.extraDataFormats.keySet()).flatMap(Collection::stream).sorted().collect(Collectors.toList()));
    }

    @Override
    public List<String> findLanguageNames() {
        return this.cache("findLanguageNames", this.runtimeProvider::findLanguageNames);
    }

    @Override
    public List<String> findModelNames() {
        return this.cache("findModelNames", () -> {
            try (InputStream is = this.versionManager.getResourceAsStream(MODELS_CATALOG);){
                List list = CatalogHelper.loadLines((InputStream)is);
                return list;
            }
            catch (IOException e) {
                return Collections.emptyList();
            }
        });
    }

    @Override
    public List<String> findOtherNames() {
        return this.cache("findOtherNames", this.runtimeProvider::findOtherNames);
    }

    @Override
    public List<String> findModelNames(String filter) {
        return this.findNames(filter, this::findModelNames, this::eipModel);
    }

    @Override
    public List<String> findComponentNames(String filter) {
        return this.findNames(filter, this::findComponentNames, this::componentModel);
    }

    @Override
    public List<String> findDataFormatNames(String filter) {
        return this.findNames(filter, this::findDataFormatNames, this::dataFormatModel);
    }

    @Override
    public List<String> findLanguageNames(String filter) {
        return this.findNames(filter, this::findLanguageNames, this::languageModel);
    }

    @Override
    public List<String> findOtherNames(String filter) {
        return this.findNames(filter, this::findOtherNames, this::otherModel);
    }

    private List<String> findNames(String filter, Supplier<List<String>> findNames, Function<String, ? extends BaseModel<?>> modelLoader) {
        ArrayList<String> answer = new ArrayList<String>();
        List<String> names = findNames.get();
        for (String name : names) {
            String[] parts;
            BaseModel<?> model = modelLoader.apply(name);
            if (model == null) continue;
            String label = model.getLabel();
            for (String part : parts = label.split(",")) {
                try {
                    if (!part.equalsIgnoreCase(filter) && !CatalogHelper.matchWildcard((String)part, (String)filter) && !part.matches(filter)) continue;
                    answer.add(name);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    // empty catch block
                }
            }
        }
        return answer;
    }

    @Override
    public String modelJSonSchema(String name) {
        return this.cache("eip-" + name, name, x$0 -> super.modelJSonSchema(x$0));
    }

    public EipModel eipModel(String name) {
        return this.cache("eip-model-" + name, name, x$0 -> super.eipModel(x$0));
    }

    @Override
    public String componentJSonSchema(String name) {
        return this.cache("component-" + name, name, x$0 -> super.componentJSonSchema(x$0));
    }

    public ComponentModel componentModel(String name) {
        return this.cache("component-model-" + name, name, x$0 -> super.componentModel(x$0));
    }

    @Override
    public String dataFormatJSonSchema(String name) {
        return this.cache("dataformat-" + name, name, x$0 -> super.dataFormatJSonSchema(x$0));
    }

    public DataFormatModel dataFormatModel(String name) {
        return this.cache("dataformat-model-" + name, name, x$0 -> super.dataFormatModel(x$0));
    }

    @Override
    public String languageJSonSchema(String name) {
        return this.cache("language-" + name, name, x$0 -> super.languageJSonSchema(x$0));
    }

    public LanguageModel languageModel(String name) {
        return this.cache("language-model-" + name, name, x$0 -> super.languageModel(x$0));
    }

    @Override
    public String otherJSonSchema(String name) {
        return this.cache("other-" + name, name, x$0 -> super.otherJSonSchema(x$0));
    }

    public OtherModel otherModel(String name) {
        return this.cache("other-model-" + name, name, x$0 -> super.otherModel(x$0));
    }

    public String mainJSonSchema() {
        return this.cache("main", "main", k -> super.mainJSonSchema());
    }

    public MainModel mainModel() {
        return this.cache("main-model", "main-model", k -> super.mainModel());
    }

    @Override
    public String componentAsciiDoc(String name) {
        String answer = this.doComponentAsciiDoc(name);
        if (answer == null) {
            List<String> names = this.findComponentNames();
            for (String alternative : names) {
                String first;
                String schemes = this.getAlternativeComponentName(alternative, name);
                if (schemes == null || !schemes.contains(name) || Objects.equals(first = schemes.split(",")[0], name)) continue;
                return this.componentAsciiDoc(first);
            }
        }
        return answer;
    }

    @Override
    public String componentHtmlDoc(String name) {
        String answer = this.doComponentHtmlDoc(name);
        if (answer == null) {
            List<String> names = this.findComponentNames();
            for (String alternative : names) {
                String schemes = this.getAlternativeComponentName(alternative, name);
                if (schemes == null || !schemes.contains(name)) continue;
                String first = schemes.split(",")[0];
                return this.componentHtmlDoc(first);
            }
        }
        return answer;
    }

    private String getAlternativeComponentName(String componentName, String alternativeTo) {
        ComponentModel model;
        String json = this.componentJSonSchema(componentName);
        if (json.contains("alternativeSchemes") && json.contains(alternativeTo) && (model = this.componentModel(componentName)) != null) {
            return model.getAlternativeSchemes();
        }
        return null;
    }

    private String doComponentAsciiDoc(String componentName) {
        String name = componentName.equals("imap") || componentName.equals("imaps") || componentName.equals("pop3") || componentName.equals("pop3s") || componentName.equals("smtp") || componentName.equals("smtps") ? "mail" : componentName;
        String file = "org/apache/camel/catalog/docs/" + name + "-component.adoc";
        return this.cache(file, () -> {
            if (this.findComponentNames().contains(componentName)) {
                return this.loadResource(file);
            }
            if (this.extraComponents.containsKey(name)) {
                String className = this.extraComponents.get(name);
                String packageName = className.substring(0, className.lastIndexOf(46));
                packageName = packageName.replace('.', '/');
                String path = packageName + "/" + name + "-component.adoc";
                return this.loadResource(path);
            }
            return null;
        });
    }

    private String doComponentHtmlDoc(String componentName) {
        String name = componentName.equals("imap") || componentName.equals("imaps") || componentName.equals("pop3") || componentName.equals("pop3s") || componentName.equals("smtp") || componentName.equals("smtps") ? "mail" : componentName;
        String file = "org/apache/camel/catalog/docs/" + name + "-component.html";
        return this.cache(file, () -> {
            if (this.findComponentNames().contains(name)) {
                return this.loadResource(file);
            }
            if (this.extraComponents.containsKey(name)) {
                String className = this.extraComponents.get(name);
                String packageName = className.substring(0, className.lastIndexOf(46));
                packageName = packageName.replace('.', '/');
                String path = packageName + "/" + name + "-component.html";
                return this.loadResource(path);
            }
            return null;
        });
    }

    @Override
    public String dataFormatAsciiDoc(String dataformatName) {
        String name = dataformatName.startsWith("bindy") ? "bindy" : (dataformatName.startsWith("univocity") ? "univocity" : dataformatName);
        String file = "org/apache/camel/catalog/docs/" + name + "-dataformat.adoc";
        return this.cache(file, () -> {
            if (this.findDataFormatNames().contains(dataformatName)) {
                return this.loadResource(file);
            }
            if (this.extraDataFormats.containsKey(name)) {
                String className = this.extraDataFormats.get(name);
                String packageName = className.substring(0, className.lastIndexOf(46));
                packageName = packageName.replace('.', '/');
                String path = packageName + "/" + name + "-dataformat.adoc";
                return this.loadResource(path);
            }
            return null;
        });
    }

    @Override
    public String dataFormatHtmlDoc(String dataformatName) {
        String name = dataformatName.startsWith("bindy") ? "bindy" : (dataformatName.startsWith("univocity") ? "univocity" : dataformatName);
        String file = "org/apache/camel/catalog/docs/" + name + "-dataformat.html";
        return this.cache(file, () -> {
            if (this.findDataFormatNames().contains(name)) {
                return this.loadResource(file);
            }
            if (this.extraDataFormats.containsKey(name)) {
                String className = this.extraDataFormats.get(name);
                String packageName = className.substring(0, className.lastIndexOf(46));
                packageName = packageName.replace('.', '/');
                String path = packageName + "/" + name + "-dataformat.html";
                return this.loadResource(path);
            }
            return null;
        });
    }

    @Override
    public String languageAsciiDoc(String name) {
        if ("method".equals(name)) {
            name = "bean";
        }
        String file = "org/apache/camel/catalog/docs/" + name + "-language.adoc";
        return this.cache(file, this::loadResource);
    }

    @Override
    public String languageHtmlDoc(String name) {
        if ("method".equals(name)) {
            name = "bean";
        }
        String file = "org/apache/camel/catalog/docs/" + name + "-language.html";
        return this.cache(file, this::loadResource);
    }

    @Override
    public String otherAsciiDoc(String name) {
        String file = "org/apache/camel/catalog/docs/" + name + ".adoc";
        return this.cache(file, this::loadResource);
    }

    @Override
    public String otherHtmlDoc(String name) {
        String file = "org/apache/camel/catalog/docs/" + name + "-other.html";
        return this.cache(file, this::loadResource);
    }

    @Override
    public Set<String> findModelLabels() {
        return this.cache("findModelLabels", () -> this.findLabels(this::findModelNames, this::eipModel));
    }

    @Override
    public Set<String> findComponentLabels() {
        return this.cache("findComponentLabels", () -> this.findLabels(this::findComponentNames, this::componentModel));
    }

    @Override
    public Set<String> findDataFormatLabels() {
        return this.cache("findDataFormatLabels", () -> this.findLabels(this::findDataFormatNames, this::dataFormatModel));
    }

    @Override
    public Set<String> findLanguageLabels() {
        return this.cache("findLanguageLabels", () -> this.findLabels(this::findLanguageNames, this::languageModel));
    }

    @Override
    public Set<String> findOtherLabels() {
        return this.cache("findOtherLabels", () -> this.findLabels(this::findOtherNames, this::otherModel));
    }

    private SortedSet<String> findLabels(Supplier<List<String>> findNames, Function<String, ? extends BaseModel<?>> loadModel) {
        TreeSet<String> answer = new TreeSet<String>();
        List<String> names = findNames.get();
        for (String name : names) {
            BaseModel<?> model = loadModel.apply(name);
            if (model == null) continue;
            String label = model.getLabel();
            String[] parts = label.split(",");
            Collections.addAll(answer, parts);
        }
        return answer;
    }

    @Override
    public String archetypeCatalogAsXml() {
        return this.cache(ARCHETYPES_CATALOG, this::loadResource);
    }

    @Override
    public String springSchemaAsXml() {
        return this.cache("org/apache/camel/catalog/schemas/camel-spring.xsd", this::loadResource);
    }

    @Override
    public String mainJsonSchema() {
        return this.cache("org/apache/camel/catalog/main/camel-main-configuration-metadata.json", this::loadResource);
    }

    @Override
    public String listComponentsAsJson() {
        return this.cache("listComponentsAsJson", () -> JsonMapper.serialize(this.findComponentNames().stream().map(this::componentJSonSchema).map(JsonMapper::deserialize).map(o -> o.get((Object)"component")).collect(Collectors.toList())));
    }

    @Override
    public String listDataFormatsAsJson() {
        return this.cache("listDataFormatsAsJson", () -> JsonMapper.serialize(this.findDataFormatNames().stream().map(this::dataFormatJSonSchema).map(JsonMapper::deserialize).map(o -> o.get((Object)"dataformat")).collect(Collectors.toList())));
    }

    @Override
    public String listLanguagesAsJson() {
        return this.cache("listLanguagesAsJson", () -> JsonMapper.serialize(this.findLanguageNames().stream().map(this::languageJSonSchema).map(JsonMapper::deserialize).map(o -> o.get((Object)"language")).collect(Collectors.toList())));
    }

    @Override
    public String listModelsAsJson() {
        return this.cache("listModelsAsJson", () -> JsonMapper.serialize(this.findModelNames().stream().map(this::modelJSonSchema).map(JsonMapper::deserialize).map(o -> o.get((Object)"model")).collect(Collectors.toList())));
    }

    @Override
    public String listOthersAsJson() {
        return this.cache("listOthersAsJson", () -> JsonMapper.serialize(this.findOtherNames().stream().map(this::otherJSonSchema).map(JsonMapper::deserialize).map(o -> o.get((Object)"other")).collect(Collectors.toList())));
    }

    @Override
    public String summaryAsJson() {
        return this.cache("summaryAsJson", () -> {
            JsonObject obj = new JsonObject();
            obj.put("version", this.getCatalogVersion());
            obj.put("eips", this.findModelNames().size());
            obj.put("components", this.findComponentNames().size());
            obj.put("dataformats", this.findDataFormatNames().size());
            obj.put("languages", this.findLanguageNames().size());
            obj.put("archetypes", this.getArchetypesCount());
            return JsonMapper.serialize((Object)obj);
        });
    }

    private int getArchetypesCount() {
        int archetypes = 0;
        try {
            String xml = this.archetypeCatalogAsXml();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
            dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", Boolean.TRUE);
            Document dom = dbf.newDocumentBuilder().parse(new ByteArrayInputStream(xml.getBytes()));
            Object val = XPathFactory.newInstance().newXPath().evaluate("count(/archetype-catalog/archetypes/archetype)", dom, XPathConstants.NUMBER);
            double num = (Double)val;
            archetypes = (int)num;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return archetypes;
    }

    private <T> T cache(String name, Supplier<T> loader) {
        if (this.caching) {
            Object t = this.cache.get(name);
            if (t == null && (t = loader.get()) != null) {
                this.cache.put(name, t);
            }
            return (T)t;
        }
        return loader.get();
    }

    private <T> T cache(String key, String name, Function<String, T> loader) {
        if (this.caching) {
            Object t = this.cache.get(key);
            if (t == null && (t = loader.apply(name)) != null) {
                this.cache.put(key, t);
            }
            return (T)t;
        }
        return loader.apply(name);
    }

    private <T> T cache(String name, Function<String, T> loader) {
        if (this.caching) {
            Object t = this.cache.get(name);
            if (t == null && (t = loader.apply(name)) != null) {
                this.cache.put(name, t);
            }
            return (T)t;
        }
        return loader.apply(name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String loadResource(String file) {
        try (InputStream is = this.versionManager.getResourceAsStream(file);){
            String string = is != null ? CatalogHelper.loadText((InputStream)is) : null;
            return string;
        }
        catch (IOException e) {
            return null;
        }
    }
}

